/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.zip.ZipError;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.lib.mappingio.MappingReader;
import net.fabricmc.loader.impl.lib.mappingio.MappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.format.MappingFormat;
import net.fabricmc.loader.impl.lib.mappingio.format.tiny.Tiny1FileReader;
import net.fabricmc.loader.impl.lib.mappingio.format.tiny.Tiny2FileReader;
import net.fabricmc.loader.impl.lib.mappingio.tree.MappingTree;
import net.fabricmc.loader.impl.lib.mappingio.tree.MemoryMappingTree;
import net.fabricmc.loader.impl.util.ManifestUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.loader.impl.util.mappings.FilteringMappingVisitor;
import org.jetbrains.annotations.Nullable;

public final class MappingConfiguration {
    private static final boolean FIX_PACKAGE_ACCESS = System.getProperty("fabric.fixPackageAccess") != null;
    private boolean initializedMetadata;
    private boolean initializedMappings;
    @Nullable
    private String gameId;
    @Nullable
    private String gameVersion;
    @Nullable
    private List<String> namespaces;
    @Nullable
    private MemoryMappingTree mappings;

    @Nullable
    public String getGameId() {
        this.initializeMetadata();
        return this.gameId;
    }

    @Nullable
    public String getGameVersion() {
        this.initializeMetadata();
        return this.gameVersion;
    }

    @Nullable
    public List<String> getNamespaces() {
        this.initializeMetadata();
        return this.namespaces;
    }

    public boolean matches(String gameId, String gameVersion) {
        this.initializeMetadata();
        return !(this.gameId != null && gameId != null && !gameId.equals(this.gameId) || this.gameVersion != null && gameVersion != null && !gameVersion.equals(this.gameVersion));
    }

    public MappingTree getMappings() {
        this.initializeMappings();
        return this.mappings;
    }

    public String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().isDevelopment() ? "named" : "intermediary";
    }

    public boolean requiresPackageAccessHack() {
        return FIX_PACKAGE_ACCESS || this.getTargetNamespace().equals("named");
    }

    /*
     * Unable to fully structure code
     */
    private void initializeMetadata() {
        block13: {
            if (this.initializedMetadata) {
                return;
            }
            connection = this.openMappings();
            try {
                if (connection == null) break block13;
                if (connection instanceof JarURLConnection && (manifest = ((JarURLConnection)connection).getManifest()) != null) {
                    this.gameId = ManifestUtil.getManifestValue(manifest, new Attributes.Name("Game-Id"));
                    this.gameVersion = ManifestUtil.getManifestValue(manifest, new Attributes.Name("Game-Version"));
                }
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    format = this.readMappingFormat(reader);
                    switch (1.$SwitchMap$net$fabricmc$mappingio$format$MappingFormat[format.ordinal()]) {
                        case 1: {
                            this.namespaces = Tiny1FileReader.getNamespaces(reader);
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            this.namespaces = Tiny2FileReader.getNamespaces(reader);
                            ** break;
lbl20:
                            // 1 sources

                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported mapping format: " + (Object)format);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading mapping metadata", e);
            }
        }
        this.initializedMetadata = true;
    }

    private void initializeMappings() {
        if (this.initializedMappings) {
            return;
        }
        this.initializeMetadata();
        URLConnection connection = this.openMappings();
        if (connection != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                long time = System.currentTimeMillis();
                this.mappings = new MemoryMappingTree();
                FilteringMappingVisitor mappingFilter = new FilteringMappingVisitor(this.mappings);
                MappingFormat format = this.readMappingFormat(reader);
                switch (format) {
                    case TINY_FILE: {
                        Tiny1FileReader.read(reader, (MappingVisitor)mappingFilter);
                        break;
                    }
                    case TINY_2_FILE: {
                        Tiny2FileReader.read(reader, (MappingVisitor)mappingFilter);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported mapping format: " + (Object)((Object)format));
                    }
                }
                Log.debug(LogCategory.MAPPINGS, "Loading mappings took %d ms", System.currentTimeMillis() - time);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading mappings", e);
            }
        }
        if (this.mappings == null) {
            Log.info(LogCategory.MAPPINGS, "Mappings not present!");
            this.mappings = new MemoryMappingTree();
        }
        this.initializedMappings = true;
    }

    @Nullable
    private URLConnection openMappings() {
        URL url = MappingConfiguration.class.getClassLoader().getResource("mappings/mappings.tiny");
        if (url != null) {
            try {
                return url.openConnection();
            }
            catch (IOException | ZipError e) {
                throw new RuntimeException("Error reading " + url, e);
            }
        }
        return null;
    }

    private MappingFormat readMappingFormat(BufferedReader reader) throws IOException {
        reader.mark(4096);
        MappingFormat format = MappingReader.detectFormat(reader);
        reader.reset();
        return format;
    }
}

