/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_3532;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.satisfy.brewery.Brewery;

public record RopeModel(float[] vertices, float[] uvs) {
    public static Builder builder(int initialCapacity) {
        return new Builder(initialCapacity);
    }

    public void render(class_4588 buffer, class_4587 poseStack, int bLight0, int bLight1, int sLight0, int sLight1) {
        class_1159 modelMatrix = poseStack.method_23760().method_23761();
        class_4581 normalMatrix = poseStack.method_23760().method_23762();
        int count = this.vertices.length / 3;
        for (int i = 0; i < count; ++i) {
            float f = (float)i % ((float)count / 2.0f) / ((float)count / 2.0f);
            int blockLight = (int)class_3532.method_16439((float)f, (float)bLight0, (float)bLight1);
            int skyLight = (int)class_3532.method_16439((float)f, (float)sLight0, (float)sLight1);
            int light = class_765.method_23687((int)blockLight, (int)skyLight);
            buffer.method_22918(modelMatrix, this.vertices[i * 3], this.vertices[i * 3 + 1], this.vertices[i * 3 + 2]).method_39415(-1).method_22913(this.uvs[i * 2], this.uvs[i * 2 + 1]).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 1.0f, 0.35f, 0.0f).method_1344();
        }
    }

    public static class Builder {
        private final List<Float> vertices;
        private final List<Float> uvs;
        private int size;

        public Builder(int initialCapacity) {
            this.vertices = new ArrayList<Float>(initialCapacity * 3);
            this.uvs = new ArrayList<Float>(initialCapacity * 2);
        }

        public Builder vertex(float x, float y, float z) {
            this.vertices.add(Float.valueOf(x));
            this.vertices.add(Float.valueOf(y));
            this.vertices.add(Float.valueOf(z));
            return this;
        }

        public Builder uv(float u, float v) {
            this.uvs.add(Float.valueOf(u));
            this.uvs.add(Float.valueOf(v));
            return this;
        }

        public void next() {
            ++this.size;
        }

        public RopeModel build() {
            if (this.vertices.size() != this.size * 3) {
                Brewery.LOGGER.error("Wrong count of vertices");
            }
            if (this.uvs.size() != this.size * 2) {
                Brewery.LOGGER.error("Wrong count of uvs");
            }
            return new RopeModel(this.toFloatArray(this.vertices), this.toFloatArray(this.uvs));
        }

        private float[] toFloatArray(List<Float> floats) {
            float[] array = new float[floats.size()];
            int i = 0;
            for (float f : floats) {
                array[i++] = f;
            }
            return array;
        }
    }
}

