/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.satisfy.brewery.effect.alcohol.AlcoholManager;
import net.satisfy.brewery.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends class_1747 {
    private final class_1291 effect;
    private final int baseDuration;

    public DrinkBlockItem(class_1291 effect, int duration, class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
        this.effect = effect;
        this.baseDuration = duration;
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)interactionHand);
    }

    @NotNull
    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 livingEntity) {
        class_1657 player;
        class_1799 returnStack = super.method_7861(itemStack, level, livingEntity);
        if (livingEntity instanceof class_1657 && !(player = (class_1657)livingEntity).method_7337()) {
            player.method_7270(new class_1799((class_1935)ObjectRegistry.BEER_MUG.get()));
        }
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            AlcoholManager.drinkAlcohol(serverPlayer);
            if (itemStack.method_7985() && Objects.requireNonNull(itemStack.method_7969()).method_10545("brewery.beer_quality")) {
                int quality = itemStack.method_7969().method_10550("brewery.beer_quality");
                class_1293 effectInstance = this.calculateEffectForQuality(quality);
                serverPlayer.method_6092(effectInstance);
            } else {
                class_1293 effectInstance = new class_1293(this.effect, this.baseDuration, 0);
                serverPlayer.method_6092(effectInstance);
            }
        }
        return returnStack;
    }

    @NotNull
    private class_1293 calculateEffectForQuality(int quality) {
        int durationMultiplier = 1;
        int effectLevel = switch (quality) {
            case 2 -> {
                durationMultiplier = 3;
                yield 2;
            }
            case 3 -> {
                durationMultiplier = 5;
                yield 3;
            }
            default -> 1;
        };
        return new class_1293(this.effect, this.baseDuration * durationMultiplier, effectLevel - 1);
    }

    public static void addQuality(class_1799 itemStack, int quality) {
        class_2487 nbtData = new class_2487();
        nbtData.method_10569("brewery.beer_quality", Math.min(Math.max(quality, 0), 3));
        itemStack.method_7980(nbtData);
    }

    public void addCount(class_1799 resultSack, int solved) {
        resultSack.method_7939(solved);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        int effectLevel;
        int beerQuality = stack.method_7985() && Objects.requireNonNull(stack.method_7969()).method_10545("brewery.beer_quality") ? stack.method_7969().method_10550("brewery.beer_quality") : 1;
        int durationMultiplier = 1;
        switch (beerQuality) {
            case 2: {
                durationMultiplier = 3;
                int n = 2;
                break;
            }
            case 3: {
                durationMultiplier = 5;
                int n = 3;
                break;
            }
            default: {
                int n = effectLevel = 1;
            }
        }
        if (this.effect != null) {
            class_5250 effectName = class_2561.method_43471((String)this.effect.method_5567());
            if (effectLevel > 1) {
                effectName.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("potion.potency." + (effectLevel - 1))));
            }
            class_5250 effectDuration = class_2561.method_43470((String)(" (" + class_1292.method_5577((class_1293)new class_1293(this.effect, this.baseDuration * durationMultiplier), (float)1.0f) + ")"));
            tooltip.add((class_2561)effectName.method_10852((class_2561)effectDuration).method_27692(this.effect.method_18792().method_18793()));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        }
        if (beerQuality > 1) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.brewery.beer_quality", (Object[])new Object[]{beerQuality}).method_27692(class_124.field_1065));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.brewery.canbeplaced").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}));
    }
}

