/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.satisfy.brewery.registry.ArmorMaterialRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;

public interface IBrewfestArmorSet {
    public static final class_1293 hardDrinkingEffect = new class_1293((class_1291)MobEffectRegistry.HARDDRINKING.get(), 280, 1);
    public static final Map<class_1741, class_1293> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorMaterialRegistry.BREWFEST_ARMOR, (Object)hardDrinkingEffect).build();

    default public boolean hasBrewfestSet(class_1657 player) {
        return IBrewfestArmorSet.hasBrewfestBoots(player) && IBrewfestArmorSet.hasBrewfestLeggings(player) && IBrewfestArmorSet.hasBrewfestBreastplate(player) && IBrewfestArmorSet.hasBrewfestHelmet(player);
    }

    default public void checkForSet(class_1657 player) {
        if (this.hasBrewfestSet(player)) {
            this.addStatusEffectForMaterial(player, new class_1293((class_1291)MobEffectRegistry.HARDDRINKING.get(), 280, 2));
        }
        this.hasBrewfest(player);
    }

    default public void hasBrewfest(class_1657 player) {
        for (Map.Entry<class_1741, class_1293> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_1741 mapArmorMaterial = entry.getKey();
            class_1293 mapStatusEffect = entry.getValue();
            if (!this.hasCorrectBrewfest(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapStatusEffect);
        }
    }

    private boolean hasCorrectBrewfest(class_1741 material, class_1657 player) {
        if (material.equals(ArmorMaterialRegistry.BREWFEST_ARMOR) || material.equals(ArmorMaterialRegistry.BREWFEST_DRESS) || material.equals(ArmorMaterialRegistry.BREWFEST_LEATHER)) {
            int slot = 1;
            if (!player.method_31548().method_7372(slot).method_7960()) {
                class_1738 armor = (class_1738)player.method_31548().method_7372(slot).method_7909();
                return armor.method_7686() == material;
            }
            return false;
        }
        return false;
    }

    default public void addStatusEffectForMaterial(class_1657 player, class_1293 mapStatusEffect) {
        boolean hasPlayerEffect = player.method_6059(mapStatusEffect.method_5579());
        if (!hasPlayerEffect || Objects.requireNonNull(player.method_6112(mapStatusEffect.method_5579())).method_5584() < 220) {
            player.method_6092(new class_1293(mapStatusEffect.method_5579(), mapStatusEffect.method_5584(), mapStatusEffect.method_5578(), true, false, true));
        }
    }

    public static boolean hasBrewfestBoots(class_1657 player) {
        if (player.method_31548().method_7372(0).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(0).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBrewfestArmorSet.isBrewfestBoots(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestBoots(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_ARMOR || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }

    public static boolean hasBrewfestLeggings(class_1657 player) {
        if (player.method_31548().method_7372(1).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(1).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBrewfestArmorSet.isBrewfestLeggings(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestLeggings(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_LEATHER || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_ARMOR;
    }

    public static boolean hasBrewfestBreastplate(class_1657 player) {
        if (player.method_31548().method_7372(2).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(2).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBrewfestArmorSet.isBrewfestBreastplate(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestBreastplate(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_ARMOR || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }

    public static boolean hasBrewfestHelmet(class_1657 player) {
        if (player.method_31548().method_7372(3).method_7960()) {
            return false;
        }
        class_1792 item = player.method_31548().method_7372(3).method_7909();
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return IBrewfestArmorSet.isBrewfestHelmet(armorItem);
        }
        return false;
    }

    private static boolean isBrewfestHelmet(class_1738 armorItem) {
        return armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_LEATHER || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_DRESS || armorItem.method_7686() == ArmorMaterialRegistry.BREWFEST_LEATHER;
    }
}

