/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import com.google.common.collect.Lists;
import de.cristelknight.doapi.Util;
import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1827;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2521;
import net.minecraft.class_2577;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3614;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.block.BagBlock;
import net.satisfy.brewery.block.BarCounterBlock;
import net.satisfy.brewery.block.BeerKegFlowerPotBlock;
import net.satisfy.brewery.block.BeerStandardBlock;
import net.satisfy.brewery.block.BeerStandardWallBlock;
import net.satisfy.brewery.block.BenchBlock;
import net.satisfy.brewery.block.BeverageBlock;
import net.satisfy.brewery.block.FoodBlock;
import net.satisfy.brewery.block.GingerBreadBlock;
import net.satisfy.brewery.block.HangingRope;
import net.satisfy.brewery.block.SideboardBlock;
import net.satisfy.brewery.block.SiloBlock;
import net.satisfy.brewery.block.StorageBlock;
import net.satisfy.brewery.block.TableBlock;
import net.satisfy.brewery.block.WallStorageBlock;
import net.satisfy.brewery.block.barrel.BigBarrelMainBlock;
import net.satisfy.brewery.block.barrel.BigBarrelMainHeadBlock;
import net.satisfy.brewery.block.barrel.BigBarrelRightBlock;
import net.satisfy.brewery.block.barrel.BigBarrelRightHeadBlock;
import net.satisfy.brewery.block.brewingstation.BrewKettleBlock;
import net.satisfy.brewery.block.brewingstation.BrewOvenBlock;
import net.satisfy.brewery.block.brewingstation.BrewTimerBlock;
import net.satisfy.brewery.block.brewingstation.BrewWhistleBlock;
import net.satisfy.brewery.block.crops.BarleyCropBlock;
import net.satisfy.brewery.block.crops.CornCropBlock;
import net.satisfy.brewery.block.crops.HopsCropBodyBlock;
import net.satisfy.brewery.block.crops.HopsCropHeadBlock;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.item.Breathalyzer;
import net.satisfy.brewery.item.BrewfestArmorItem;
import net.satisfy.brewery.item.BrewfestHatItem;
import net.satisfy.brewery.item.BrewfestHatRedItem;
import net.satisfy.brewery.item.DrinkBlockItem;
import net.satisfy.brewery.item.RopeItem;
import net.satisfy.brewery.item.SaturatedBlockItem;
import net.satisfy.brewery.item.SaturatedItem;
import net.satisfy.brewery.registry.ArmorMaterialRegistry;
import net.satisfy.brewery.registry.EntityRegistry;
import net.satisfy.brewery.registry.MobEffectRegistry;
import net.satisfy.brewery.registry.SoundEventRegistry;
import net.satisfy.brewery.util.BreweryFoodProperties;
import net.satisfy.brewery.util.BreweryIdentifier;
import org.jetbrains.annotations.Nullable;

public class ObjectRegistry {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"brewery", (class_5321)class_2378.field_25108);
    public static final Registrar<class_1792> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<class_2248> BLOCKS = DeferredRegister.create((String)"brewery", (class_5321)class_2378.field_25105);
    public static final Registrar<class_2248> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<class_2248> WILD_HOPS = ObjectRegistry.registerWithoutItem("wild_hops", () -> new class_2521(class_4970.class_2251.method_9630((class_4970)class_2246.field_10430)));
    public static final RegistrySupplier<class_2248> HOPS_CROP = ObjectRegistry.registerWithoutItem("hops_crop", () -> new HopsCropHeadBlock(ObjectRegistry.getBushSettings().method_9640()));
    public static final RegistrySupplier<class_2248> HOPS_CROP_BODY = ObjectRegistry.registerWithoutItem("hops_crop_body", () -> new HopsCropBodyBlock(ObjectRegistry.getBushSettings().method_9640()));
    public static final RegistrySupplier<class_1792> HOPS_SEEDS = ObjectRegistry.registerItem("hops_seeds", () -> new class_1747((class_2248)HOPS_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> HOPS = ObjectRegistry.registerItem("hops", () -> new class_1792(ObjectRegistry.getSettings().method_19265(class_4176.field_18638)));
    public static final RegistrySupplier<class_2248> BARLEY_CROP = ObjectRegistry.registerWithoutItem("barley_crop", () -> new BarleyCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<class_1792> BARLEY_SEEDS = ObjectRegistry.registerItem("barley_seeds", () -> new class_1747((class_2248)BARLEY_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> BARLEY = ObjectRegistry.registerItem("barley", () -> new class_1792(ObjectRegistry.getSettings().method_19265(class_4176.field_18638)));
    public static final RegistrySupplier<class_2248> CORN_CROP = ObjectRegistry.registerWithoutItem("corn_crop", () -> new CornCropBlock(ObjectRegistry.getBushSettings()));
    public static final RegistrySupplier<class_1792> CORN_SEEDS = ObjectRegistry.registerItem("corn_seeds", () -> new class_1747((class_2248)CORN_CROP.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> CORN = ObjectRegistry.registerItem("corn", () -> new class_1792(ObjectRegistry.getSettings().method_19265(class_4176.field_18638)));
    public static final RegistrySupplier<class_2248> DRIED_WHEAT = ObjectRegistry.registerWithItem("dried_wheat", () -> new BagBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10359)));
    public static final RegistrySupplier<class_2248> DRIED_BARLEY = ObjectRegistry.registerWithItem("dried_barley", () -> new BagBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10359)));
    public static final RegistrySupplier<class_2248> DRIED_CORN = ObjectRegistry.registerWithItem("dried_corn", () -> new BagBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10359)));
    public static final RegistrySupplier<class_2248> BENCH = ObjectRegistry.registerWithItem("bench", () -> new BenchBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161)));
    public static final RegistrySupplier<class_2248> TABLE = ObjectRegistry.registerWithItem("table", () -> new TableBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161)));
    public static final RegistrySupplier<class_2248> PATTERNED_WOOL = ObjectRegistry.registerWithItem("patterned_wool", () -> new class_2248(class_4970.class_2251.method_9630((class_4970)class_2246.field_10146)));
    public static final RegistrySupplier<class_2248> PATTERNED_CARPET = ObjectRegistry.registerWithItem("patterned_carpet", () -> new class_2577(class_4970.class_2251.method_9630((class_4970)class_2246.field_10106)));
    public static final RegistrySupplier<class_2248> CABINET = ObjectRegistry.registerWithItem("cabinet", () -> new StorageBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547), (class_3414)SoundEventRegistry.CABINET_OPEN.get(), (class_3414)SoundEventRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<class_2248> DRAWER = ObjectRegistry.registerWithItem("drawer", () -> new StorageBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547), (class_3414)SoundEventRegistry.DRAWER_OPEN.get(), (class_3414)SoundEventRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<class_2248> BAR_COUNTER = ObjectRegistry.registerWithItem("bar_counter", () -> new BarCounterBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_29292().method_9632(3.5f).method_9626(class_2498.field_11547).method_22488()));
    public static final RegistrySupplier<class_2248> SIDEBOARD = ObjectRegistry.registerWithItem("sideboard", () -> new SideboardBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_9632(2.5f).method_9626(class_2498.field_11547), (class_3414)SoundEventRegistry.DRAWER_OPEN.get(), (class_3414)SoundEventRegistry.DRAWER_CLOSE.get()));
    public static final RegistrySupplier<class_2248> WALL_CABINET = ObjectRegistry.registerWithItem("wall_cabinet", () -> new WallStorageBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547), (class_3414)SoundEventRegistry.CABINET_OPEN.get(), (class_3414)SoundEventRegistry.CABINET_CLOSE.get()));
    public static final RegistrySupplier<class_1792> BREATHALYZER = ObjectRegistry.registerItem("breathalyzer", () -> new Breathalyzer(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_2248> WOODEN_BREWINGSTATION = ObjectRegistry.registerWithItem("wooden_brewingstation", () -> new BrewKettleBlock(BrewMaterial.WOOD, class_4970.class_2251.method_9630((class_4970)class_2246.field_10161)));
    public static final RegistrySupplier<class_2248> COPPER_BREWINGSTATION = ObjectRegistry.registerWithItem("copper_brewingstation", () -> new BrewKettleBlock(BrewMaterial.COPPER, class_4970.class_2251.method_9630((class_4970)class_2246.field_27119)));
    public static final RegistrySupplier<class_2248> NETHERITE_BREWINGSTATION = ObjectRegistry.registerWithItem("netherite_brewingstation", () -> new BrewKettleBlock(BrewMaterial.NETHERITE, class_4970.class_2251.method_9630((class_4970)class_2246.field_22108)));
    public static final RegistrySupplier<class_2248> BREW_WHISTLE = ObjectRegistry.registerWithoutItem("brew_whistle", () -> new BrewWhistleBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_27119)));
    public static final RegistrySupplier<class_2248> BREW_OVEN = ObjectRegistry.registerWithoutItem("brew_oven", () -> new BrewOvenBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_27119)));
    public static final RegistrySupplier<class_2248> BREW_TIMER = ObjectRegistry.registerWithoutItem("brew_timer", () -> new BrewTimerBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_27119)));
    public static final RegistrySupplier<class_2248> SILO_WOOD = ObjectRegistry.registerWithItem("silo_wood", () -> new SiloBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10161).method_22488()));
    public static final RegistrySupplier<class_2248> SILO_COPPER = ObjectRegistry.registerWithItem("silo_copper", () -> new SiloBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_27119).method_22488()));
    public static final RegistrySupplier<class_2248> BARREL_MAIN = ObjectRegistry.registerWithItem("barrel_main", () -> new BigBarrelMainBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547)));
    public static final RegistrySupplier<class_2248> BARREL_MAIN_HEAD = ObjectRegistry.registerWithoutItem("barrel_main_head", () -> new BigBarrelMainHeadBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547)));
    public static final RegistrySupplier<class_2248> BARREL_RIGHT = ObjectRegistry.registerWithoutItem("barrel_right", () -> new BigBarrelRightBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547)));
    public static final RegistrySupplier<class_2248> BARREL_HEAD_RIGHT = ObjectRegistry.registerWithoutItem("barrel_head_right", () -> new BigBarrelRightHeadBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15932).method_9629(2.0f, 3.0f).method_9626(class_2498.field_11547)));
    public static final RegistrySupplier<class_1792> ROPE = ObjectRegistry.registerItem("rope", () -> new RopeItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_2248> HANGING_ROPE = ObjectRegistry.registerWithoutItem("hanging_rope", () -> new HangingRope(class_4970.class_2251.method_9630((class_4970)class_2246.field_10619)));
    public static final RegistrySupplier<class_2248> BEER_MUG = ObjectRegistry.registerWithItem("beer_mug", () -> new BeerKegFlowerPotBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10126)));
    public static final RegistrySupplier<class_2248> BEER_WHEAT = ObjectRegistry.registerWithItemeverage("beer_wheat", () -> new BeverageBlock(ObjectRegistry.getMugSettings()), MobEffectRegistry.SNOWWHITE, 600);
    public static final RegistrySupplier<class_2248> BEER_HOPS = ObjectRegistry.registerWithItemeverage("beer_hops", () -> new BeverageBlock(ObjectRegistry.getMugSettings()), MobEffectRegistry.PARTYSTARTER, 600);
    public static final RegistrySupplier<class_2248> BEER_BARLEY = ObjectRegistry.registerWithItemeverage("beer_barley", () -> new BeverageBlock(ObjectRegistry.getMugSettings()), MobEffectRegistry.PINTCHARISMA, 600);
    public static final RegistrySupplier<class_2248> BEER_HALEY = ObjectRegistry.registerWithItemeverage("beer_haley", () -> new BeverageBlock(ObjectRegistry.getMugSettings()), MobEffectRegistry.HALEY, 600);
    public static final RegistrySupplier<class_2248> WHISKEY_MAGGOALLAN = ObjectRegistry.registerWithItemeverage("whiskey_maggoallan", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings()), MobEffectRegistry.HEALINGTOUCH, 600);
    public static final RegistrySupplier<class_2248> WHISKEY_CARRASCONLABEL = ObjectRegistry.registerWithItemeverage("whiskey_carrasconlabel", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings()), MobEffectRegistry.RENEWINGTOUCH, 600);
    public static final RegistrySupplier<class_2248> WHISKEY_LILITUSINGLEMALT = ObjectRegistry.registerWithItemeverage("whiskey_lilitusinglemalt", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings()), MobEffectRegistry.PARTYSTARTER, 600);
    public static final RegistrySupplier<class_2248> WHISKEY_JOJANNIK = ObjectRegistry.registerWithItemeverage("whiskey_jojannik", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings()), MobEffectRegistry.TOXICTOUCH, 600);
    public static final RegistrySupplier<class_2248> WHISKEY_CRISTELWALKER = ObjectRegistry.registerWithItemeverage("whiskey_cristelwalker", () -> new BeverageBlock(ObjectRegistry.getBeverageSettings()), MobEffectRegistry.PROTECTIVETOUCH, 600);
    public static final RegistrySupplier<class_2248> MASHED_POTATOES_BLOCK = ObjectRegistry.registerWithoutItem("mashed_potatoes", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 1, BreweryFoodProperties.MASHED_POTATOES));
    public static final RegistrySupplier<class_2248> FRIED_CHICKEN_BLOCK = ObjectRegistry.registerWithoutItem("fried_chicken", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 1, BreweryFoodProperties.FRIED_CHICKEN));
    public static final RegistrySupplier<class_2248> HALF_CHICKEN_BLOCK = ObjectRegistry.registerWithoutItem("half_chicken", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 3, BreweryFoodProperties.HALF_CHICKEN));
    public static final RegistrySupplier<class_2248> PORK_KNUCKLE_BLOCK = ObjectRegistry.registerWithoutItem("pork_knuckle", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 2, BreweryFoodProperties.PORK_KNUCKLE));
    public static final RegistrySupplier<class_2248> POTATO_SALAD_BLOCK = ObjectRegistry.registerWithoutItem("potato_salad", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 1, BreweryFoodProperties.POTATO_SALAD));
    public static final RegistrySupplier<class_2248> DUMPLINGS_BLOCK = ObjectRegistry.registerWithoutItem("dumplings", () -> new FoodBlock(class_4970.class_2251.method_9630((class_4970)class_2246.field_10183), 2, BreweryFoodProperties.POTATO_SALAD));
    public static final RegistrySupplier<class_1792> PORK_KNUCKLE = ObjectRegistry.registerItem("pork_knuckle", () -> new SaturatedBlockItem((class_2248)PORK_KNUCKLE_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<class_1792> FRIED_CHICKEN = ObjectRegistry.registerItem("fried_chicken", () -> new SaturatedBlockItem((class_2248)FRIED_CHICKEN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<class_1792> HALF_CHICKEN = ObjectRegistry.registerItem("half_chicken", () -> new SaturatedBlockItem((class_2248)HALF_CHICKEN_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<class_1792> SAUSAGE = ObjectRegistry.registerItem("sausage", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(8, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<class_1792> MASHED_POTATOES = ObjectRegistry.registerItem("mashed_potatoes", () -> new SaturatedBlockItem((class_2248)MASHED_POTATOES_BLOCK.get(), ObjectRegistry.getFoodItemSettings(8, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 4000)));
    public static final RegistrySupplier<class_1792> POTATO_SALAD = ObjectRegistry.registerItem("potato_salad", () -> new SaturatedBlockItem((class_2248)POTATO_SALAD_BLOCK.get(), ObjectRegistry.getFoodItemSettings(7, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<class_1792> DUMPLINGS = ObjectRegistry.registerItem("dumplings", () -> new SaturatedBlockItem((class_2248)DUMPLINGS_BLOCK.get(), ObjectRegistry.getFoodItemSettings(7, 0.8f, (class_1291)MobEffectRegistry.SATURATED.get(), 6000)));
    public static final RegistrySupplier<class_1792> PRETZEL = ObjectRegistry.registerItem("pretzel", () -> new SaturatedItem(ObjectRegistry.getFoodItemSettings(4, 0.47f, (class_1291)MobEffectRegistry.SATURATED.get(), 2000)));
    public static final RegistrySupplier<class_2248> GINGERBREAD = ObjectRegistry.registerWithItem("gingerbread", () -> new GingerBreadBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15924).method_9634()));
    public static final RegistrySupplier<class_1792> BEER_ELEMENTAL_SPAWN_EGG = ObjectRegistry.registerItem("beer_elemental_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityRegistry.BEER_ELEMENTAL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<class_1792> BREWFEST_HAT = ObjectRegistry.registerItem("brewfest_hat", () -> new BrewfestHatItem(ObjectRegistry.getSettings().method_7894(class_1814.field_8904)));
    public static final RegistrySupplier<class_1792> BREWFEST_REGALIA = ObjectRegistry.registerItem("brewfest_regalia", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_ARMOR, class_1304.field_6174, ObjectRegistry.getSettings().method_7894(class_1814.field_8906)));
    public static final RegistrySupplier<class_1792> BREWFEST_TROUSERS = ObjectRegistry.registerItem("brewfest_trousers", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_LEATHER, class_1304.field_6172, ObjectRegistry.getSettings().method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<class_1792> BREWFEST_BOOTS = ObjectRegistry.registerItem("brewfest_boots", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_ARMOR, class_1304.field_6166, ObjectRegistry.getSettings().method_7894(class_1814.field_8907)));
    public static final RegistrySupplier<class_1792> BREWFEST_HAT_RED = ObjectRegistry.registerItem("brewfest_hat_red", () -> new BrewfestHatRedItem(ObjectRegistry.getSettings().method_7894(class_1814.field_8904)));
    public static final RegistrySupplier<class_1792> BREWFEST_DRESS = ObjectRegistry.registerItem("brewfest_dress", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_DRESS, class_1304.field_6172, ObjectRegistry.getSettings().method_7894(class_1814.field_8903)));
    public static final RegistrySupplier<class_1792> BREWFEST_BLOUSE = ObjectRegistry.registerItem("brewfest_blouse", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_DRESS, class_1304.field_6174, ObjectRegistry.getSettings().method_7894(class_1814.field_8906)));
    public static final RegistrySupplier<class_1792> BREWFEST_SHOES = ObjectRegistry.registerItem("brewfest_shoes", () -> new BrewfestArmorItem(ArmorMaterialRegistry.BREWFEST_DRESS, class_1304.field_6166, ObjectRegistry.getSettings().method_7894(class_1814.field_8907)));
    public static final List<Supplier<class_2248>> STANDARD_BLOCKS = Lists.newArrayList();
    public static final List<Supplier<class_2248>> STANDARD_WALL_BLOCKS = Lists.newArrayList();
    public static final List<Supplier<class_2248>> STANDARD_FLOOR_BLOCKS = Lists.newArrayList();
    public static Supplier<class_2248> BEER_STANDARD;
    public static final Map<Supplier<class_1792>, RegistrySupplier<class_1792>> SEEDCONVERSION;

    public static void init() {
        Brewery.LOGGER.debug("register Mod Block and Items for brewery");
        ITEMS.register();
        BLOCKS.register();
        ObjectRegistry.createStandards();
    }

    private static void createStandards() {
        BEER_STANDARD = BLOCKS.register(Brewery.MOD_ID("beer_standard"), () -> new BeerStandardBlock(ObjectRegistry.properties(class_3614.field_15932, 1.0f).method_9634().method_9626(class_2498.field_11547)));
        RegistrySupplier adjWall = BLOCKS.register(Brewery.MOD_ID("beer_wall_standard"), () -> new BeerStandardWallBlock(ObjectRegistry.properties(class_3614.field_15932, 1.0f).method_9634().method_9626(class_2498.field_11547).method_16228(BEER_STANDARD.get())));
        ITEMS.register(Brewery.MOD_ID("beer_standard"), () -> ObjectRegistry.lambda$createStandards$74((Supplier)adjWall));
        STANDARD_BLOCKS.add(BEER_STANDARD);
        STANDARD_BLOCKS.add((Supplier<class_2248>)adjWall);
    }

    public static void commonInit() {
        FuelRegistry.register((int)300, (class_1935[])new class_1935[]{(class_1935)BEER_STANDARD.get(), (class_1935)BEER_MUG.get(), (class_1935)BENCH.get(), (class_1935)TABLE.get(), (class_1935)BAR_COUNTER.get(), (class_1935)WOODEN_BREWINGSTATION.get()});
        FuelRegistry.register((int)100, (class_1935[])new class_1935[]{(class_1935)CORN.get(), (class_1935)BARLEY.get(), (class_1935)HOPS.get()});
        FuelRegistry.register((int)75, (class_1935[])new class_1935[]{(class_1935)PATTERNED_WOOL.get(), (class_1935)PATTERNED_CARPET.get()});
        FuelRegistry.register((int)50, (class_1935[])new class_1935[]{(class_1935)BREWFEST_BOOTS.get(), (class_1935)BREWFEST_HAT.get(), (class_1935)BREWFEST_DRESS.get(), (class_1935)BREWFEST_REGALIA.get(), (class_1935)BREWFEST_TROUSERS.get()});
    }

    public static class_4970.class_2251 properties(class_3614 material, float hardness) {
        return class_4970.class_2251.method_9637((class_3614)material).method_9629(hardness, hardness);
    }

    private static class_1792.class_1793 getSettingsWithoutTab(Consumer<class_1792.class_1793> consumer) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        consumer.accept(settings);
        return settings;
    }

    private static class_1792.class_1793 getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    private static class_1792.class_1793 getSettingsWithoutTab() {
        return ObjectRegistry.getSettingsWithoutTab(settings -> {});
    }

    private static class_1792.class_1793 getSettings(Consumer<class_1792.class_1793> consumer) {
        class_1792.class_1793 settings = new class_1792.class_1793().method_7892(Brewery.CREATIVE_TAB);
        consumer.accept(settings);
        return settings;
    }

    private static class_1792.class_1793 getFoodItemSettings(int nutrition, float saturationMod, class_1291 effect, int duration) {
        return ObjectRegistry.getFoodItemSettings(nutrition, saturationMod, effect, duration, false, false);
    }

    private static class_1792.class_1793 getFoodItemSettings(int nutrition, float saturationMod, class_1291 effect, int duration, boolean alwaysEat, boolean fast) {
        return ObjectRegistry.getSettings().method_19265(ObjectRegistry.createFood(nutrition, saturationMod, effect, duration, alwaysEat, fast));
    }

    private static class_4970.class_2251 getBeverageSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_10033).method_22488().method_9618();
    }

    private static class_4970.class_2251 getMugSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_10126).method_22488().method_9618();
    }

    private static class_4970.class_2251 getBushSettings() {
        return class_4970.class_2251.method_9630((class_4970)class_2246.field_16999);
    }

    private static class_4174 createFood(int nutrition, float saturationMod, class_1291 effect, int duration, boolean alwaysEat, boolean fast) {
        class_4174.class_4175 food = new class_4174.class_4175().method_19238(nutrition).method_19237(saturationMod);
        if (alwaysEat) {
            food.method_19240();
        }
        if (fast) {
            food.method_19241();
        }
        if (effect != null) {
            food.method_19239(new class_1293(effect, duration), 1.0f);
        }
        return food.method_19242();
    }

    private static <T extends class_2248> RegistrySupplier<T> registerWithItemeverage(String name, Supplier<T> block, RegistrySupplier<class_1291> effect, int duration) {
        RegistrySupplier toReturn = ObjectRegistry.registerWithoutItem(name, block);
        ObjectRegistry.registerItem(name, () -> new DrinkBlockItem((class_1291)effect.get(), duration, (class_2248)toReturn.get(), ObjectRegistry.getSettings(settings -> settings.method_19265(ObjectRegistry.beverageFoodComponent()))));
        return toReturn;
    }

    private static class_4174 beverageFoodComponent() {
        class_4174.class_4175 component = new class_4174.class_4175().method_19238(2).method_19237(1.0f);
        return component.method_19242();
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return ObjectRegistry.registerWithItem(name, block, Brewery.CREATIVE_TAB);
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block, @Nullable class_1761 tab) {
        return Util.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (class_2960)new BreweryIdentifier(name), block, (class_1761)tab);
    }

    public static <T extends class_2248> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return Util.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (class_2960)new BreweryIdentifier(path), block);
    }

    public static <T extends class_1792> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return Util.registerItem(ITEMS, ITEM_REGISTRAR, (class_2960)new BreweryIdentifier(path), itemSupplier);
    }

    private static /* synthetic */ class_1827 lambda$createStandards$74(Supplier adjWall) {
        return new class_1827(BEER_STANDARD.get(), (class_2248)adjWall.get(), new class_1792.class_1793().method_7892(Brewery.CREATIVE_TAB).method_7889(16).method_7894(class_1814.field_8907));
    }

    static {
        SEEDCONVERSION = new HashMap<Supplier<class_1792>, RegistrySupplier<class_1792>>();
        SEEDCONVERSION.put(() -> class_1802.field_8317, CORN_SEEDS);
        SEEDCONVERSION.put(() -> class_1802.field_8309, BARLEY_SEEDS);
        SEEDCONVERSION.put(() -> class_1802.field_8544, HALF_CHICKEN);
        SEEDCONVERSION.put(() -> class_1802.field_8512, MASHED_POTATOES);
    }
}

