/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class BreweryUtil {
    public static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private static final String BLOCK_POS_KEY = "block_pos";
    private static final String BLOCK_POSES_KEY = "block_poses";

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return BreweryUtil.tracking(world, new class_1923(pos));
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false);
    }

    public static int getLightLevel(class_1937 world, class_2338 pos) {
        int bLight = world.method_8314(class_1944.field_9282, pos);
        int sLight = world.method_8314(class_1944.field_9284, pos);
        return class_765.method_23687((int)bLight, (int)sLight);
    }

    public static class_265 rotateShape(class_2350 from, class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - from.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1082((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX), (class_247)class_247.field_1366);
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    public static <T extends class_2586> void renderItem(class_1799 itemStack, class_4587 poseStack, class_4597 multiBufferSource, T blockEntity) {
        class_1937 level = blockEntity.method_10997();
        if (level != null) {
            class_310.method_1551().method_1480().method_23178(itemStack, class_809.class_811.field_4317, BreweryUtil.getLightLevel(level, blockEntity.method_11016()), class_4608.field_21444, poseStack, multiBufferSource, 1);
        }
    }

    public static <T> void registerObject(class_2378<T> registry, class_2960 id, T object) {
    }

    public static void putBlockPos(class_2487 compoundTag, class_2338 blockPos) {
        if (blockPos == null) {
            return;
        }
        int[] positions = new int[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()};
        compoundTag.method_10539(BLOCK_POS_KEY, positions);
    }

    public static void putBlockPoses(class_2487 compoundTag, Collection<class_2338> blockPoses) {
        if (blockPoses == null || blockPoses.isEmpty()) {
            return;
        }
        int[] positions = new int[blockPoses.size() * 3];
        int pos = 0;
        for (class_2338 blockPos : blockPoses) {
            positions[pos * 3] = blockPos.method_10263();
            positions[pos * 3 + 1] = blockPos.method_10264();
            positions[pos * 3 + 2] = blockPos.method_10260();
            ++pos;
        }
        compoundTag.method_10539(BLOCK_POSES_KEY, positions);
    }

    @Nullable
    public static class_2338 readBlockPos(class_2487 compoundTag) {
        if (!compoundTag.method_10545(BLOCK_POS_KEY)) {
            return null;
        }
        int[] positions = compoundTag.method_10561(BLOCK_POS_KEY);
        return new class_2338(positions[0], positions[1], positions[2]);
    }

    public static Set<class_2338> readBlockPoses(class_2487 compoundTag) {
        HashSet<class_2338> blockSet = new HashSet<class_2338>();
        if (!compoundTag.method_10545(BLOCK_POSES_KEY)) {
            return blockSet;
        }
        int[] positions = compoundTag.method_10561(BLOCK_POSES_KEY);
        for (int pos = 0; pos < positions.length / 3; ++pos) {
            blockSet.add(new class_2338(positions[pos * 3], positions[pos * 3 + 1], positions[pos * 3 + 2]));
        }
        return blockSet;
    }

    @Nullable
    public static <T> T getLastElement(Collection<T> c) {
        T lastElement = null;
        for (T t : c) {
            lastElement = t;
        }
        return lastElement;
    }
}

