/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.stacks.AEKey;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.requester.Requests;
import com.almostreliable.merequester.terminal.RequesterTerminalMenu;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_768;

public class RequesterTerminalScreen<T extends RequesterTerminalMenu>
extends AbstractRequesterScreen<T> {
    private static final class_2960 TEXTURE = Utils.getRL(Utils.f("textures/gui/{}.png", "requester_terminal"));
    private static final class_768 FOOTER_BBOX = new class_768(0, 133, 195, 98);
    private final HashMap<Long, RequesterReference> byId = new HashMap();
    private final HashMultimap<String, RequesterReference> byName = HashMultimap.create();
    private final List<String> requesterNames = new ArrayList<String>();
    private final Map<String, Set<Object>> searchCache = new WeakHashMap<String, Set<Object>>();
    private final AETextField searchField;

    public RequesterTerminalScreen(T menu, class_1661 playerInventory, class_2561 name, ScreenStyle style) {
        super(menu, playerInventory, name, style);
        this.addToLeftToolbar((class_4185)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)AEConfig.instance().getTerminalStyle(), this::toggleTerminalStyle));
        this.searchField = this.widgets.addTextField("search");
        this.searchField.method_1863(str -> this.refreshList());
        this.searchField.setPlaceholder((class_2561)GuiText.SearchPlaceholder.text());
    }

    public boolean method_25402(double mX, double mY, int button) {
        if (button == 1 && this.searchField.method_25405(mX, mY)) {
            this.searchField.method_1852("");
        }
        return super.method_25402(mX, mY, button);
    }

    public boolean method_25400(char character, int key) {
        return character == ' ' && this.searchField.method_1882().isEmpty() || super.method_25400(character, key);
    }

    @Override
    protected void method_25426() {
        int availableHeight = this.field_22790 - 2 * this.config.getTerminalMargin();
        int possibleRows = (availableHeight - 19 - 98) / 19;
        this.rowAmount = Math.max(3, this.config.getTerminalStyle().getRows(possibleRows));
        super.method_25426();
        this.method_20085((class_364)this.searchField);
    }

    @Override
    protected void clear() {
        this.byId.clear();
    }

    @Override
    protected void refreshList() {
        Object requests;
        this.refreshList = false;
        this.searchCache.clear();
        this.byName.clear();
        String searchQuery = this.searchField.method_1882().toLowerCase();
        Set<Object> cachedSearch = this.searchByQuery(searchQuery);
        boolean rebuild = cachedSearch.isEmpty();
        for (RequesterReference requester : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(requester)) continue;
            boolean found = searchQuery.isEmpty();
            if (!found) {
                requests = requester.getRequests();
                for (int i = 0; i < ((Requests)requests).size() && !(found = this.keyMatchesSearchQuery(((Requests)requests).getKey(i), searchQuery)); ++i) {
                }
            }
            if (found || requester.getSearchName().contains(searchQuery)) {
                this.byName.put((Object)requester.getDisplayName(), (Object)requester);
                cachedSearch.add(requester);
                continue;
            }
            cachedSearch.remove(requester);
        }
        this.requesterNames.clear();
        this.requesterNames.addAll(this.byName.keySet());
        Collections.sort(this.requesterNames);
        this.lines.clear();
        this.lines.ensureCapacity(this.requesterNames.size() + this.byId.size() * Platform.getRequestLimit());
        for (String name : this.requesterNames) {
            this.lines.add(name);
            ArrayList requesters = new ArrayList(this.byName.get((Object)name));
            Collections.sort(requesters);
            requests = new ArrayList();
            for (RequesterReference requester : requesters) {
                for (int i = 0; i < requester.getRequests().size(); ++i) {
                    requests.add(requester.getRequests().get(i));
                }
            }
            this.lines.addAll(requests);
        }
        this.resetScrollbar();
    }

    @Override
    protected Set<RequesterReference> getByName(String name) {
        return this.byName.get((Object)name);
    }

    @Override
    protected RequesterReference getById(long requesterId, String name, long sortBy) {
        RequesterReference requester = this.byId.get(requesterId);
        if (requester == null) {
            requester = new RequesterReference(requesterId, name, sortBy);
            this.byId.put(requesterId, requester);
            this.refreshList = true;
        }
        return requester;
    }

    @Override
    protected class_768 getFooterBbox() {
        return FOOTER_BBOX;
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> button, boolean backwards) {
        TerminalStyle next = (TerminalStyle)button.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        button.set((Enum)next);
        this.reinitialize();
    }

    private void reinitialize() {
        List<class_4068> renderableWidgets = Platform.getRenderables((class_437)this);
        this.method_25396().removeAll(renderableWidgets);
        renderableWidgets.clear();
        this.method_25426();
    }

    private boolean keyMatchesSearchQuery(@Nullable AEKey key, String searchTerm) {
        return key != null && key.getDisplayName().getString().toLowerCase().contains(searchTerm);
    }

    private Set<Object> searchByQuery(String searchQuery) {
        Set cache = this.searchCache.computeIfAbsent(searchQuery, $ -> new HashSet());
        if (cache.isEmpty() && searchQuery.length() > 1) {
            cache.addAll(this.searchByQuery(searchQuery.substring(0, searchQuery.length() - 1)));
        }
        return cache;
    }
}

