/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.requester;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.platform.Platform;
import com.almostreliable.merequester.platform.TagSerializable;
import com.almostreliable.merequester.requester.abstraction.RequestHost;
import com.almostreliable.merequester.requester.status.RequestStatus;
import com.google.common.primitives.Ints;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class Requests
implements MEStorage,
GenericInternalInventory,
InternalInventory,
TagSerializable<class_2487> {
    @Nullable
    private final RequestHost host;
    private final Request[] requests;
    private final int size;

    public Requests(@Nullable RequestHost host) {
        this.host = host;
        this.size = Platform.getRequestLimit();
        this.requests = new Request[this.size];
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new Request(i);
        }
    }

    public Requests() {
        this(null);
    }

    public Request get(int index) {
        return this.requests[index];
    }

    public int size() {
        return this.size;
    }

    @Nullable
    public GenericStack getStack(int index) {
        return this.get(index).toGenericStack();
    }

    @Nullable
    public AEKey getKey(int index) {
        return this.get(index).getKey();
    }

    public long getAmount(int index) {
        return this.get(index).getAmount();
    }

    public long getMaxAmount(AEKey key) {
        return 1L;
    }

    public long getCapacity(AEKeyType keyType) {
        return 1L;
    }

    public boolean canInsert() {
        return true;
    }

    public boolean canExtract() {
        return false;
    }

    public void setStack(int index, @Nullable GenericStack stack) {
        this.get(index).updateKey(stack);
    }

    public boolean isAllowed(AEKey key) {
        return true;
    }

    public long insert(int index, AEKey key, long amount, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return amount;
        }
        if (this.host == null || this.host.isClientSide()) {
            this.get(index).setClientKey(key, amount);
        } else {
            this.get(index).updateKey(new GenericStack(key, amount));
        }
        return amount;
    }

    public long extract(int index, AEKey key, long amount, Actionable mode) {
        throw new UnsupportedOperationException();
    }

    public void onChange() {
        if (this.host != null) {
            this.host.saveChanges();
        }
    }

    public void updateSnapshots(int slot, TransactionContext transaction) {
    }

    @Override
    public class_2487 serialize() {
        class_2487 tag = new class_2487();
        for (int i = 0; i < this.size(); ++i) {
            tag.method_10566(String.valueOf(i), (class_2520)this.get(i).serialize());
        }
        return tag;
    }

    @Override
    public void deserialize(class_2487 tag) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).deserialize(tag.method_10562(String.valueOf(i)));
        }
    }

    public int firstAvailableIndex() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getKey(i) != null) continue;
            return i;
        }
        return -1;
    }

    public class_2561 getDescription() {
        if (this.host == null) {
            return class_2561.method_43473();
        }
        return this.host.getTerminalName();
    }

    public void beginBatch() {
    }

    public void endBatch() {
    }

    public void endBatchSuppressed() {
    }

    public boolean isItemValid(int slot, class_1799 stack) {
        return stack.method_7960() || this.convertToSuitableStack(stack) != null;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public class_1799 getStackInSlot(int slot) {
        AEKey aEKey;
        GenericStack genericStack = this.getStack(slot);
        if (genericStack != null && (aEKey = genericStack.what()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            return itemKey.toStack();
        }
        return GenericStack.wrapInItemStack((GenericStack)genericStack);
    }

    public void setItemDirect(int slot, @Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            this.setStack(slot, null);
        } else {
            GenericStack converted = this.convertToSuitableStack(stack);
            if (converted != null) {
                this.setStack(slot, converted);
            }
        }
    }

    @Nullable
    private GenericStack convertToSuitableStack(class_1799 stack) {
        AEItemKey itemKey;
        if (stack.method_7960()) {
            return null;
        }
        GenericStack unwrappedStack = GenericStack.unwrapItemStack((class_1799)stack);
        class_1799 returnStack = stack;
        if (unwrappedStack != null) {
            AEKey aEKey = unwrappedStack.what();
            if (aEKey instanceof AEItemKey) {
                itemKey = (AEItemKey)aEKey;
                returnStack = itemKey.toStack(Math.max(1, Ints.saturatedCast((long)unwrappedStack.amount())));
            } else {
                return unwrappedStack;
            }
        }
        return (itemKey = AEItemKey.of((class_1799)returnStack)) != null ? new GenericStack((AEKey)itemKey, (long)returnStack.method_7947()) : null;
    }

    public final class Request
    implements TagSerializable<class_2487> {
        private static final String STATE_ID = "state";
        private static final String KEY_ID = "key";
        private static final String AMOUNT_ID = "amount";
        private static final String BATCH_ID = "batch";
        private static final String STATUS_ID = "status";
        private final int index;
        private boolean state = true;
        @Nullable
        private AEKey key;
        private long amount;
        private long batch = 1L;
        private RequestStatus clientStatus = RequestStatus.IDLE;

        private Request(int index) {
            this.index = index;
        }

        @Override
        public class_2487 serialize() {
            class_2487 tag = new class_2487();
            tag.method_10556(STATE_ID, this.state);
            if (this.key != null) {
                tag.method_10566(KEY_ID, (class_2520)this.key.toTagGeneric());
            }
            tag.method_10544(AMOUNT_ID, this.amount);
            tag.method_10544(BATCH_ID, this.batch);
            tag.method_10569(STATUS_ID, this.clientStatus.ordinal());
            return tag;
        }

        @Override
        public void deserialize(class_2487 tag) {
            this.state = tag.method_10577(STATE_ID);
            this.key = tag.method_10545(KEY_ID) ? AEKey.fromTagGeneric((class_2487)tag.method_10562(KEY_ID)) : null;
            this.amount = tag.method_10537(AMOUNT_ID);
            this.batch = tag.method_10537(BATCH_ID);
            this.clientStatus = RequestStatus.values()[tag.method_10550(STATUS_ID)];
        }

        public void updateState(boolean state) {
            if (this.state != state) {
                this.state = state;
                if (Requests.this.host != null) {
                    Requests.this.host.saveChanges();
                }
            }
        }

        public void updateAmount(long amount) {
            if (this.key == null || amount <= 0L) {
                this.resetSlot();
                return;
            }
            if (this.amount != amount) {
                this.amount = amount;
                if (Requests.this.host != null) {
                    Requests.this.host.saveChanges();
                }
            }
        }

        public void updateBatch(long batch) {
            long oldBatch = this.batch;
            this.batch = class_3532.method_24156((long)batch, (long)1L, (long)batch);
            if (oldBatch != this.batch && Requests.this.host != null) {
                Requests.this.host.saveChanges();
            }
        }

        public String toString() {
            return Utils.f("Request[state={}, key={}, amount={}, batch={}, client_status={}]", new Object[]{this.state, this.key == null ? "none" : this.key.getDisplayName(), this.amount, this.batch, this.clientStatus});
        }

        public boolean isDifferent(Request clientRequest) {
            return this.state != clientRequest.state || !Objects.equals(this.key, clientRequest.key) || this.amount != clientRequest.amount || this.batch != clientRequest.batch || this.clientStatus != clientRequest.clientStatus;
        }

        @Nullable
        private GenericStack toGenericStack() {
            if (this.key == null) {
                return null;
            }
            return new GenericStack(this.key, this.amount);
        }

        private void updateKey(@Nullable GenericStack stack) {
            if (stack == null) {
                if (this.key != null) {
                    this.resetSlot();
                }
                return;
            }
            if (this.key != null && this.key.matches(stack)) {
                if (this.amount != stack.amount()) {
                    this.updateAmount(stack.amount());
                }
                return;
            }
            this.key = stack.what();
            this.amount = stack.amount();
            this.batch = stack.what().getAmountPerUnit();
            this.keyChanged();
        }

        private void setClientKey(AEKey key, long amount) {
            this.key = key;
            this.amount = amount;
        }

        private void keyChanged() {
            if (Requests.this.host != null) {
                Requests.this.host.requestChanged(this.index);
            }
        }

        private void resetSlot() {
            if (this.key == null && this.amount == 0L) {
                return;
            }
            this.key = null;
            this.amount = 0L;
            this.batch = 1L;
            this.keyChanged();
        }

        public int getIndex() {
            return this.index;
        }

        public boolean getState() {
            return this.state;
        }

        @Nullable
        public AEKey getKey() {
            return this.key;
        }

        public long getAmount() {
            return this.amount;
        }

        public long getBatch() {
            return this.batch;
        }

        @Environment(value=EnvType.CLIENT)
        public RequestHost getRequesterReference() {
            assert (Requests.this.host != null);
            return Requests.this.host;
        }

        public RequestStatus getClientStatus() {
            return this.clientStatus;
        }

        void setClientStatus(RequestStatus clientStatus) {
            this.clientStatus = clientStatus;
        }

        public boolean isRequesting() {
            return this.state && this.key != null;
        }
    }
}

