/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_60;
import net.minecraft.server.MinecraftServer;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.mixin.IdentifierHooks;

public class RoughlyEnoughResources {
    public static final Gson GSON = class_5270.method_27862().create();
    public static final class_2960 SEND_WORLD_GEN_STATE_START = new class_2960("roughlyenoughresources", "swds_start");
    public static final class_2960 SEND_WORLD_GEN_STATE_CHUNK = new class_2960("roughlyenoughresources", "swds_chunk");
    public static final class_2960 SEND_WORLD_GEN_STATE_DONE = new class_2960("roughlyenoughresources", "swds_done");
    public static final class_2960 SEND_LOOT_INFO = new class_2960("roughlyenoughresources", "sli");
    public static final class_2960 ASK_SYNC_INFO = new class_2960("roughlyenoughresources", "asi");
    public static final int MIN_WORLD_Y = -64;
    public static final int MAX_WORLD_Y = 320;
    public static final int WORLD_HEIGHT = 384;

    public static void onInitialize() {
        RERUtils.LOGGER.info("RoughlyEnoughPacketSize?  Possibly.");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), (class_2960)ASK_SYNC_INFO, (buf, context) -> context.queue(() -> RoughlyEnoughResources.sendLootToPlayers(GameInstance.getServer(), Collections.singletonList((class_3222)context.getPlayer()))));
    }

    public static void sendLootToPlayers(MinecraftServer server, List<class_3222> players) {
        class_60 lootManager = server.method_3857();
        ArrayList names = Lists.newArrayList((Iterable)lootManager.method_370());
        int size = 50;
        for (int i = 0; i < names.size(); i += size) {
            int end = Math.min(names.size(), i + size);
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(end - i);
            for (int j = i; j < end; ++j) {
                class_2960 identifier = (class_2960)names.get(j);
                class_52 table = lootManager.method_367(identifier);
                RoughlyEnoughResources.writeIdentifier(buf, identifier);
                RoughlyEnoughResources.writeJson(buf, RoughlyEnoughResources.optimiseTable(GSON.toJsonTree((Object)table)));
            }
            for (class_3222 player : players) {
                NetworkManager.sendToPlayer((class_3222)player, (class_2960)SEND_LOOT_INFO, (class_2540)new class_2540(buf.duplicate()));
            }
        }
    }

    private static JsonElement optimiseTable(JsonElement element) {
        block5: {
            block6: {
                block4: {
                    String substring;
                    String s;
                    if (!element.isJsonPrimitive()) break block4;
                    if (element.getAsJsonPrimitive().isString() && (s = element.getAsJsonPrimitive().getAsString()).length() >= 11 && s.startsWith("minecraft:") && IdentifierHooks.isPathValid(substring = s.substring(10))) {
                        return new JsonPrimitive(substring);
                    }
                    break block5;
                }
                if (!element.isJsonArray()) break block6;
                JsonArray array = element.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    array.set(i, RoughlyEnoughResources.optimiseTable(array.get(i)));
                }
                break block5;
            }
            if (!element.isJsonObject()) break block5;
            JsonObject object = element.getAsJsonObject();
            HashSet<String> keys = new HashSet<String>();
            for (Map.Entry entry : object.entrySet()) {
                keys.add((String)entry.getKey());
            }
            for (String key : keys) {
                object.add(key, RoughlyEnoughResources.optimiseTable(object.get(key)));
            }
        }
        return element;
    }

    public static void writeIdentifier(class_2540 buf, class_2960 identifier) {
        if (identifier.method_12836().equals("minecraft")) {
            buf.method_10814(identifier.method_12832());
        } else {
            buf.method_10814(identifier.toString());
        }
    }

    public static void writeJson(class_2540 buf, JsonElement element) {
        if (element.isJsonNull()) {
            buf.writeByte(0);
        } else if (element.isJsonPrimitive()) {
            RoughlyEnoughResources.writeJsonPrimitive(buf, element.getAsJsonPrimitive());
        } else if (element.isJsonArray()) {
            buf.writeByte(12);
            JsonArray array = element.getAsJsonArray();
            buf.method_10804(array.size());
            for (JsonElement arrayElement : array) {
                RoughlyEnoughResources.writeJson(buf, arrayElement);
            }
        } else if (element.isJsonObject()) {
            buf.writeByte(13);
            JsonObject object = element.getAsJsonObject();
            Set entrySet = object.entrySet();
            buf.method_10804(entrySet.size());
            for (Map.Entry entry : entrySet) {
                buf.method_10814((String)entry.getKey());
                RoughlyEnoughResources.writeJson(buf, (JsonElement)entry.getValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown json element type: " + element.getClass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeJsonPrimitive(class_2540 buf, JsonPrimitive primitive) {
        if (primitive.isString()) {
            buf.writeByte(1);
            buf.method_10814(primitive.getAsString());
            return;
        } else if (primitive.isBoolean()) {
            buf.writeByte(primitive.getAsBoolean() ? 3 : 2);
            return;
        } else {
            if (!primitive.isNumber()) throw new IllegalArgumentException("Unknown primitive type: " + primitive.getClass());
            Number number = primitive.getAsNumber();
            if (number instanceof Integer) {
                buf.writeByte(4);
                buf.method_10804(number.intValue());
                return;
            } else if (number instanceof Long) {
                buf.writeByte(5);
                buf.method_10791(number.longValue());
                return;
            } else if (number instanceof Short) {
                buf.writeByte(6);
                buf.writeShort((int)number.shortValue());
                return;
            } else if (number instanceof Byte) {
                buf.writeByte(7);
                buf.writeByte((int)number.byteValue());
                return;
            } else if (number instanceof BigInteger) {
                buf.writeByte(8);
                byte[] bytes = ((BigInteger)number).toByteArray();
                buf.method_10813(bytes);
                return;
            } else if (number instanceof Float) {
                buf.writeByte(9);
                buf.writeFloat(number.floatValue());
                return;
            } else if (number instanceof Double) {
                buf.writeByte(10);
                buf.writeDouble(number.doubleValue());
                return;
            } else {
                if (!(number instanceof BigDecimal)) throw new IllegalArgumentException("Unknown number type: " + number.getClass());
                buf.writeByte(11);
                BigDecimal decimal = (BigDecimal)number;
                buf.method_10813(decimal.unscaledValue().toByteArray());
                buf.writeInt(decimal.scale());
                buf.writeInt(decimal.precision());
            }
        }
    }

    public static JsonElement readJson(class_2540 buf) {
        byte type = buf.readByte();
        switch (type) {
            case 0: {
                return JsonNull.INSTANCE;
            }
            case 12: {
                int size = buf.method_10816();
                JsonArray array = new JsonArray(size);
                for (int i = 0; i < size; ++i) {
                    array.add(RoughlyEnoughResources.readJson(buf));
                }
                return array;
            }
            case 13: {
                int size = buf.method_10816();
                JsonObject object = new JsonObject();
                for (int i = 0; i < size; ++i) {
                    String key = buf.method_19772();
                    object.add(key, RoughlyEnoughResources.readJson(buf));
                }
                return object;
            }
        }
        if (type < 1 || type > 11) {
            throw new IllegalArgumentException("Unknown json type: " + type);
        }
        return RoughlyEnoughResources.readJsonPrimitive(type, buf);
    }

    private static JsonPrimitive readJsonPrimitive(int type, class_2540 buf) {
        switch (type) {
            case 1: {
                return new JsonPrimitive(buf.method_19772());
            }
            case 2: {
                return new JsonPrimitive(Boolean.valueOf(false));
            }
            case 3: {
                return new JsonPrimitive(Boolean.valueOf(true));
            }
            case 4: {
                return new JsonPrimitive((Number)buf.method_10816());
            }
            case 5: {
                return new JsonPrimitive((Number)buf.method_10792());
            }
            case 6: {
                return new JsonPrimitive((Number)buf.readShort());
            }
            case 7: {
                return new JsonPrimitive((Number)buf.readByte());
            }
            case 8: {
                return new JsonPrimitive((Number)new BigInteger(buf.method_10795()));
            }
            case 9: {
                return new JsonPrimitive((Number)Float.valueOf(buf.readFloat()));
            }
            case 10: {
                return new JsonPrimitive((Number)buf.readDouble());
            }
            case 11: {
                byte[] unscaledValue = buf.method_10795();
                int scale = buf.readInt();
                int precision = buf.readInt();
                MathContext context = new MathContext(precision);
                return new JsonPrimitive((Number)new BigDecimal(new BigInteger(unscaledValue), scale, context));
            }
        }
        throw new IllegalArgumentException("Unknown json primitive type: " + type);
    }
}

