/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.config;

import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import com.illusivesoulworks.veinmining.common.platform.Services;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class VeinMiningConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final SpectreConfigSpec COMMON_SPEC;
    public static final SpectreConfigSpec CLIENT_SPEC;
    public static final Server SERVER;
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final String CONFIG_PREFIX = "gui.veinmining.config.";

    public static List<String> generateDefaultGroups() {
        return Services.PLATFORM.getDefaultGroups();
    }

    static {
        Pair specPairServer = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPairServer.getRight();
        SERVER = (Server)specPairServer.getLeft();
        Pair specPairCommon = new SpectreConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (SpectreConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new SpectreConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (SpectreConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.BooleanValue requireEffectiveTool;
        public final SpectreConfigSpec.IntValue maxBlocksBase;
        public final SpectreConfigSpec.IntValue maxDistanceBase;
        public final SpectreConfigSpec.IntValue maxBlocksPerLevel;
        public final SpectreConfigSpec.IntValue maxDistancePerLevel;
        public final SpectreConfigSpec.BooleanValue diagonalMining;
        public final SpectreConfigSpec.BooleanValue relocateDrops;
        public final SpectreConfigSpec.BooleanValue preventToolDestruction;
        public final SpectreConfigSpec.BooleanValue addToolDamage;
        public final SpectreConfigSpec.IntValue toolDamageMultiplier;
        public final SpectreConfigSpec.BooleanValue addPlayerExhaustion;
        public final SpectreConfigSpec.DoubleValue playerExhaustionMultiplier;
        public final SpectreConfigSpec.BooleanValue limitedByDurability;
        public final SpectreConfigSpec.TransformableValue<List<? extends String>, Set<String>> blocks;
        public final SpectreConfigSpec.EnumValue<PermissionType> blocksPermission;
        public final SpectreConfigSpec.TransformableValue<List<? extends String>, Set<String>> groups;

        public Server(SpectreConfigSpec.Builder builder) {
            builder.push("vein mining");
            this.requireEffectiveTool = builder.comment("Whether or not to require an effective tool to vein mine blocks").translation("gui.veinmining.config.requireEffectiveTool").define("requireEffectiveTool", false);
            this.maxBlocksBase = builder.comment("The maximum number of blocks to mine without the enchantment").translation("gui.veinmining.config.maxBlocksBase").defineInRange("maxBlocksBase", 0, 0, 1000);
            this.maxDistanceBase = builder.comment("The maximum distance from the source block without the enchantment").translation("gui.veinmining.config.maxDistanceBase").defineInRange("maxDistanceBase", 0, 0, 1000);
            this.maxBlocksPerLevel = builder.comment("The maximum number of blocks to mine per level of the enchantment").translation("gui.veinmining.config.maxBlocksPerLevel").defineInRange("maxBlocksPerLevel", 50, 1, 1000);
            this.maxDistancePerLevel = builder.comment("The maximum distance from the source block per level of the enchantment").translation("gui.veinmining.config.maxDistancePerLevel").defineInRange("maxDistancePerLevel", 15, 1, 100);
            this.diagonalMining = builder.comment("Whether or not to vein mine diagonally, note this may lead to hidden drops if relocateDrops is false").translation("gui.veinmining.config.diagonalMining").define("diagonalMining", true);
            this.limitedByDurability = builder.comment("Whether or not to stop vein mining when the tool can no longer be used").translation("gui.veinmining.config.limitedByDurability").define("limitedByDurability", true);
            this.relocateDrops = builder.comment("Whether or not to move all drops to the same location").translation("gui.veinmining.config.relocateDrops").define("relocateDrops", true);
            this.preventToolDestruction = builder.comment("Whether or not the tool can break while mining additional blocks").translation("gui.veinmining.config.preventToolDestruction").define("preventToolDestruction", true);
            this.addToolDamage = builder.comment("Whether or not the tool takes damage from mining additional blocks").translation("gui.veinmining.config.addToolDamage").define("addToolDamage", true);
            this.toolDamageMultiplier = builder.comment("The multiplier to tool damage from mining additional blocks").translation("gui.veinmining.config.toolDamageMultiplier").defineInRange("toolDamageMultiplier", 1, 0, 1000);
            this.addPlayerExhaustion = builder.comment("Whether or not the player gets exhaustion from mining additional blocks").translation("gui.veinmining.config.addPlayerExhaustion").define("addPlayerExhaustion", true);
            this.playerExhaustionMultiplier = builder.comment("The multiplier to player exhaustion from mining additional blocks").translation("gui.veinmining.config.playerExhaustionMultiplier").defineInRange("playerExhaustionMultiplier", 1.0, 0.0, 1000.0);
            this.blocks = builder.comment("List of whitelisted/blacklisted blocks or block tags").translation("gui.veinmining.config.blocks").defineList("blocks", new ArrayList(), s -> s instanceof String, Set::copyOf);
            this.blocksPermission = builder.comment("Whether the blocks configuration is a whitelist or a blacklist").translation("gui.veinmining.config.blocksPermission").defineEnum("blocksPermission", (Enum)PermissionType.BLACKLIST);
            builder.pop();
            builder.push("groups");
            this.groups = builder.comment("List of groupings by block IDs or block tags, comma-separated").translation("gui.veinmining.config.groups").defineList("groups", VeinMiningConfig.generateDefaultGroups(), s -> s instanceof String, Set::copyOf);
            builder.pop();
        }
    }

    public static class Common {
        public final SpectreConfigSpec.EnumValue<class_1887.class_1888> rarity;
        public final SpectreConfigSpec.IntValue levels;
        public final SpectreConfigSpec.BooleanValue isTreasure;
        public final SpectreConfigSpec.BooleanValue isVillagerTrade;
        public final SpectreConfigSpec.BooleanValue isLootable;
        public final SpectreConfigSpec.BooleanValue canApplyAtEnchantingTable;
        public final SpectreConfigSpec.BooleanValue canApplyOnBooks;
        public final SpectreConfigSpec.IntValue minEnchantabilityBase;
        public final SpectreConfigSpec.IntValue minEnchantabilityPerLevel;
        public final SpectreConfigSpec.TransformableValue<List<? extends String>, Set<class_1887>> incompatibleEnchantments;
        public final SpectreConfigSpec.TransformableValue<List<? extends String>, Set<String>> items;

        public Common(SpectreConfigSpec.Builder builder) {
            builder.push("enchantment");
            this.rarity = builder.comment("The rarity of the enchantment").translation("gui.veinmining.config.rarity").defineEnum("rarity", (Enum)class_1887.class_1888.field_9088);
            this.levels = builder.comment("The number of levels of the enchantment").translation("gui.veinmining.config.levels").defineInRange("levels", 1, 1, 5);
            this.isTreasure = builder.comment("Whether or not to consider this enchantment as a treasure").translation("gui.veinmining.config.isTreasure").define("isTreasure", false);
            this.isVillagerTrade = builder.comment("Whether or not this enchantment can be offered by villagers for trade").translation("gui.veinmining.config.isVillagerTrade").define("isVillagerTrade", true);
            this.isLootable = builder.comment("Whether or not this enchantment can generate in loot").translation("gui.veinmining.config.isLootable").define("isLootable", true);
            this.canApplyAtEnchantingTable = builder.comment("Whether or not this enchantment can be applied at the enchanting table").translation("gui.veinmining.config.canApplyAtEnchantingTable").define("canApplyAtEnchantingTable", true);
            this.canApplyOnBooks = builder.comment("Whether or not this enchantment can be applied on books").translation("gui.veinmining.config.canApplyOnBooks").define("canApplyOnBooks", true);
            this.minEnchantabilityBase = builder.comment("The minimum enchantability requirement for the first enchantment level").translation("gui.veinmining.config.minEnchantabilityBase").defineInRange("minEnchantabilityBase", 15, 1, 100);
            this.minEnchantabilityPerLevel = builder.comment("The additional enchantability requirement for each enchantment level after the first").translation("gui.veinmining.config.minEnchantabilityPerLevel").defineInRange("minEnchantabilityPerLevel", 5, 1, 100);
            this.incompatibleEnchantments = builder.comment("List of enchantments that cannot be applied together with this enchantment").translation("gui.veinmining.config.incompatibleEnchantments").defineListAllowEmpty(List.of("incompatibleEnchantments"), ArrayList::new, s -> s instanceof String, this::convertEnchantments);
            this.items = builder.comment("List of items that the enchantment can be applied on").translation("gui.veinmining.config.items").defineList("items", Services.PLATFORM.getDefaultItemsConfig(), s -> s instanceof String, Set::copyOf);
            builder.pop();
        }

        private Set<class_1887> convertEnchantments(List<? extends String> input) {
            HashSet<class_1887> result = new HashSet<class_1887>();
            for (String string : input) {
                Services.PLATFORM.getEnchantment(class_2960.method_12829((String)string)).ifPresent(result::add);
            }
            return result;
        }
    }

    public static class Client {
        public final SpectreConfigSpec.EnumValue<ActivationState> activationState;
        public final SpectreConfigSpec.EnumValue<ActivationState> activationStateWithoutEnchantment;

        public Client(SpectreConfigSpec.Builder builder) {
            builder.push("vein mining");
            this.activationState = builder.comment("Whether to activate vein mining (if using with the enchantment) by standing, crouching, or holding down the keybind").translation("gui.veinmining.config.activationState").defineEnum("activationState", (Enum)ActivationState.STANDING);
            this.activationStateWithoutEnchantment = builder.comment("Whether to activate vein mining (if using without the enchantment) by standing, crouching, or holding down the keybind").translation("gui.veinmining.config.activationStateWithoutEnchantment").defineEnum("activationStateWithoutEnchantment", (Enum)ActivationState.KEYBINDING);
            builder.pop();
        }
    }

    public static enum ActivationState {
        STANDING,
        CROUCHING,
        KEYBINDING;

    }

    public static enum PermissionType {
        BLACKLIST,
        WHITELIST;

    }
}

