/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display;

import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.render.DisplayRenderData;
import fr.theorozier.webstreamer.display.source.DisplaySource;
import fr.theorozier.webstreamer.display.source.NullDisplaySource;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayBlockEntity
extends class_2586 {
    private DisplaySource source = NullDisplaySource.INSTANCE;
    private float width = 1.0f;
    private float height = 1.0f;
    private float audioDistance = 10.0f;
    private float audioVolume = 1.0f;
    private final Object cachedRenderDataGuard = new Object();
    private Object cachedRenderData;

    public DisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(WebStreamerMod.DISPLAY_BLOCK_ENTITY, pos, state);
    }

    public void setSource(@NotNull DisplaySource source) {
        Objects.requireNonNull(source);
        this.source = source;
        this.markRenderDataSourceDirty();
        this.method_5431();
    }

    @NotNull
    public DisplaySource getSource() {
        return this.source;
    }

    public void resetSourceUri() {
        this.source.resetUri();
        this.markRenderDataSourceDirty();
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.method_5431();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float calcWidthOffset() {
        return (this.width - 1.0f) / -2.0f;
    }

    public float calcHeightOffset() {
        return (this.height - 1.0f) / -2.0f;
    }

    public void setAudioConfig(float distance, float volume) {
        this.audioDistance = distance;
        this.audioVolume = volume;
        this.method_5431();
    }

    public float getAudioDistance() {
        return this.audioDistance;
    }

    public float getAudioVolume() {
        return this.audioVolume;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2487 displayNbt = new class_2487();
        nbt.method_10566("display", (class_2520)displayNbt);
        displayNbt.method_10548("width", this.width);
        displayNbt.method_10548("height", this.height);
        displayNbt.method_10548("audioDistance", this.audioDistance);
        displayNbt.method_10548("audioVolume", this.audioVolume);
        if (this.source != null) {
            displayNbt.method_10582("type", this.source.getType());
            this.source.writeNbt(displayNbt);
        } else {
            displayNbt.method_10582("type", "");
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2520 class_25202 = nbt.method_10580("display");
        if (class_25202 instanceof class_2487) {
            class_2487 displayNbt = (class_2487)class_25202;
            class_2520 class_25203 = displayNbt.method_10580("width");
            if (class_25203 instanceof class_2494) {
                class_2494 width = (class_2494)class_25203;
                this.width = width.method_10700();
            } else {
                this.width = 1.0f;
            }
            class_25203 = displayNbt.method_10580("height");
            if (class_25203 instanceof class_2494) {
                class_2494 height = (class_2494)class_25203;
                this.height = height.method_10700();
            } else {
                this.height = 1.0f;
            }
            class_25203 = displayNbt.method_10580("audioDistance");
            if (class_25203 instanceof class_2494) {
                class_2494 audioDistance = (class_2494)class_25203;
                this.audioDistance = audioDistance.method_10700();
            } else {
                this.audioDistance = 10.0f;
            }
            class_25203 = displayNbt.method_10580("audioVolume");
            if (class_25203 instanceof class_2494) {
                class_2494 audioVolume = (class_2494)class_25203;
                this.audioVolume = audioVolume.method_10700();
            } else {
                this.audioVolume = 1.0f;
            }
            class_25203 = displayNbt.method_10580("type");
            if (class_25203 instanceof class_2519) {
                class_2519 type = (class_2519)class_25203;
                this.source = DisplaySource.newSourceFromType(type.method_10714());
                this.source.readNbt(displayNbt);
            } else {
                this.source = NullDisplaySource.INSTANCE;
            }
            this.markRenderDataSourceDirty();
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public String makeLog(String message) {
        return "[" + this.field_11867.method_10263() + "/" + this.field_11867.method_10264() + "/" + this.field_11867.method_10260() + "] " + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRenderData() {
        Object object = this.cachedRenderDataGuard;
        synchronized (object) {
            if (this.cachedRenderData == null) {
                this.cachedRenderData = new DisplayRenderData(this);
            }
            return this.cachedRenderData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markRenderDataSourceDirty() {
        Object object = this.cachedRenderDataGuard;
        synchronized (object) {
            if (this.cachedRenderData != null) {
                ((DisplayRenderData)this.cachedRenderData).markSourceDirty();
            }
        }
    }
}

