/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display;

import fr.theorozier.webstreamer.display.DisplayBlock;
import fr.theorozier.webstreamer.display.DisplayBlockEntity;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class DisplayNetworking {
    public static final class_2960 DISPLAY_BLOCK_UPDATE_PACKET_ID = new class_2960("webstreamer:display_block_update");

    private static class_2540 encodeDisplayUpdatePacket(DisplayBlockEntity blockEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockEntity.method_11016());
        class_2487 comp = new class_2487();
        blockEntity.method_11007(comp);
        buf.method_10794(comp);
        return buf;
    }

    private static void decodeDisplayUpdatePacket(class_2540 buf, BiConsumer<class_2338, class_2487> consumer) {
        class_2338 pos = buf.method_10811();
        class_2487 nbt = buf.method_10798();
        consumer.accept(pos, nbt);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendDisplayUpdate(DisplayBlockEntity blockEntity) {
        ClientPlayNetworking.send((class_2960)DISPLAY_BLOCK_UPDATE_PACKET_ID, (class_2540)DisplayNetworking.encodeDisplayUpdatePacket(blockEntity));
    }

    public static void registerDisplayUpdateReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)DISPLAY_BLOCK_UPDATE_PACKET_ID, (ServerPlayNetworking.PlayChannelHandler)new DisplayUpdateHandler());
    }

    private static class DisplayUpdateHandler
    implements ServerPlayNetworking.PlayChannelHandler {
        private DisplayUpdateHandler() {
        }

        public void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
            if (DisplayBlock.canUse((class_1657)player)) {
                DisplayNetworking.decodeDisplayUpdatePacket(buf, (pos, nbt) -> {
                    class_3218 world = player.method_14220();
                    world.method_8503().method_40000(() -> {
                        class_2586 patt2602$temp = world.method_8321(pos);
                        if (patt2602$temp instanceof DisplayBlockEntity) {
                            DisplayBlockEntity blockEntity = (DisplayBlockEntity)patt2602$temp;
                            blockEntity.method_11014((class_2487)nbt);
                            blockEntity.method_5431();
                            world.method_8413(pos, blockEntity.method_11010(), blockEntity.method_11010(), 3);
                        }
                    });
                });
            }
        }
    }
}

