/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.audio;

import fr.theorozier.webstreamer.display.audio.AudioStreamingSource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.bytedeco.javacv.Frame;
import org.lwjgl.openal.AL11;

@Environment(value=EnvType.CLIENT)
public class AudioStreamingBuffer {
    private int bufferId;
    public final long timestamp;
    public final long duration;

    private AudioStreamingBuffer(int bufferId, long timestamp, long duration) {
        this.bufferId = bufferId;
        this.timestamp = timestamp;
        this.duration = duration;
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public boolean isValid() {
        return this.bufferId != 0;
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException("this audio buffer has already been freed");
        }
    }

    public void free() {
        this.checkValid();
        AL11.alDeleteBuffers((int)this.bufferId);
        this.bufferId = 0;
    }

    public static AudioStreamingBuffer fromFrame(ShortBuffer tempBuffer, Frame frame) {
        Objects.requireNonNull(frame.samples, "given frame has no audio sample");
        return AudioStreamingBuffer.fromRawData(tempBuffer, frame.samples[0], frame.audioChannels, frame.sampleRate, frame.timestamp);
    }

    public static AudioStreamingBuffer fromRawData(ShortBuffer tempBuffer, Buffer rawBuffer, int channels, int frequency, long timestamp) {
        int samples;
        boolean stereo;
        if (channels != 1 && channels != 2) {
            throw new IllegalArgumentException("illegal channels count, only 1 or 2 are allowed");
        }
        boolean bl = stereo = channels == 2;
        if (rawBuffer instanceof ByteBuffer) {
            ByteBuffer sampleByte = (ByteBuffer)rawBuffer;
            count = sampleByte.remaining();
            if (stereo) {
                samples = count / 2;
                for (int i = 0; i < count; i += 2) {
                    short sampleLeft = (short)(sampleByte.get(i) << 8);
                    short sampleRight = (short)(sampleByte.get(i + 1) << 8);
                    tempBuffer.put((short)((sampleLeft + sampleRight) / 2));
                }
            } else {
                samples = count;
                for (int i = 0; i < count; ++i) {
                    tempBuffer.put((short)(sampleByte.get(i) << 8));
                }
            }
            tempBuffer.flip();
        } else if (rawBuffer instanceof ShortBuffer) {
            ShortBuffer sampleShort = (ShortBuffer)rawBuffer;
            count = sampleShort.remaining();
            if (stereo) {
                samples = count / 2;
                for (int i = 0; i < count; i += 2) {
                    short sampleLeft = sampleShort.get(i);
                    short sampleRight = sampleShort.get(i + 1);
                    tempBuffer.put((short)((sampleLeft + sampleRight) / 2));
                }
                tempBuffer.flip();
            } else {
                samples = count;
                tempBuffer = sampleShort;
            }
        } else {
            throw new IllegalArgumentException("unsupported sample format");
        }
        int bufferId = AL11.alGenBuffers();
        AL11.alBufferData((int)bufferId, (int)4353, (ShortBuffer)tempBuffer, (int)frequency);
        AudioStreamingSource.checkErrors("audio buffer data");
        long duration = (long)samples * 1000000L / (long)frequency;
        return new AudioStreamingBuffer(bufferId, timestamp, duration);
    }
}

