/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.audio;

import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.audio.AudioStreamingBuffer;
import java.util.ArrayDeque;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2382;
import org.lwjgl.openal.AL11;

@Environment(value=EnvType.CLIENT)
public class AudioStreamingSource {
    private int sourceId;
    private long playTimestamp;
    private long playBufferTimestamp;
    private ArrayDeque<AudioStreamingBuffer> queue = new ArrayDeque();
    private long lastBufferTimestamp;

    public AudioStreamingSource() {
        this.sourceId = AL11.alGenSources();
        AL11.alSourcei((int)this.sourceId, (int)4103, (int)0);
        AL11.alSourcei((int)this.sourceId, (int)514, (int)0);
        this.setVolume(1.0f);
        this.setAttenuation(50.0f);
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public boolean isValid() {
        return this.sourceId != 0;
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("this audio source has already been freed");
        }
    }

    public void free() {
        this.checkValid();
        this.queue.forEach(AudioStreamingBuffer::free);
        this.queue.clear();
        this.queue = null;
        AL11.alSourceStop((int)this.sourceId);
        AL11.alDeleteSources((int)this.sourceId);
        this.sourceId = 0;
    }

    public void stop() {
        this.checkValid();
        AL11.alSourceStop((int)this.sourceId);
        this.queue.forEach(AudioStreamingBuffer::free);
        this.queue.clear();
    }

    public void setPosition(class_2382 pos) {
        this.checkValid();
        AL11.alSourcefv((int)this.sourceId, (int)4100, (float[])new float[]{(float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f, (float)pos.method_10260() + 0.5f});
    }

    public void setVolume(float volume) {
        this.checkValid();
        AL11.alSourcef((int)this.sourceId, (int)4106, (float)volume);
    }

    public void setAttenuation(float attenuation) {
        this.checkValid();
        AL11.alSourcei((int)this.sourceId, (int)53248, (int)53251);
        AL11.alSourcef((int)this.sourceId, (int)4131, (float)attenuation);
        AL11.alSourcef((int)this.sourceId, (int)4129, (float)1.0f);
        AL11.alSourcef((int)this.sourceId, (int)4128, (float)0.0f);
    }

    public boolean isPlaying() {
        this.checkValid();
        return AL11.alGetSourcei((int)this.sourceId, (int)4112) == 4114;
    }

    public void playFrom(long timestamp) {
        this.checkValid();
        boolean playing = this.isPlaying();
        if (!playing) {
            this.removeAndFreeBuffersBefore(timestamp);
        }
        this.unqueueAndFree();
        if (this.queue.isEmpty()) {
            return;
        }
        AudioStreamingBuffer firstBuffer = this.queue.peekFirst();
        if (!playing && firstBuffer.timestamp > timestamp) {
            return;
        }
        long firstBufferTimestamp = -1L;
        int buffersCount = this.queue.size();
        int[] buffers = new int[buffersCount];
        for (int i = 0; i < buffersCount; ++i) {
            AudioStreamingBuffer buffer = this.queue.removeFirst();
            buffers[i] = buffer.getBufferId();
            if (firstBufferTimestamp != -1L) continue;
            firstBufferTimestamp = buffer.timestamp;
        }
        AL11.alSourceQueueBuffers((int)this.sourceId, (int[])buffers);
        if (!playing) {
            AL11.alSourcePlay((int)this.sourceId);
            this.playTimestamp = System.nanoTime();
            this.playBufferTimestamp = firstBufferTimestamp;
        }
    }

    public void queueBuffer(AudioStreamingBuffer buffer) {
        Objects.requireNonNull(buffer, "given buffer should not be null");
        this.checkValid();
        if (buffer.timestamp <= this.lastBufferTimestamp) {
            WebStreamerMod.LOGGER.error("given {} us, expected more than {} us", (Object)buffer.timestamp, (Object)this.lastBufferTimestamp);
            return;
        }
        this.queue.addLast(buffer);
        this.lastBufferTimestamp = buffer.timestamp;
    }

    public void unqueueAndFree() {
        int numProcessed = AL11.alGetSourcei((int)this.sourceId, (int)4118);
        if (numProcessed > 0) {
            int[] buffers = new int[numProcessed];
            AL11.alSourceUnqueueBuffers((int)this.sourceId, (int[])buffers);
            if (!AudioStreamingSource.checkErrors("audio unqueue buffers")) {
                AL11.alDeleteBuffers((int[])buffers);
                AudioStreamingSource.checkErrors("audio delete buffers");
            }
        }
    }

    private void removeAndFreeBuffersBefore(long timestamp) {
        while (!this.queue.isEmpty()) {
            AudioStreamingBuffer buffer = this.queue.peekFirst();
            if (buffer.timestamp + buffer.duration > timestamp) break;
            this.queue.removeFirst().free();
        }
    }

    static boolean checkErrors(String sectionName) {
        int i = AL11.alGetError();
        if (i != 0) {
            WebStreamerMod.LOGGER.error("{}: {}", (Object)sectionName, (Object)AudioStreamingSource.getErrorMessage(i));
            return true;
        }
        return false;
    }

    static String getErrorMessage(int errorCode) {
        return switch (errorCode) {
            case 40961 -> "invalid name.";
            case 40964 -> "invalid operation.";
            case 40962 -> "illegal enum.";
            case 40963 -> "invalid value.";
            case 40965 -> "unable to allocate memory.";
            default -> "an unrecognized error occurred.";
        };
    }
}

