/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import fr.theorozier.webstreamer.WebStreamerClientMod;
import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.DisplayBlockEntity;
import fr.theorozier.webstreamer.display.render.DisplayLayer;
import fr.theorozier.webstreamer.display.render.DisplayLayerManager;
import fr.theorozier.webstreamer.display.render.DisplayRenderData;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import fr.theorozier.webstreamer.mixin.WorldRendererInvoker;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class DisplayBlockEntityRenderer
implements class_827<DisplayBlockEntity> {
    private static final class_2561 NO_LAYER_AVAILABLE_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.status.noLayerAvailable");
    private static final class_2561 UNKNOWN_FORMAT_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.status.unknownFormat");
    private static final class_2561 NO_URL_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.status.noUrl");
    private final class_757 gameRenderer;
    private final class_327 textRenderer;

    public DisplayBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.gameRenderer = class_310.method_1551().field_1773;
        this.textRenderer = ctx.method_32143();
    }

    public void render(DisplayBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        DisplayRenderData renderData = (DisplayRenderData)entity.getRenderData();
        DisplayLayerManager layerManager = WebStreamerClientMod.DISPLAY_LAYERS;
        DisplayUrl url = renderData.getUrl(layerManager.getResources().getExecutor());
        class_746 player = class_310.method_1551().field_1724;
        class_2561 statusText = null;
        if (player != null) {
            boolean hasDisplayEquipped = StreamSupport.stream(player.method_5743().spliterator(), false).map(class_1799::method_7909).anyMatch(arg_0 -> WebStreamerMod.DISPLAY_ITEM.equals(arg_0));
            if (hasDisplayEquipped) {
                class_265 displayShape = entity.method_11010().method_26218((class_1922)entity.method_10997(), entity.method_11016());
                if (displayShape != null) {
                    matrices.method_22903();
                    WorldRendererInvoker.drawCuboidShapeOutline(matrices, vertexConsumers.getBuffer(class_1921.method_23594()), displayShape, 0.0, 0.0, 0.0, 0.92156863f, 0.65882355f, 0.0f, 1.0f);
                    matrices.method_22909();
                }
                statusText = class_2561.method_43470((String)entity.getSource().getStatus());
            }
        }
        if (url != null) {
            try {
                DisplayLayer layer = layerManager.getLayerForUrl(url);
                if (layer.isLost()) {
                    entity.resetSourceUri();
                    return;
                }
                matrices.method_22903();
                class_1159 positionMatrix = matrices.method_23760().method_23761();
                class_4588 buffer = vertexConsumers.getBuffer(layer.getRenderLayer());
                class_2338 pos = entity.method_11016();
                float audioDistance = entity.getAudioDistance();
                float audioVolume = entity.getAudioVolume();
                layer.pushAudioSource((class_2382)pos, pos.method_19455((class_2382)this.gameRenderer.method_19418().method_19328()), audioDistance, audioVolume);
                float ws = renderData.getWidthOffset();
                float hs = renderData.getHeightOffset();
                float we = ws + entity.getWidth();
                float he = hs + entity.getHeight();
                switch ((class_2350)entity.method_11010().method_11654((class_2769)class_2741.field_12481)) {
                    case field_11043: {
                        buffer.method_22918(positionMatrix, we, hs, 0.95f).method_22913(0.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, ws, hs, 0.95f).method_22913(1.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, ws, he, 0.95f).method_22913(1.0f, 0.0f).method_1344();
                        buffer.method_22918(positionMatrix, we, he, 0.95f).method_22913(0.0f, 0.0f).method_1344();
                        break;
                    }
                    case field_11035: {
                        buffer.method_22918(positionMatrix, ws, hs, 0.05f).method_22913(0.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, we, hs, 0.05f).method_22913(1.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, we, he, 0.05f).method_22913(1.0f, 0.0f).method_1344();
                        buffer.method_22918(positionMatrix, ws, he, 0.05f).method_22913(0.0f, 0.0f).method_1344();
                        break;
                    }
                    case field_11034: {
                        buffer.method_22918(positionMatrix, 0.05f, hs, we).method_22913(0.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.05f, hs, ws).method_22913(1.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.05f, he, ws).method_22913(1.0f, 0.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.05f, he, we).method_22913(0.0f, 0.0f).method_1344();
                        break;
                    }
                    case field_11039: {
                        buffer.method_22918(positionMatrix, 0.95f, hs, ws).method_22913(0.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.95f, hs, we).method_22913(1.0f, 1.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.95f, he, we).method_22913(1.0f, 0.0f).method_1344();
                        buffer.method_22918(positionMatrix, 0.95f, he, ws).method_22913(0.0f, 0.0f).method_1344();
                    }
                }
                matrices.method_22909();
            }
            catch (DisplayLayerManager.OutOfLayerException e) {
                statusText = NO_LAYER_AVAILABLE_TEXT;
            }
            catch (DisplayLayerManager.UnknownFormatException e) {
                statusText = UNKNOWN_FORMAT_TEXT;
            }
        } else {
            statusText = NO_URL_TEXT;
        }
        if (statusText != null) {
            matrices.method_22903();
            float scaleFactor = 128.0f / Math.min(entity.getWidth(), entity.getHeight());
            float scale = 1.0f / scaleFactor;
            float halfWidth = (float)this.textRenderer.method_27525((class_5348)statusText) / scaleFactor / 2.0f;
            Objects.requireNonNull(this.textRenderer);
            float halfHeight = 9.0f / scaleFactor / 2.0f;
            switch ((class_2350)entity.method_11010().method_11654((class_2769)class_2741.field_12481)) {
                case field_11043: {
                    matrices.method_22904((double)(0.5f + halfWidth), (double)(0.5f + halfHeight), (double)0.85f);
                    break;
                }
                case field_11035: {
                    matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
                    matrices.method_22904((double)(-0.5f + halfWidth), (double)(0.5f + halfHeight), (double)-0.15f);
                    break;
                }
                case field_11034: {
                    matrices.method_22907(class_1160.field_20705.method_23214(270.0f));
                    matrices.method_22904((double)(0.5f + halfWidth), (double)(0.5f + halfHeight), (double)-0.15f);
                    break;
                }
                case field_11039: {
                    matrices.method_22907(class_1160.field_20705.method_23214(90.0f));
                    matrices.method_22904((double)(-0.5f + halfWidth), (double)(0.5f + halfHeight), (double)0.85f);
                }
            }
            matrices.method_22905(-scale, -scale, 1.0f);
            this.textRenderer.method_30882(statusText, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, -1155390942, light);
            matrices.method_22909();
        }
    }
}

