/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.render.DisplayLayerResources;
import fr.theorozier.webstreamer.display.render.DisplayTexture;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_290;
import net.minecraft.class_293;

@Environment(value=EnvType.CLIENT)
public abstract class DisplayLayer {
    protected static final long LAYER_UNUSED_TIMEOUT = 15000000000L;
    protected final DisplayUrl url;
    protected final DisplayLayerResources res;
    protected final DisplayTexture tex;
    protected final DisplayRenderLayer renderLayer;
    protected long lastUse = 0L;

    public DisplayLayer(DisplayUrl url, DisplayLayerResources res) {
        this.url = url;
        this.res = res;
        this.tex = new DisplayTexture();
        this.renderLayer = new DisplayRenderLayer(this);
        WebStreamerMod.LOGGER.info(this.makeLog("Allocate display layer for {}"), (Object)this.url);
    }

    protected void free() {
        WebStreamerMod.LOGGER.info(this.makeLog("Free display layer for {}"), (Object)this.url);
        this.tex.method_4528();
    }

    protected abstract void tick();

    public void pushAudioSource(class_2382 pos, float dist, float audioDistance, float audioVolume) {
    }

    public boolean isUnused(long now) {
        return now - this.lastUse >= 15000000000L;
    }

    public boolean isLost() {
        return false;
    }

    protected String makeLog(String message) {
        return String.format("[%s:%08X] ", this.getClass().getSimpleName(), this.url.uri().hashCode()) + message;
    }

    public class_1921 getRenderLayer() {
        return this.renderLayer;
    }

    private static class DisplayRenderLayer
    extends class_1921 {
        private DisplayRenderLayer(DisplayLayer layer) {
            super("display", class_290.field_1585, class_293.class_5596.field_27382, 256, false, true, () -> {
                layer.lastUse = System.nanoTime();
                field_29440.method_23516();
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
                RenderSystem.enableTexture();
                RenderSystem.setShaderTexture((int)0, (int)layer.tex.method_4624());
            }, RenderSystem::disableDepthTest);
        }
    }
}

