/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.audio.AudioStreamingSource;
import fr.theorozier.webstreamer.display.render.DisplayLayer;
import fr.theorozier.webstreamer.display.render.DisplayLayerResources;
import fr.theorozier.webstreamer.display.render.FrameGrabber;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import fr.theorozier.webstreamer.util.AsyncMap;
import fr.theorozier.webstreamer.util.AsyncProcessor;
import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.parser.MediaPlaylistParser;
import io.lindstrom.m3u8.parser.ParsingMode;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2382;
import net.minecraft.class_3533;
import net.minecraft.class_3693;
import org.bytedeco.javacv.Frame;

@Environment(value=EnvType.CLIENT)
public class DisplayLayerHls
extends DisplayLayer {
    private static final double SAFE_LATENCY = 8.0;
    private static final long GRABBER_REQUEST_TIMEOUT = 10000000000L;
    private static final long CLEANUP_INTERVAL = 10000000000L;
    private static final long INITIAL_PLAYLIST_REQUEST_INTERVAL = 500000000L;
    private static final long FAILING_PLAYLIST_REQUEST_INTERVAL = 5000000000L;
    private final MediaPlaylistParser hlsParser = new MediaPlaylistParser(ParsingMode.LENIENT);
    private final class_3693 profiler = new class_3533(System::nanoTime, () -> 0, true);
    private long lastFetchTimestamp = 0L;
    private final AsyncProcessor<URI, MediaPlaylist, IOException> asyncPlaylist = new AsyncProcessor(this::requestPlaylistBlocking, true);
    private List<MediaSegment> playlistSegments;
    private int playlistOffset;
    private long playlistNextRequestTimestamp;
    private long playlistRequestInterval;
    private int playlistConsecutiveFailedRequest = 0;
    private int segmentIndex = -1;
    private double segmentTimestamp = 0.0;
    private double segmentDuration = 0.0;
    private FrameGrabber grabber;
    private final AsyncMap<URI, FrameGrabber, IOException> asyncGrabbers = new AsyncMap(this::requestGrabberBlocking, grabber -> {
        WebStreamerMod.LOGGER.info(this.makeLog("Stopping requested but unused grabber."));
        grabber.stop();
    }, 10000000000L);
    private final AudioStreamingSource audioSource = new AudioStreamingSource();
    private class_2382 nearestAudioPos;
    private float nearestAudioDist;
    private float nearestAudioDistance;
    private float nearestAudioVolume;
    private long lastCleanup = 0L;

    public DisplayLayerHls(DisplayUrl url, DisplayLayerResources res) {
        super(url, res);
        this.resetPlaylist();
    }

    @Override
    public void free() {
        super.free();
        this.asyncGrabbers.cleanup(this.res.getExecutor());
        this.audioSource.free();
    }

    private void resetAudioSource() {
        if (this.nearestAudioPos != null) {
            this.audioSource.setPosition(this.nearestAudioPos);
            this.audioSource.setAttenuation(this.nearestAudioDistance);
            this.audioSource.setVolume(this.nearestAudioVolume);
        } else {
            this.audioSource.stop();
        }
        this.nearestAudioPos = null;
        this.nearestAudioDist = Float.MAX_VALUE;
        this.nearestAudioDistance = 0.0f;
        this.nearestAudioVolume = 0.0f;
    }

    @Override
    public void pushAudioSource(class_2382 pos, float dist, float audioDistance, float audioVolume) {
        if (dist < this.nearestAudioDist) {
            this.nearestAudioPos = pos;
            this.nearestAudioDist = dist;
            this.nearestAudioDistance = audioDistance;
            this.nearestAudioVolume = audioVolume;
        }
    }

    private MediaSegment getSegment(int index) {
        try {
            return this.playlistSegments.get(index - this.playlistOffset);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private MediaSegment getCurrentSegment() {
        return this.getSegment(this.segmentIndex);
    }

    private int getLastSegmentIndex() {
        return this.playlistSegments == null ? 0 : this.playlistSegments.size() - 1 + this.playlistOffset;
    }

    private MediaPlaylist requestPlaylistBlocking(URI uri) throws IOException {
        try {
            HttpRequest request = HttpRequest.newBuilder(uri).GET().timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<Stream<String>> res = this.res.getHttpClient().send(request, HttpResponse.BodyHandlers.ofLines());
            if (res.statusCode() == 200) {
                return (MediaPlaylist)this.hlsParser.readPlaylist(res.body().iterator());
            }
            throw new IOException("HTTP request failed, status code: " + res.statusCode());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void resetPlaylist() {
        this.playlistSegments = null;
        this.playlistNextRequestTimestamp = 0L;
        this.playlistRequestInterval = 500000000L;
    }

    private void requestPlaylist(long now) {
        if (now >= this.playlistNextRequestTimestamp) {
            this.asyncPlaylist.push(this.url.uri());
            this.playlistNextRequestTimestamp = now + this.playlistRequestInterval;
        }
    }

    private void fetchPlaylist() {
        this.profiler.method_15396("fetch_playlist");
        this.asyncPlaylist.fetch(this.res.getExecutor(), playlist -> {
            this.profiler.method_15396("success");
            this.playlistConsecutiveFailedRequest = 0;
            int newOffset = (int)playlist.mediaSequence();
            if (newOffset > this.playlistOffset) {
                MediaSegment lastSegment;
                long newInterval;
                this.playlistSegments = playlist.mediaSegments();
                this.playlistOffset = (int)playlist.mediaSequence();
                if (!this.playlistSegments.isEmpty() && Math.abs((newInterval = (long)((lastSegment = this.playlistSegments.get(this.playlistSegments.size() - 1)).duration() * 1.0E9 * 0.7)) - this.playlistRequestInterval) >= this.playlistRequestInterval / 10L) {
                    WebStreamerMod.LOGGER.info(this.makeLog("New request interval: {}"), (Object)newInterval);
                    this.playlistRequestInterval = newInterval;
                }
            }
            this.profiler.method_15407();
        }, e -> {
            this.playlistRequestInterval = 5000000000L;
            ++this.playlistConsecutiveFailedRequest;
            WebStreamerMod.LOGGER.error(this.makeLog("Failed to request playlist, setting interval to {} seconds."), (Object)(this.playlistRequestInterval / 1000000000L), e);
        });
        this.profiler.method_15407();
    }

    private FrameGrabber requestGrabberBlocking(URI uri) throws IOException {
        FrameGrabber grabber = new FrameGrabber(this.res, uri);
        grabber.start();
        return grabber;
    }

    private void requestGrabber(int index) {
        MediaSegment seg = this.getSegment(index);
        if (seg != null) {
            this.asyncGrabbers.push(this.res.getExecutor(), this.url.getContextUri(seg.uri()), index);
        }
    }

    private void pullGrabberAndUse(int index) {
        boolean requested = this.asyncGrabbers.pull(index, grabber -> {
            this.grabber = grabber;
        }, e -> WebStreamerMod.LOGGER.error(this.makeLog("Failed to create and start grabber."), (Throwable)e));
        if (!requested) {
            this.requestGrabber(index);
        }
    }

    private void resetGrabber(boolean toBeContinued) {
        if (this.grabber != null) {
            if (toBeContinued) {
                try {
                    this.grabber.grabRemaining(this.audioSource::queueBuffer);
                }
                catch (IOException e) {
                    WebStreamerMod.LOGGER.error(this.makeLog("Failed to grab remaining from current grabber."), (Throwable)e);
                }
            } else {
                this.audioSource.stop();
            }
            this.res.getExecutor().execute(this.grabber::stop);
            this.grabber = null;
        }
    }

    private void fetch() throws IOException {
        MediaSegment seg;
        long now = System.nanoTime();
        double elapsedTime = (double)(now - this.lastFetchTimestamp) / 1.0E9;
        this.lastFetchTimestamp = now;
        if (this.playlistSegments != null) {
            this.fetchPlaylist();
            double remainingTime = elapsedTime;
            boolean resetPlaylist = false;
            boolean resetGrabber = false;
            while (true) {
                if (this.getCurrentSegment() == null) {
                    WebStreamerMod.LOGGER.warn(this.makeLog("No current segment, reset playlist and grabber"));
                    resetPlaylist = true;
                    resetGrabber = true;
                    break;
                }
                this.segmentTimestamp += remainingTime;
                if (!(this.segmentTimestamp > this.segmentDuration)) break;
                ++this.segmentIndex;
                seg = this.getCurrentSegment();
                if (seg == null) {
                    WebStreamerMod.LOGGER.warn(this.makeLog("No next segment, reset playlist and grabber"));
                    resetPlaylist = true;
                    resetGrabber = true;
                    break;
                }
                resetGrabber = true;
                remainingTime = this.segmentTimestamp - this.segmentDuration;
                this.segmentDuration = seg.duration();
                this.segmentTimestamp = 0.0;
            }
            if (resetPlaylist) {
                this.resetPlaylist();
                this.resetGrabber(false);
            } else {
                int offsetFromLastSegment;
                if (resetGrabber) {
                    this.resetGrabber(true);
                }
                if ((offsetFromLastSegment = this.getLastSegmentIndex() - this.segmentIndex) <= 1) {
                    this.requestPlaylist(now);
                }
                if (offsetFromLastSegment >= 1) {
                    this.requestGrabber(this.segmentIndex + 1);
                }
            }
        }
        if (this.playlistSegments == null) {
            if (this.asyncPlaylist.requested() || this.asyncPlaylist.active()) {
                this.fetchPlaylist();
                if (this.playlistSegments == null) {
                    return;
                }
            } else {
                this.requestPlaylist(now);
                return;
            }
            WebStreamerMod.LOGGER.info(this.makeLog("Initializing display layer... Found {} segments."), (Object)this.playlistSegments.size());
            this.profiler.method_15396("initialize_layer");
            double totalDuration = 0.0;
            for (MediaSegment seg2 : this.playlistSegments) {
                totalDuration += seg2.duration();
            }
            double globalTimestamp = totalDuration;
            this.segmentIndex = this.playlistOffset + (this.playlistSegments.size() - 1);
            seg = this.getCurrentSegment();
            this.segmentTimestamp = this.segmentDuration = seg.duration();
            while (true) {
                double latency = totalDuration - globalTimestamp;
                double latencyDiff = 8.0 - latency;
                if (seg.duration() >= latencyDiff) {
                    this.segmentTimestamp -= latencyDiff;
                    break;
                }
                --this.segmentIndex;
                seg = this.getCurrentSegment();
                if (seg == null) {
                    this.segmentIndex = 0;
                    this.segmentTimestamp = 0.0;
                    break;
                }
                globalTimestamp -= seg.duration();
                this.segmentTimestamp = this.segmentDuration = seg.duration();
            }
            this.profiler.method_15407();
        }
        if (this.grabber == null) {
            this.pullGrabberAndUse(this.segmentIndex);
            if (this.grabber == null) {
                return;
            }
        }
        long segmentTimestampMicros = (long)(this.segmentTimestamp * 1000000.0);
        this.profiler.method_15396("grab_frame");
        Frame frame = this.grabber.grabAt(segmentTimestampMicros, this.audioSource::queueBuffer);
        this.profiler.method_15407();
        if (frame != null) {
            this.profiler.method_15396("upload_image");
            this.tex.upload(frame);
            this.profiler.method_15405("play_audio");
            this.audioSource.playFrom(frame.timestamp);
            this.profiler.method_15407();
        }
    }

    @Override
    public void tick() {
        long now;
        boolean cleanup;
        this.profiler.method_16065();
        this.profiler.method_15396("tick");
        if (!this.isLost()) {
            try {
                this.profiler.method_15396("fetch");
                this.fetch();
            }
            catch (IOException e) {
                WebStreamerMod.LOGGER.error(this.makeLog("Failed to fetch."), (Throwable)e);
            }
            finally {
                this.profiler.method_15407();
            }
        }
        boolean bl = cleanup = (now = System.nanoTime()) - this.lastCleanup >= 10000000000L;
        if (cleanup) {
            this.profiler.method_15396("cleanup");
            this.asyncGrabbers.cleanupTimedOut(this.res.getExecutor(), now);
            this.lastCleanup = now;
            this.profiler.method_15407();
        }
        this.profiler.method_15407();
        this.profiler.method_16066();
        this.resetAudioSource();
    }

    @Override
    public boolean isLost() {
        return this.playlistConsecutiveFailedRequest >= 3;
    }
}

