/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import com.mojang.blaze3d.platform.TextureUtil;
import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.render.DisplayLayer;
import fr.theorozier.webstreamer.display.render.DisplayLayerResources;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.io.IOUtils;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class DisplayLayerImage
extends DisplayLayer {
    private static final long FAILING_IMAGE_REQUEST_INTERVAL = 30000000000L;
    private long imageNextRequestTimestamp = 0L;
    private boolean imageUploaded = false;
    private Future<STBLoadedImage> futureImage;

    public DisplayLayerImage(DisplayUrl url, DisplayLayerResources res) {
        super(url, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick() {
        long now = System.nanoTime();
        if (this.futureImage == null) {
            if (!this.imageUploaded && now >= this.imageNextRequestTimestamp) {
                this.futureImage = this.res.getExecutor().submit(this::requestImageBlocking);
            }
        } else if (this.futureImage.isDone()) {
            STBLoadedImage img = null;
            try {
                img = this.futureImage.get();
                WebStreamerMod.LOGGER.info(this.makeLog("Uploading image... (channels: {}, pixel size: {})"), (Object)img.channels, (Object)(img.buffer.remaining() / (img.width * img.height)));
                this.tex.uploadRaw(img.buffer, 6408, img.width, img.height, img.width, 6408, 4);
                this.imageUploaded = true;
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                WebStreamerMod.LOGGER.error(this.makeLog("Failed to request image, retrying in {} seconds."), (Object)30L, (Object)e.getCause());
                this.imageNextRequestTimestamp = now + 30000000000L;
            }
            finally {
                this.futureImage = null;
                if (img != null) {
                    img.free();
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private STBLoadedImage requestImageBlocking() throws IOException {
        try {
            HttpRequest request = HttpRequest.newBuilder(this.url.uri()).GET().timeout(Duration.ofSeconds(5L)).build();
            HttpResponse<InputStream> res = this.res.getHttpClient().send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (res.statusCode() == 200) {
                InputStream stream = res.body();
                ByteBuffer buf = null;
                try {
                    STBLoadedImage sTBLoadedImage;
                    block13: {
                        buf = TextureUtil.readResource((InputStream)stream);
                        buf.rewind();
                        MemoryStack memoryStack = MemoryStack.stackPush();
                        try {
                            IntBuffer width = memoryStack.mallocInt(1);
                            IntBuffer height = memoryStack.mallocInt(1);
                            IntBuffer channels = memoryStack.mallocInt(1);
                            ByteBuffer stbBuf = STBImage.stbi_load_from_memory((ByteBuffer)buf, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
                            if (stbBuf == null) {
                                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                            }
                            sTBLoadedImage = new STBLoadedImage(stbBuf, width.get(0), height.get(0), channels.get(0));
                            if (memoryStack == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (memoryStack != null) {
                                try {
                                    memoryStack.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        memoryStack.close();
                    }
                    return sTBLoadedImage;
                }
                finally {
                    MemoryUtil.memFree((Buffer)buf);
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            throw new IOException("HTTP request failed, status code: " + res.statusCode());
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private record STBLoadedImage(ByteBuffer buffer, int width, int height, int channels) {
        private void free() {
            STBImage.stbi_image_free((ByteBuffer)this.buffer);
        }
    }
}

