/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.theorozier.webstreamer.display.render.DisplayLayer;
import fr.theorozier.webstreamer.display.render.DisplayLayerHls;
import fr.theorozier.webstreamer.display.render.DisplayLayerImage;
import fr.theorozier.webstreamer.display.render.DisplayLayerResources;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DisplayLayerManager {
    private static final int MAX_LAYERS_COUNT = 20;
    private static final long CLEANUP_INTERVAL = 5000000000L;
    private final Int2ObjectOpenHashMap<DisplayLayer> layers = new Int2ObjectOpenHashMap();
    private final DisplayLayerResources res = new DisplayLayerResources();
    private long lastCleanup = 0L;

    public DisplayLayerResources getResources() {
        return this.res;
    }

    @NotNull
    private DisplayLayer newLayerForUrl(DisplayUrl url) throws UnknownFormatException {
        String path = url.uri().getPath();
        if (path != null) {
            if (path.endsWith(".m3u8")) {
                return new DisplayLayerHls(url, this.res);
            }
            if (path.endsWith(".jpeg") || path.endsWith(".jpg") || path.endsWith(".bmp") || path.endsWith(".png")) {
                return new DisplayLayerImage(url, this.res);
            }
        }
        throw new UnknownFormatException();
    }

    @NotNull
    public DisplayLayer getLayerForUrl(DisplayUrl url) throws OutOfLayerException, UnknownFormatException {
        DisplayLayer layer = (DisplayLayer)this.layers.get(url.id());
        if (layer == null) {
            if (this.layers.size() >= 20) {
                throw new OutOfLayerException();
            }
            layer = this.newLayerForUrl(url);
            this.layers.put(url.id(), (Object)layer);
        }
        return layer;
    }

    public void tick() {
        RenderSystem.assertOnRenderThread();
        this.layers.values().forEach(DisplayLayer::tick);
        long now = System.nanoTime();
        if (now - this.lastCleanup >= 5000000000L) {
            this.cleanup();
            this.lastCleanup = now;
        }
    }

    public void cleanup() {
        RenderSystem.assertOnRenderThread();
        long now = System.nanoTime();
        this.layers.values().removeIf(displayLayer -> {
            if (displayLayer.isUnused(now)) {
                displayLayer.free();
                return true;
            }
            return false;
        });
    }

    public void clear() {
        this.layers.values().forEach(DisplayLayer::free);
        this.layers.clear();
    }

    public static class UnknownFormatException
    extends Exception {
    }

    public static class OutOfLayerException
    extends Exception {
    }
}

