/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import fr.theorozier.webstreamer.WebStreamerMod;
import java.net.http.HttpClient;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class DisplayLayerResources {
    private static final int RAW_FILE_BUFFER_SIZE = 0x800000;
    private static final int RAW_FILE_BUFFER_LIMIT = 32;
    private static final int AUDIO_BUFFER_SIZE = 8192;
    private static final int AUDIO_BUFFER_LIMIT = 64;
    private final ExecutorService executor = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(@NotNull Runnable r) {
            return new Thread(r, "WebStreamer Display Queue (" + this.counter.getAndIncrement() + ")");
        }
    });
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final List<ByteBuffer> rawFileBuffers = new ArrayList<ByteBuffer>();
    private final List<ShortBuffer> audioBuffers = new ArrayList<ShortBuffer>();
    private int rawFileBuffersCount = 0;
    private int audioBuffersCount = 0;

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocRawFileBuffer() {
        List<ByteBuffer> list = this.rawFileBuffers;
        synchronized (list) {
            try {
                return this.rawFileBuffers.remove(this.rawFileBuffers.size() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                if (this.rawFileBuffersCount >= 32) {
                    throw new IllegalStateException("reached maximum number of allocated raw file buffers: 32");
                }
                ++this.rawFileBuffersCount;
                WebStreamerMod.LOGGER.debug("Number of allocated raw file buffers: {}", (Object)this.rawFileBuffersCount);
                return ByteBuffer.allocate(0x800000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeRawFileBuffer(ByteBuffer buffer) {
        List<ByteBuffer> list = this.rawFileBuffers;
        synchronized (list) {
            this.rawFileBuffers.add(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortBuffer allocAudioBuffer() {
        List<ShortBuffer> list = this.audioBuffers;
        synchronized (list) {
            try {
                return this.audioBuffers.remove(this.audioBuffers.size() - 1);
            }
            catch (IndexOutOfBoundsException e) {
                if (this.audioBuffersCount >= 64) {
                    throw new IllegalStateException("reached maximum number of allocated audio buffers: 64");
                }
                ++this.audioBuffersCount;
                WebStreamerMod.LOGGER.debug("Number of allocated sound buffers: {}", (Object)this.audioBuffersCount);
                return ByteBuffer.allocateDirect(8192).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeAudioBuffer(ShortBuffer buffer) {
        List<ShortBuffer> list = this.audioBuffers;
        synchronized (list) {
            this.audioBuffers.add(buffer);
        }
    }
}

