/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import fr.theorozier.webstreamer.WebStreamerClientMod;
import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.DisplayBlockEntity;
import fr.theorozier.webstreamer.display.url.DisplayUrl;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class DisplayRenderData {
    private final DisplayBlockEntity display;
    private boolean sourceDirty;
    private Future<URI> futureUrl;
    private DisplayUrl url;
    private float lastWidth = 0.0f;
    private float lastHeight = 0.0f;
    private float widthOffset = 0.0f;
    private float heightOffset = 0.0f;

    public DisplayRenderData(DisplayBlockEntity display) {
        this.display = display;
        this.sourceDirty = true;
    }

    public void markSourceDirty() {
        this.sourceDirty = true;
    }

    public DisplayUrl getUrl(ExecutorService executor) {
        if (this.sourceDirty) {
            this.url = null;
            this.futureUrl = executor.submit(() -> this.display.getSource().getUri());
            this.sourceDirty = false;
        }
        if (this.futureUrl != null && this.futureUrl.isDone()) {
            try {
                URI uri = this.futureUrl.get();
                if (uri == null) {
                    WebStreamerMod.LOGGER.info(this.display.makeLog("No URI found for the display."));
                } else {
                    this.url = WebStreamerClientMod.DISPLAY_URLS.allocUri(uri);
                    WebStreamerMod.LOGGER.info(this.display.makeLog("Allocated a new display url {}."), (Object)this.url);
                }
            }
            catch (InterruptedException | CancellationException uri) {
            }
            catch (ExecutionException e) {
                WebStreamerMod.LOGGER.warn(this.display.makeLog("Unhandled error while getting source uri."), (Throwable)e);
            }
            finally {
                this.futureUrl = null;
            }
        }
        return this.url;
    }

    public float getWidthOffset() {
        float width = this.display.getWidth();
        if (width != this.lastWidth) {
            this.lastWidth = width;
            this.widthOffset = this.display.calcWidthOffset();
        }
        return this.widthOffset;
    }

    public float getHeightOffset() {
        float height = this.display.getHeight();
        if (height != this.lastHeight) {
            this.lastHeight = height;
            this.heightOffset = this.display.calcHeightOffset();
        }
        return this.heightOffset;
    }
}

