/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.render;

import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.audio.AudioStreamingBuffer;
import fr.theorozier.webstreamer.display.render.DisplayLayerResources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;

@Environment(value=EnvType.CLIENT)
public class FrameGrabber {
    private final DisplayLayerResources pools;
    private final URI uri;
    private ByteBuffer buffer;
    private FFmpegFrameGrabber grabber;
    private long refTimestamp;
    private long deltaTimestamp;
    private Frame lastFrame;
    private ShortBuffer tempAudioBuffer;
    private ArrayDeque<AudioStreamingBuffer> startAudioBuffers;

    public FrameGrabber(DisplayLayerResources pools, URI uri) {
        this.pools = pools;
        this.uri = uri;
    }

    public void start() throws IOException {
        if (this.grabber != null || this.buffer != null) {
            throw new IllegalStateException("already started");
        }
        try {
            Frame frame;
            HttpRequest req = HttpRequest.newBuilder(this.uri).GET().timeout(Duration.ofSeconds(1L)).build();
            this.buffer = this.pools.allocRawFileBuffer();
            this.pools.getHttpClient().send(req, info -> new BufferResponseSubscriber(this.buffer));
            ByteArrayInputStream grabberStream = new ByteArrayInputStream(this.buffer.array(), this.buffer.position(), this.buffer.remaining());
            this.grabber = new FFmpegFrameGrabber((InputStream)grabberStream);
            this.grabber.startUnsafe();
            this.tempAudioBuffer = this.pools.allocAudioBuffer();
            this.refTimestamp = 0L;
            this.deltaTimestamp = 0L;
            this.lastFrame = null;
            this.startAudioBuffers = new ArrayDeque();
            while ((frame = this.grabber.grab()) != null) {
                if (frame.image != null) {
                    this.refTimestamp = frame.timestamp;
                    this.lastFrame = frame;
                    break;
                }
                if (frame.samples == null) continue;
                this.startAudioBuffers.addLast(AudioStreamingBuffer.fromFrame(this.tempAudioBuffer, frame));
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (this.grabber != null) {
                this.grabber.releaseUnsafe();
            }
            if (this.buffer != null) {
                this.pools.freeRawFileBuffer(this.buffer);
                this.buffer = null;
            }
            if (this.tempAudioBuffer != null) {
                this.pools.freeAudioBuffer(this.tempAudioBuffer);
                this.tempAudioBuffer = null;
            }
            if (e instanceof InterruptedException) {
                throw new IOException(e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    public void stop() {
        if (this.grabber == null || this.buffer == null || this.tempAudioBuffer == null) {
            throw new IllegalStateException("Frame grabber is not started.");
        }
        try {
            this.grabber.releaseUnsafe();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pools.freeRawFileBuffer(this.buffer);
        this.pools.freeAudioBuffer(this.tempAudioBuffer);
        this.buffer = null;
        this.grabber = null;
        this.tempAudioBuffer = null;
        if (this.startAudioBuffers != null) {
            this.startAudioBuffers.forEach(AudioStreamingBuffer::free);
            this.startAudioBuffers = null;
        }
    }

    public Frame grabAt(long timestamp, Consumer<AudioStreamingBuffer> audioBufferConsumer) throws IOException {
        Frame frame;
        if (this.startAudioBuffers != null) {
            this.startAudioBuffers.forEach(audioBufferConsumer);
            this.startAudioBuffers = null;
        }
        long realTimestamp = timestamp + this.refTimestamp;
        if (this.lastFrame != null) {
            if (this.lastFrame.timestamp <= realTimestamp) {
                Frame frame2 = this.lastFrame;
                this.lastFrame = null;
                return frame2;
            }
            return null;
        }
        while ((frame = this.grabber.grab()) != null) {
            if (frame.image != null) {
                if (this.deltaTimestamp == 0L) {
                    this.deltaTimestamp = frame.timestamp - this.refTimestamp;
                }
                if (frame.timestamp <= realTimestamp) {
                    long delta = realTimestamp - frame.timestamp;
                    if (delta > this.deltaTimestamp) continue;
                    return frame;
                }
                this.lastFrame = frame;
                break;
            }
            if (frame.samples == null) continue;
            audioBufferConsumer.accept(AudioStreamingBuffer.fromFrame(this.tempAudioBuffer, frame));
        }
        return null;
    }

    public void grabRemaining(Consumer<AudioStreamingBuffer> audioBufferConsumer) throws IOException {
        Frame frame;
        while ((frame = this.grabber.grab()) != null) {
            if (frame.samples == null) continue;
            audioBufferConsumer.accept(AudioStreamingBuffer.fromFrame(this.tempAudioBuffer, frame));
        }
    }

    private static class BufferResponseSubscriber
    implements HttpResponse.BodySubscriber<Object> {
        private final CompletableFuture<Object> future = new CompletableFuture();
        private final ByteBuffer buffer;
        private Flow.Subscription subscription;

        public BufferResponseSubscriber(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public CompletionStage<Object> getBody() {
            return this.future;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            this.subscription = subscription;
            this.subscription.request(Long.MAX_VALUE);
            this.buffer.clear();
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            for (ByteBuffer buf : item) {
                try {
                    this.buffer.put(buf);
                }
                catch (BufferOverflowException e) {
                    WebStreamerMod.LOGGER.error("Cannot fill the full raw file buffer because of overflow. current pos: {}, incoming buf: {}", (Object)this.buffer.position(), (Object)buf.remaining());
                    this.future.completeExceptionally(e);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.future.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            this.buffer.flip();
            this.future.complete(null);
        }
    }
}

