/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.screen;

import fr.theorozier.webstreamer.WebStreamerClientMod;
import fr.theorozier.webstreamer.display.DisplayBlockEntity;
import fr.theorozier.webstreamer.display.DisplayNetworking;
import fr.theorozier.webstreamer.display.source.DisplaySource;
import fr.theorozier.webstreamer.display.source.RawDisplaySource;
import fr.theorozier.webstreamer.display.source.TwitchDisplaySource;
import fr.theorozier.webstreamer.playlist.Playlist;
import fr.theorozier.webstreamer.playlist.PlaylistQuality;
import fr.theorozier.webstreamer.twitch.TwitchClient;
import fr.theorozier.webstreamer.util.AsyncProcessor;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5676;

@Environment(value=EnvType.CLIENT)
public class DisplayBlockScreen
extends class_437 {
    private static final class_2561 CONF_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.conf");
    private static final class_2561 WIDTH_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.width");
    private static final class_2561 HEIGHT_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.height");
    private static final class_2561 SOURCE_TYPE_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.sourceType");
    private static final class_2561 SOURCE_TYPE_RAW_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.sourceType.raw");
    private static final class_2561 SOURCE_TYPE_TWITCH_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.sourceType.twitch");
    private static final class_2561 URL_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.url");
    private static final class_2561 CHANNEL_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.channel");
    private static final class_2561 MALFORMED_URL_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.malformedUrl");
    private static final class_2561 NO_QUALITY_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.noQuality");
    private static final class_2561 QUALITY_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.quality");
    private static final String AUDIO_DISTANCE_TEXT_KEY = "gui.webstreamer.display.audioDistance";
    private static final String AUDIO_VOLUME_TEXT_KEY = "gui.webstreamer.display.audioVolume";
    private static final class_2561 ERR_NO_TOKEN_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.error.noToken");
    private static final class_2561 ERR_CHANNEL_NOT_FOUND_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.error.channelNotFound");
    private static final class_2561 ERR_CHANNEL_OFFLINE_TEXT = class_2561.method_43471((String)"gui.webstreamer.display.error.channelOffline");
    private static final String ERR_UNKNOWN_TEXT_KEY = "gui.webstreamer.display.error.unknown";
    private final DisplayBlockEntity blockEntity;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private SourceScreen<?> sourceScreen;
    private SourceType sourceType;
    private int xHalf;
    private int yTop;
    private int ySourceTop;
    private class_342 displayWidthField;
    private class_342 displayHeightField;
    private class_5676<SourceType> sourceTypeButton;
    private AudioDistanceSliderWidget audioDistanceSlider;
    private AudioVolumeSliderWidget audioVolumeSlider;
    private class_4185 doneButton;
    private class_4185 cancelButton;
    private float displayWidth;
    private float displayHeight;
    private float displayAudioDistance;
    private float displayAudioVolume;

    public DisplayBlockScreen(DisplayBlockEntity blockEntity) {
        super(class_333.field_18967);
        this.blockEntity = blockEntity;
        DisplaySource source = blockEntity.getSource();
        if (source instanceof RawDisplaySource) {
            RawDisplaySource rawSource = (RawDisplaySource)source;
            this.sourceType = SourceType.RAW;
            this.sourceScreen = new RawSourceScreen(new RawDisplaySource(rawSource));
        } else if (source instanceof TwitchDisplaySource) {
            TwitchDisplaySource twitchSource = (TwitchDisplaySource)source;
            this.sourceType = SourceType.TWITCH;
            this.sourceScreen = new TwitchSourceScreen(new TwitchDisplaySource(twitchSource));
        } else {
            this.sourceType = SourceType.RAW;
            this.sourceScreen = new RawSourceScreen();
        }
        this.displayWidth = blockEntity.getWidth();
        this.displayHeight = blockEntity.getHeight();
        this.displayAudioDistance = blockEntity.getAudioDistance();
        this.displayAudioVolume = blockEntity.getAudioVolume();
    }

    private void setSourceScreen(SourceScreen<?> sourceScreen) {
        this.sourceScreen = sourceScreen;
        if (this.field_22787 != null) {
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }

    protected void method_25426() {
        this.xHalf = this.field_22789 / 2;
        this.yTop = 60;
        this.ySourceTop = 130;
        String displayWidthRaw = this.displayWidthField == null ? Float.toString(this.displayWidth) : this.displayWidthField.method_1882();
        String displayHeightRaw = this.displayHeightField == null ? Float.toString(this.displayHeight) : this.displayHeightField.method_1882();
        this.displayWidthField = new class_342(this.field_22793, this.xHalf - 154, this.yTop + 11, 50, 18, (class_2561)class_2561.method_43473());
        this.displayWidthField.method_1852(displayWidthRaw);
        this.displayWidthField.method_1863(this::onDisplayWidthChanged);
        this.method_37063((class_364)this.displayWidthField);
        this.method_25429((class_364)this.displayWidthField);
        this.displayHeightField = new class_342(this.field_22793, this.xHalf - 96, this.yTop + 11, 50, 18, (class_2561)class_2561.method_43473());
        this.displayHeightField.method_1852(displayHeightRaw);
        this.displayHeightField.method_1863(this::onDisplayHeightChanged);
        this.method_37063((class_364)this.displayHeightField);
        this.method_25429((class_364)this.displayHeightField);
        this.sourceTypeButton = class_5676.method_32606(SourceType::getText).method_32624((Object[])SourceType.values()).method_32617(this.xHalf - 38, this.yTop + 10, 192, 20, SOURCE_TYPE_TEXT, this::onSourceTypeChanged);
        this.sourceTypeButton.method_32605((Object)this.sourceType);
        this.method_37063((class_364)this.sourceTypeButton);
        this.audioDistanceSlider = new AudioDistanceSliderWidget(this.xHalf - 154, this.yTop + 36, 150, 20, this.displayAudioDistance, 64.0f);
        this.audioDistanceSlider.setChangedListener(dist -> {
            this.displayAudioDistance = dist.floatValue();
        });
        this.method_37063((class_364)this.audioDistanceSlider);
        this.audioVolumeSlider = new AudioVolumeSliderWidget(this.xHalf + 4, this.yTop + 36, 150, 20, this.displayAudioVolume);
        this.audioVolumeSlider.setChangedListener(volume -> {
            this.displayAudioVolume = volume.floatValue();
        });
        this.method_37063((class_364)this.audioVolumeSlider);
        this.doneButton = new class_4185(this.xHalf - 4 - 150, this.field_22790 / 4 + 120 + 12, 150, 20, class_5244.field_24334, button -> this.commitAndClose());
        this.method_37063((class_364)this.doneButton);
        this.cancelButton = new class_4185(this.xHalf + 4, this.field_22790 / 4 + 120 + 12, 150, 20, class_5244.field_24335, button -> this.method_25419());
        this.method_37063((class_364)this.cancelButton);
        if (this.sourceScreen != null) {
            this.sourceScreen.init();
        }
    }

    private void onDisplayWidthChanged(String widthRaw) {
        try {
            this.displayWidth = Float.parseFloat(widthRaw);
        }
        catch (NumberFormatException e) {
            this.displayWidth = Float.NaN;
        }
    }

    private void onDisplayHeightChanged(String heightRaw) {
        try {
            this.displayHeight = Float.parseFloat(heightRaw);
        }
        catch (NumberFormatException e) {
            this.displayHeight = Float.NaN;
        }
    }

    private void onSourceTypeChanged(class_5676<SourceType> button, SourceType type) {
        if (type != this.sourceType) {
            this.sourceType = type;
            this.setSourceScreen(switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case SourceType.RAW -> new RawSourceScreen();
                case SourceType.TWITCH -> new TwitchSourceScreen();
            });
        }
    }

    private void commitAndClose() {
        if (Float.isFinite(this.displayWidth) && Float.isFinite(this.displayHeight)) {
            this.blockEntity.setSize(this.displayWidth, this.displayHeight);
            this.blockEntity.setAudioConfig(this.displayAudioDistance, this.displayAudioVolume);
            if (this.sourceScreen != null) {
                this.blockEntity.setSource((DisplaySource)this.sourceScreen.source);
            }
            DisplayNetworking.sendDisplayUpdate(this.blockEntity);
        }
        this.method_25419();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        DisplayBlockScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)CONF_TEXT, (int)this.xHalf, (int)20, (int)0xFFFFFF);
        DisplayBlockScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)WIDTH_TEXT, (int)(this.xHalf - 154), (int)(this.yTop + 1), (int)0xA0A0A0);
        DisplayBlockScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)HEIGHT_TEXT, (int)(this.xHalf - 96), (int)(this.yTop + 1), (int)0xA0A0A0);
        if (this.sourceScreen != null) {
            this.sourceScreen.method_25394(matrices, mouseX, mouseY, delta);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public void method_25393() {
        super.method_25393();
        this.displayWidthField.method_1865();
        this.displayHeightField.method_1865();
        boolean bl = this.doneButton.field_22763 = Float.isFinite(this.displayWidth) && Float.isFinite(this.displayHeight);
        if (this.sourceScreen != null) {
            this.sourceScreen.tick();
            if (this.doneButton.field_22763 && !this.sourceScreen.valid()) {
                this.doneButton.field_22763 = false;
            }
        }
    }

    private static enum SourceType {
        RAW(SOURCE_TYPE_RAW_TEXT),
        TWITCH(SOURCE_TYPE_TWITCH_TEXT);

        private final class_2561 text;

        private SourceType(class_2561 text) {
            this.text = text;
        }

        public class_2561 getText() {
            return this.text;
        }
    }

    private class RawSourceScreen
    extends SourceScreen<RawDisplaySource> {
        private class_342 urlField;
        private final AsyncProcessor<String, URI, IllegalArgumentException> asyncUrl;

        RawSourceScreen(RawDisplaySource source) {
            super(source);
            this.asyncUrl = new AsyncProcessor(URI::create);
        }

        RawSourceScreen() {
            this(new RawDisplaySource());
        }

        @Override
        public boolean valid() {
            return this.asyncUrl.idle();
        }

        @Override
        public void init() {
            boolean first = this.urlField == null;
            this.urlField = new class_342(DisplayBlockScreen.this.field_22793, DisplayBlockScreen.this.xHalf - 154, DisplayBlockScreen.this.ySourceTop + 10, 308, 20, this.urlField, (class_2561)class_2561.method_43473());
            this.urlField.method_1880(32000);
            this.urlField.method_1863(this::onUrlChanged);
            DisplayBlockScreen.this.method_25429((class_364)this.urlField);
            DisplayBlockScreen.this.method_20085((class_364)this.urlField);
            DisplayBlockScreen.this.method_37063((class_364)this.urlField);
            if (first) {
                this.urlField.method_1852(Objects.toString(((RawDisplaySource)this.source).getUri(), ""));
            }
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_332.method_27535((class_4587)matrices, (class_327)DisplayBlockScreen.this.field_22793, (class_2561)URL_TEXT, (int)(DisplayBlockScreen.this.xHalf - 154), (int)DisplayBlockScreen.this.ySourceTop, (int)0xA0A0A0);
            if (((RawDisplaySource)this.source).getUri() == null) {
                class_332.method_27534((class_4587)matrices, (class_327)DisplayBlockScreen.this.field_22793, (class_2561)MALFORMED_URL_TEXT, (int)DisplayBlockScreen.this.xHalf, (int)(DisplayBlockScreen.this.ySourceTop + 50), (int)16736338);
            }
        }

        @Override
        public void tick() {
            this.urlField.method_1865();
            this.asyncUrl.fetch(DisplayBlockScreen.this.executor, ((RawDisplaySource)this.source)::setUri, exc -> ((RawDisplaySource)this.source).setUri(null));
        }

        private void onUrlChanged(String rawUrl) {
            this.asyncUrl.push(rawUrl);
        }
    }

    private static abstract class SourceScreen<S extends DisplaySource>
    implements class_4068 {
        protected final S source;

        SourceScreen(S source) {
            this.source = source;
        }

        abstract boolean valid();

        abstract void init();

        abstract void tick();
    }

    private class TwitchSourceScreen
    extends SourceScreen<TwitchDisplaySource> {
        private class_342 channelField;
        private QualitySliderWidget qualitySlider;
        private String firstQuality;
        private final AsyncProcessor<String, Playlist, TwitchClient.PlaylistException> asyncPlaylist;
        private Playlist playlist;
        private class_2561 playlistError;

        TwitchSourceScreen(TwitchDisplaySource source) {
            super(source);
            this.firstQuality = source.getQuality();
            this.asyncPlaylist = new AsyncProcessor(WebStreamerClientMod.TWITCH_CLIENT::requestPlaylist);
        }

        TwitchSourceScreen() {
            this(new TwitchDisplaySource());
        }

        @Override
        public boolean valid() {
            return this.asyncPlaylist.idle();
        }

        @Override
        public void init() {
            boolean first = this.channelField == null;
            this.channelField = new class_342(DisplayBlockScreen.this.field_22793, DisplayBlockScreen.this.xHalf - 154, DisplayBlockScreen.this.ySourceTop + 10, 308, 20, this.channelField, (class_2561)class_2561.method_43473());
            this.channelField.method_1880(64);
            this.channelField.method_1863(this::onChannelChanged);
            DisplayBlockScreen.this.method_25429((class_364)this.channelField);
            DisplayBlockScreen.this.method_20085((class_364)this.channelField);
            DisplayBlockScreen.this.method_37063((class_364)this.channelField);
            this.qualitySlider = new QualitySliderWidget(DisplayBlockScreen.this.xHalf - 154, DisplayBlockScreen.this.ySourceTop + 50, 308, 20, this.qualitySlider);
            this.qualitySlider.setChangedListener(this::onQualityChanged);
            this.updateQualitySlider();
            DisplayBlockScreen.this.method_25429((class_364)this.qualitySlider);
            DisplayBlockScreen.this.method_37063((class_364)this.qualitySlider);
            if (first) {
                this.channelField.method_1852(Objects.toString(((TwitchDisplaySource)this.source).getChannel(), ""));
            }
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            class_332.method_27535((class_4587)matrices, (class_327)DisplayBlockScreen.this.field_22793, (class_2561)CHANNEL_TEXT, (int)(DisplayBlockScreen.this.xHalf - 154), (int)DisplayBlockScreen.this.ySourceTop, (int)0xA0A0A0);
            if (this.playlistError == null) {
                class_332.method_27535((class_4587)matrices, (class_327)DisplayBlockScreen.this.field_22793, (class_2561)QUALITY_TEXT, (int)(DisplayBlockScreen.this.xHalf - 154), (int)(DisplayBlockScreen.this.ySourceTop + 40), (int)0xA0A0A0);
            } else {
                class_332.method_27534((class_4587)matrices, (class_327)DisplayBlockScreen.this.field_22793, (class_2561)this.playlistError, (int)DisplayBlockScreen.this.xHalf, (int)(DisplayBlockScreen.this.ySourceTop + 50), (int)16736338);
            }
        }

        @Override
        public void tick() {
            this.channelField.method_1865();
            this.asyncPlaylist.fetch(DisplayBlockScreen.this.executor, pl -> {
                this.playlist = pl;
                this.qualitySlider.setQualities(pl.getQualities());
                if (this.firstQuality != null) {
                    this.qualitySlider.setQuality(this.firstQuality);
                    this.firstQuality = null;
                }
                this.playlistError = null;
                this.updateQualitySlider();
            }, exc -> {
                this.playlist = null;
                this.qualitySlider.setQualities(null);
                this.playlistError = switch (exc.getExceptionType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case TwitchClient.PlaylistExceptionType.UNKNOWN -> class_2561.method_43469((String)DisplayBlockScreen.ERR_UNKNOWN_TEXT_KEY, (Object[])new Object[]{""});
                    case TwitchClient.PlaylistExceptionType.NO_TOKEN -> ERR_NO_TOKEN_TEXT;
                    case TwitchClient.PlaylistExceptionType.CHANNEL_NOT_FOUND -> ERR_CHANNEL_NOT_FOUND_TEXT;
                    case TwitchClient.PlaylistExceptionType.CHANNEL_OFFLINE -> ERR_CHANNEL_OFFLINE_TEXT;
                };
                this.updateQualitySlider();
            });
        }

        private void onChannelChanged(String channel) {
            this.asyncPlaylist.push(channel);
        }

        private void onQualityChanged(PlaylistQuality quality) {
            if (quality == null) {
                ((TwitchDisplaySource)this.source).clearChannelQuality();
            } else if (this.playlist != null) {
                ((TwitchDisplaySource)this.source).setChannelQuality(this.playlist.getChannel(), quality.name());
            }
        }

        private void updateQualitySlider() {
            this.qualitySlider.field_22764 = this.playlistError == null;
        }
    }

    private static class AudioDistanceSliderWidget
    extends class_357 {
        private final float maxDistance;
        private Consumer<Float> changedListener;

        public AudioDistanceSliderWidget(int x, int y, int width, int height, float distance, float maxDistance) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)(distance / maxDistance));
            this.maxDistance = maxDistance;
            this.method_25346();
        }

        public void setChangedListener(Consumer<Float> changedListener) {
            this.changedListener = changedListener;
        }

        private float getDistance() {
            return (float)(this.field_22753 * (double)this.maxDistance);
        }

        protected void method_25346() {
            this.method_25355((class_2561)class_2561.method_43471((String)DisplayBlockScreen.AUDIO_DISTANCE_TEXT_KEY).method_27693(": ").method_27693(Integer.toString((int)this.getDistance())));
        }

        protected void method_25344() {
            this.changedListener.accept(Float.valueOf(this.getDistance()));
        }
    }

    private static class AudioVolumeSliderWidget
    extends class_357 {
        private Consumer<Float> changedListener;

        public AudioVolumeSliderWidget(int x, int y, int width, int height, float value) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), (double)value);
            this.method_25346();
        }

        public void setChangedListener(Consumer<Float> changedListener) {
            this.changedListener = changedListener;
        }

        protected void method_25346() {
            class_2561 text = this.field_22753 == (double)this.method_25356(false) ? class_5244.field_24333 : class_2561.method_43470((String)((int)(this.field_22753 * 100.0) + "%"));
            this.method_25355((class_2561)class_2561.method_43471((String)DisplayBlockScreen.AUDIO_VOLUME_TEXT_KEY).method_27693(": ").method_10852(text));
        }

        protected void method_25344() {
            this.changedListener.accept(Float.valueOf((float)this.field_22753));
        }
    }

    private static class QualitySliderWidget
    extends class_357 {
        private int qualityIndex = -1;
        private List<PlaylistQuality> qualities;
        private Consumer<PlaylistQuality> changedListener;

        public QualitySliderWidget(int x, int y, int width, int height, QualitySliderWidget previousSlider) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
            if (previousSlider != null && previousSlider.qualities != null) {
                this.setQualities(previousSlider.qualities);
                this.qualityIndex = previousSlider.qualityIndex;
                this.field_22753 = (double)this.qualityIndex / (double)(this.qualities.size() - 1);
                this.method_25346();
            } else {
                this.setQualities(null);
            }
        }

        public void setQualities(List<PlaylistQuality> qualities) {
            this.qualities = qualities;
            this.method_25344();
            this.method_25346();
        }

        public void setQuality(String quality) {
            for (int i = 0; i < this.qualities.size(); ++i) {
                if (!this.qualities.get(i).name().equals(quality)) continue;
                this.qualityIndex = i;
                this.field_22753 = (double)this.qualityIndex / (double)(this.qualities.size() - 1);
                this.method_25346();
                if (this.changedListener != null) {
                    this.changedListener.accept(this.qualities.get(i));
                }
                return;
            }
        }

        public void setChangedListener(Consumer<PlaylistQuality> changedListener) {
            this.changedListener = changedListener;
        }

        protected void method_25346() {
            if (this.qualityIndex < 0) {
                this.method_25355(NO_QUALITY_TEXT);
            } else {
                this.method_25355((class_2561)class_2561.method_43470((String)this.qualities.get(this.qualityIndex).name()));
            }
        }

        protected void method_25344() {
            if (this.qualities == null || this.qualities.isEmpty()) {
                this.field_22753 = 0.0;
                this.qualityIndex = -1;
                this.field_22763 = false;
                if (this.changedListener != null) {
                    this.changedListener.accept(null);
                }
            } else {
                this.qualityIndex = (int)Math.round(this.field_22753 * (double)(this.qualities.size() - 1));
                this.field_22753 = (double)this.qualityIndex / (double)(this.qualities.size() - 1);
                this.field_22763 = true;
                if (this.changedListener != null) {
                    this.changedListener.accept(this.qualities.get(this.qualityIndex));
                }
            }
        }
    }
}

