/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.display.source;

import fr.theorozier.webstreamer.WebStreamerClientMod;
import fr.theorozier.webstreamer.WebStreamerMod;
import fr.theorozier.webstreamer.display.source.DisplaySource;
import fr.theorozier.webstreamer.playlist.Playlist;
import fr.theorozier.webstreamer.playlist.PlaylistQuality;
import fr.theorozier.webstreamer.twitch.TwitchClient;
import java.net.URI;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class TwitchDisplaySource
implements DisplaySource {
    public static final String TYPE = "twitch";
    private String channel;
    private String quality;

    public TwitchDisplaySource(TwitchDisplaySource copy) {
        this.channel = copy.channel;
        this.quality = copy.quality;
    }

    public TwitchDisplaySource() {
    }

    public void setChannelQuality(String channel, String quality) {
        this.channel = channel;
        this.quality = quality;
    }

    public void clearChannelQuality() {
        this.channel = null;
        this.quality = null;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getQuality() {
        return this.quality;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public URI getUri() {
        if (this.channel != null && this.quality != null) {
            try {
                Playlist playlist = WebStreamerClientMod.TWITCH_CLIENT.requestPlaylist(this.channel);
                PlaylistQuality quality = playlist.getQuality(this.quality);
                return quality.uri();
            }
            catch (TwitchClient.PlaylistException e) {
                WebStreamerMod.LOGGER.error("Failed to request twitch channel", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void resetUri() {
        if (this.channel != null) {
            WebStreamerClientMod.TWITCH_CLIENT.forgetPlaylist(this.channel);
            WebStreamerMod.LOGGER.info("Forget twitch playlist for channel " + this.channel);
        }
    }

    @Override
    public String getStatus() {
        return this.channel + " / " + this.quality;
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        if (this.channel != null && this.quality != null) {
            nbt.method_10582("channel", this.channel);
            nbt.method_10582("quality", this.quality);
        }
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2520 class_25202 = nbt.method_10580("channel");
        if (class_25202 instanceof class_2519) {
            class_2519 channel = (class_2519)class_25202;
            class_25202 = nbt.method_10580("quality");
            if (class_25202 instanceof class_2519) {
                class_2519 quality = (class_2519)class_25202;
                try {
                    this.channel = channel.method_10714();
                    this.quality = quality.method_10714();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

