/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.twitch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.theorozier.webstreamer.playlist.Playlist;
import fr.theorozier.webstreamer.playlist.PlaylistQuality;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TwitchClient {
    private final Gson gson = new GsonBuilder().create();
    private final String clientId;
    private final HashMap<String, Playlist> cache = new HashMap();

    public TwitchClient(String clientId) {
        this.clientId = clientId;
    }

    public TwitchClient() {
        this("kimne78kx3ncx6brgo4mv6wki5h1ko");
    }

    private Playlist requestPlaylistInternal(String channel) throws PlaylistException, IOException, URISyntaxException, InterruptedException {
        String tokenSignature;
        if (channel.isEmpty()) {
            throw new PlaylistException(PlaylistExceptionType.CHANNEL_NOT_FOUND);
        }
        URI gqlUri = new URI("https://gql.twitch.tv/gql");
        HttpClient client = HttpClient.newHttpClient();
        JsonObject body = new JsonObject();
        body.addProperty("operationName", "PlaybackAccessToken");
        JsonObject extensions = new JsonObject();
        JsonObject persistedQuery = new JsonObject();
        persistedQuery.addProperty("version", (Number)1);
        persistedQuery.addProperty("sha256Hash", "0828119ded1c13477966434e15800ff57ddacf13ba1911c129dc2200705b0712");
        extensions.add("persistedQuery", (JsonElement)persistedQuery);
        body.add("extensions", (JsonElement)extensions);
        JsonObject variables = new JsonObject();
        variables.addProperty("isLive", Boolean.valueOf(true));
        variables.addProperty("login", channel);
        variables.addProperty("isVod", Boolean.valueOf(false));
        variables.addProperty("vodID", "");
        variables.addProperty("playerType", "embed");
        body.add("variables", (JsonElement)variables);
        HttpRequest tokenReq = HttpRequest.newBuilder(gqlUri).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((JsonElement)body))).header("Accept", "application/json").headers("Client-id", this.clientId).build();
        HttpResponse<String> tokenRes = client.send(tokenReq, HttpResponse.BodyHandlers.ofString());
        if (tokenRes.statusCode() != 200) {
            throw new PlaylistException(PlaylistExceptionType.NO_TOKEN);
        }
        JsonObject tokenResJson = (JsonObject)this.gson.fromJson(tokenRes.body(), JsonObject.class);
        JsonElement tokenRaw = tokenResJson.getAsJsonObject("data").get("streamPlaybackAccessToken");
        if (!tokenRaw.isJsonObject()) {
            throw new PlaylistException(PlaylistExceptionType.CHANNEL_NOT_FOUND);
        }
        JsonObject token = tokenRaw.getAsJsonObject();
        String tokenValue = URLEncoder.encode(token.get("value").getAsString(), StandardCharsets.UTF_8);
        URI urlsUri = new URL("https://usher.ttvnw.net/api/channel/hls/" + channel + ".m3u8?client_id=" + this.clientId + "&token=" + tokenValue + "&sig=" + (tokenSignature = token.get("signature").getAsString()) + "&allow_source=true&allow_audio_only=false").toURI();
        HttpRequest urlsReq = HttpRequest.newBuilder(urlsUri).GET().header("Accept", "application/json").build();
        HttpResponse<String> urlsRes = client.send(urlsReq, HttpResponse.BodyHandlers.ofString());
        if (urlsRes.statusCode() == 404) {
            if (urlsRes.body().contains("Can not find channel")) {
                throw new PlaylistException(PlaylistExceptionType.CHANNEL_NOT_FOUND);
            }
            throw new PlaylistException(PlaylistExceptionType.CHANNEL_OFFLINE);
        }
        if (urlsRes.statusCode() != 200) {
            throw new PlaylistException(PlaylistExceptionType.UNKNOWN);
        }
        String raw = urlsRes.body();
        List<String> rawLines = raw.lines().toList();
        Playlist playlist = new Playlist(channel);
        for (int i = 4; i < rawLines.size(); i += 3) {
            String line0 = rawLines.get(i);
            String line2 = rawLines.get(i - 2);
            int qualityNameStartIdx = line2.indexOf("NAME=\"");
            int qualityNameStopIdx = line2.indexOf(34, qualityNameStartIdx + 6);
            String qualityName = line2.substring(qualityNameStartIdx + 6, qualityNameStopIdx);
            playlist.addQuality(new PlaylistQuality(qualityName, new URI(line0)));
        }
        return playlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Playlist requestPlaylist(String channel) throws PlaylistException {
        HashMap<String, Playlist> hashMap = this.cache;
        synchronized (hashMap) {
            Playlist playlist = this.cache.get(channel);
            if (playlist == null) {
                try {
                    playlist = this.requestPlaylistInternal(channel);
                    this.cache.put(channel, playlist);
                }
                catch (IOException | InterruptedException | URISyntaxException e) {
                    e.printStackTrace();
                    throw new PlaylistException(PlaylistExceptionType.UNKNOWN);
                }
            }
            return playlist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetPlaylist(String channel) {
        HashMap<String, Playlist> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.remove(channel);
        }
    }

    public static class PlaylistException
    extends Exception {
        private final PlaylistExceptionType exceptionType;

        public PlaylistException(PlaylistExceptionType exceptionType) {
            super(exceptionType.name());
            this.exceptionType = exceptionType;
        }

        public PlaylistExceptionType getExceptionType() {
            return this.exceptionType;
        }
    }

    public static enum PlaylistExceptionType {
        UNKNOWN,
        NO_TOKEN,
        CHANNEL_NOT_FOUND,
        CHANNEL_OFFLINE;

    }
}

