/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.util;

import fr.theorozier.webstreamer.util.Converter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class AsyncMap<FROM, TO, EXC extends Exception> {
    private final Converter<FROM, TO, EXC> converter;
    private final Consumer<TO> cleanup;
    private final Int2ObjectOpenHashMap<TimedFuture<TO>> futures = new Int2ObjectOpenHashMap();
    private final long timeout;

    public AsyncMap(Converter<FROM, TO, EXC> converter, Consumer<TO> cleanup, long timeout) {
        this.converter = converter;
        this.cleanup = cleanup;
        this.timeout = timeout;
    }

    public void push(ExecutorService executor, FROM from, int key) {
        this.futures.computeIfAbsent(key, key0 -> new TimedFuture<Object>(executor.submit(() -> this.converter.convert(from)), System.nanoTime(), this.timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pull(int key, Consumer<TO> onSuccess, Consumer<EXC> onError) {
        TimedFuture future = (TimedFuture)this.futures.get(key);
        if (future != null) {
            if (future.future.isDone()) {
                if (Thread.interrupted()) {
                    return true;
                }
                try {
                    onSuccess.accept(future.future.get());
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException ee) {
                    try {
                        onError.accept((Exception)ee.getCause());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                finally {
                    this.futures.remove(key);
                }
            }
            return true;
        }
        return false;
    }

    public void cleanup(ExecutorService executor) {
        for (TimedFuture future : this.futures.values()) {
            executor.execute(() -> future.cleanup(this.cleanup));
        }
        this.futures.clear();
    }

    public void cleanupTimedOut(ExecutorService executor, long now) {
        ObjectIterator it = this.futures.values().iterator();
        while (it.hasNext()) {
            TimedFuture item = (TimedFuture)it.next();
            if (!item.isTimedOut(now)) continue;
            executor.execute(() -> {
                try {
                    this.cleanup.accept(item.future.get());
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            });
            it.remove();
        }
    }

    public void cleanupTimedOut(ExecutorService executor) {
        this.cleanupTimedOut(executor, System.nanoTime());
    }

    private record TimedFuture<TO>(Future<TO> future, long time, long timeout) {
        public boolean isTimedOut(long now) {
            return now - this.time >= this.timeout;
        }

        public void cleanup(Consumer<TO> cleanup) {
            try {
                cleanup.accept(this.future.get());
            }
            catch (InterruptedException | CancellationException | ExecutionException exception) {
                // empty catch block
            }
        }
    }
}

