/*
 * Decompiled with CFR 0.152.
 */
package fr.theorozier.webstreamer.util;

import fr.theorozier.webstreamer.util.Converter;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class AsyncProcessor<FROM, TO, EXC extends Exception> {
    private final Converter<FROM, TO, EXC> converter;
    private final boolean allowDuplicates;
    private FROM requestedFrom;
    private boolean requested;
    private Future<TO> future;
    private FROM futureFrom;

    public AsyncProcessor(Converter<FROM, TO, EXC> converter, boolean allowDuplicates) {
        this.converter = converter;
        this.allowDuplicates = allowDuplicates;
    }

    public AsyncProcessor(Converter<FROM, TO, EXC> converter) {
        this(converter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(ExecutorService executor, BiConsumer<FROM, TO> onSuccess, BiConsumer<FROM, EXC> onError) {
        if (this.future != null && this.future.isDone()) {
            if (Thread.interrupted()) {
                return;
            }
            try {
                onSuccess.accept(this.futureFrom, this.future.get());
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException ee) {
                try {
                    onError.accept(this.futureFrom, (Exception)ee.getCause());
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            finally {
                this.future = null;
                this.futureFrom = null;
            }
        }
        if (this.future == null && this.requested) {
            FROM from = this.requestedFrom;
            this.futureFrom = from;
            this.future = executor.submit(() -> this.converter.convert(from));
            this.requested = false;
        }
    }

    public void fetch(ExecutorService executor, Consumer<TO> onSuccess, Consumer<EXC> onError) {
        this.fetch(executor, (FROM from, TO to) -> onSuccess.accept(to), (FROM from, EXC err) -> onError.accept(err));
    }

    public void push(FROM from) {
        Objects.requireNonNull(from);
        if (this.allowDuplicates || this.requestedFrom == null || !this.requestedFrom.equals(from)) {
            this.requestedFrom = from;
            this.requested = true;
        }
    }

    public void reset() {
        this.requestedFrom = null;
        this.requested = false;
    }

    public boolean requested() {
        return this.requested;
    }

    public boolean active() {
        return this.future != null;
    }

    public boolean idle() {
        return this.future == null;
    }
}

