/*
 * Decompiled with CFR 0.152.
 */
package org.demens.blockhunters.mixin;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.demens.blockhunters.BlockHunters;
import org.demens.blockhunters.config.BlockHuntersConfig;
import org.demens.blockhunters.extension.BlockDisguise;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309
implements BlockDisguise {
    @Unique
    private int stillnessCounter;
    @Unique
    private boolean disguiseVisible;
    @Unique
    private class_2680 disguiseBlockState;
    @Unique
    private class_2338 spawnedBlockPos = class_2338.field_10980;
    @Unique
    private static final class_2940<Optional<class_2680>> DATA_PLAYER_DISGUISE_BS = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13312);
    @Unique
    private static final class_2940<class_2338> DATA_PLAYER_DISGUISE_BP = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13324);
    @Unique
    private static final class_2940<Boolean> DATA_PLAYER_HAS_DISGUISE = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> DATA_PLAYER_DISGUISE_VISIBLE = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13323);

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public void blockHunters$setDisguise(class_2680 disguise) {
        if (this.field_6002.method_8608() || !this.canDisguise(disguise)) {
            return;
        }
        BlockHunters.LOGGER.info("Setting disguise");
        this.field_6011.method_12778(DATA_PLAYER_HAS_DISGUISE, (Object)true);
        this.blockHunters$setDisguiseVisible(true);
        this.setDisguiseBlockState(disguise);
    }

    @Override
    public void blockHunters$removeDisguise() {
        if (this.field_6002.method_8608()) {
            return;
        }
        if (this.spawnedBlockPos != class_2338.field_10980) {
            this.field_6002.method_8501(this.spawnedBlockPos, class_2246.field_10124.method_9564());
        }
        this.field_6011.method_12778(DATA_PLAYER_HAS_DISGUISE, (Object)false);
        this.method_5648(false);
        this.setDisguiseBlockState(null);
    }

    @Override
    public void blockHunters$refreshDisguise() {
        ((Optional)this.field_6011.method_12789(DATA_PLAYER_DISGUISE_BS)).ifPresent(this::blockHunters$setDisguise);
    }

    @Override
    public void blockHunters$setDisguiseVisible(boolean active) {
        this.field_6011.method_12778(DATA_PLAYER_DISGUISE_VISIBLE, (Object)active);
        this.disguiseVisible = active;
        this.method_5648(!active);
    }

    @Override
    public boolean blockHunters$getDisguiseVisible() {
        return this.disguiseVisible;
    }

    @Override
    public void blockHunters$setStillnessCounter(int value) {
        this.stillnessCounter = value;
    }

    @Override
    public boolean blockHunters$hasDisguise() {
        return (Boolean)this.field_6011.method_12789(DATA_PLAYER_HAS_DISGUISE);
    }

    @Unique
    private boolean canDisguise(class_2680 blockState) {
        BlockHuntersConfig.ListMode blockListMode = BlockHuntersConfig.blockListMode;
        String disguiseBlockKey = class_2378.field_11146.method_10221((Object)blockState.method_26204()).toString();
        for (String blockKey : BlockHuntersConfig.blockList) {
            if (!blockKey.equals(disguiseBlockKey)) continue;
            return blockListMode == BlockHuntersConfig.ListMode.WHITELIST;
        }
        return blockListMode == BlockHuntersConfig.ListMode.BLACKLIST;
    }

    @Unique
    private void setDisguiseBlockState(class_2680 state) {
        if (state == null) {
            this.field_6011.method_12778(DATA_PLAYER_DISGUISE_BS, Optional.empty());
        } else {
            this.field_6011.method_12778(DATA_PLAYER_DISGUISE_BS, Optional.of(state));
        }
        this.disguiseBlockState = state;
    }

    @Unique
    private void setDisguiseBlockPos(class_2338 pos) {
        this.field_6011.method_12778(DATA_PLAYER_DISGUISE_BP, (Object)pos);
        this.spawnedBlockPos = pos;
    }

    @Override
    public class_2680 blockHunters$getDisguiseBlockState() {
        Optional bsOptional = (Optional)this.field_6011.method_12789(DATA_PLAYER_DISGUISE_BS);
        return bsOptional.orElse(null);
    }

    @Override
    public class_2338 blockHunters$getDisguiseBlockPos() {
        return this.spawnedBlockPos;
    }

    @Override
    public class_2940<Boolean> blockHunters$getDataHasDisguise() {
        return DATA_PLAYER_HAS_DISGUISE;
    }

    public boolean method_5757() {
        if (this.blockHunters$hasDisguise()) {
            return false;
        }
        return super.method_5757();
    }

    public boolean method_5863() {
        if (this.blockHunters$hasDisguise() && !this.disguiseVisible) {
            return false;
        }
        return super.method_5863();
    }

    public boolean method_5810() {
        if (this.blockHunters$hasDisguise() && !this.disguiseVisible) {
            return false;
        }
        return super.method_5810();
    }

    public void method_5697(class_1297 entity) {
        if (this.blockHunters$hasDisguise() && !this.disguiseVisible) {
            return;
        }
        super.method_5697(entity);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (!this.field_6002.method_8608()) {
            return;
        }
        if (key.equals(DATA_PLAYER_DISGUISE_BS)) {
            this.disguiseBlockState = this.blockHunters$getDisguiseBlockState();
        } else if (key.equals(DATA_PLAYER_DISGUISE_BP)) {
            this.spawnedBlockPos = (class_2338)this.field_6011.method_12789(DATA_PLAYER_DISGUISE_BP);
        } else if (key.equals(DATA_PLAYER_DISGUISE_VISIBLE)) {
            this.disguiseVisible = (Boolean)this.field_6011.method_12789(DATA_PLAYER_DISGUISE_VISIBLE);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void customTickEnd(CallbackInfo ci) {
        if (this.field_6002.method_8608()) {
            if (this.spawnedBlockPos != class_2338.field_10980) {
                class_2680 state = this.field_6002.method_8320(this.spawnedBlockPos);
                state.field_23176 = class_2246::method_26122;
                state.field_23175 = class_2246::method_26122;
                this.field_6002.method_8652(this.spawnedBlockPos, state, 0);
            }
        } else if (this.blockHunters$hasDisguise()) {
            if (this.spawnedBlockPos != class_2338.field_10980) {
                class_243 currentPos = this.method_19538();
                class_2680 state = this.field_6002.method_8320(this.spawnedBlockPos);
                double dist = this.spawnedBlockPos.method_19770((class_2374)currentPos);
                if (dist > 1.0 || state.method_26215() || this.disguiseVisible) {
                    if (!state.method_26215() && !this.disguiseVisible) {
                        this.setDisguiseBlockState(state);
                    }
                    this.field_6002.method_8501(this.spawnedBlockPos, class_2246.field_10124.method_9564());
                    this.blockHunters$setDisguiseVisible(true);
                    this.setDisguiseBlockPos(class_2338.field_10980);
                    this.stillnessCounter = 0;
                }
            } else {
                if (this.stillnessCounter >= 60) {
                    this.blockHunters$setDisguiseVisible(false);
                    class_2338 blockPos = this.method_24515();
                    this.field_6002.method_8501(blockPos, this.disguiseBlockState);
                    this.setDisguiseBlockPos(blockPos);
                }
                ++this.stillnessCounter;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addDisguiseData(class_2487 compound, CallbackInfo ci) {
        if (this.disguiseBlockState != null) {
            compound.method_10566("BlockDisguise", (class_2520)class_2512.method_10686((class_2680)this.disguiseBlockState));
        }
        if (this.spawnedBlockPos != class_2338.field_10980) {
            compound.method_10566("BlockPos", (class_2520)class_2512.method_10692((class_2338)this.spawnedBlockPos));
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readDisguiseData(class_2487 compound, CallbackInfo ci) {
        class_2338 blockPos;
        if (compound.method_10545("BlockDisguise")) {
            this.setDisguiseBlockState(class_2512.method_10681((class_2487)compound.method_10562("BlockDisguise")));
            this.field_6011.method_12778(DATA_PLAYER_HAS_DISGUISE, (Object)true);
        }
        if (compound.method_10545("BlockPos") && !this.field_6002.method_8320(blockPos = class_2512.method_10691((class_2487)compound.method_10562("BlockPos"))).method_26215()) {
            this.blockHunters$setDisguiseVisible(false);
            this.setDisguiseBlockPos(blockPos);
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineDisguiseData(CallbackInfo ci) {
        this.field_6011.method_12784(DATA_PLAYER_HAS_DISGUISE, (Object)false);
        this.field_6011.method_12784(DATA_PLAYER_DISGUISE_VISIBLE, (Object)false);
        this.field_6011.method_12784(DATA_PLAYER_DISGUISE_BS, Optional.empty());
        this.field_6011.method_12784(DATA_PLAYER_DISGUISE_BP, (Object)class_2338.field_10980);
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        if (this.blockHunters$hasDisguise()) {
            float size = BlockHuntersConfig.smallerPlayerDimensions ? 0.8f : 1.0f;
            cir.setReturnValue((Object)class_4048.method_18385((float)size, (float)size));
        }
    }

    @Inject(method={"getStandingEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void disguiseEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        if (this.blockHunters$hasDisguise()) {
            cir.setReturnValue((Object)Float.valueOf(0.5f));
        }
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void disguiseNoMining(class_2680 state, CallbackInfoReturnable<Float> cir) {
        if (this.blockHunters$hasDisguise() && !this.disguiseVisible) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }
}

