/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.projectiles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2604;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import tech.alexnijjar.endermanoverhaul.common.ModUtils;
import tech.alexnijjar.endermanoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.endermanoverhaul.common.entities.EndIslandsEnderman;
import tech.alexnijjar.endermanoverhaul.common.registry.ModEntityTypes;

public class EnderBullet
extends class_1676
implements IAnimatable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final double SPEED = 0.25;
    @Nullable
    private class_1297 finalTarget;
    @Nullable
    private class_2350 currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public EnderBullet(class_1299<? extends EnderBullet> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5960 = true;
    }

    public EnderBullet(class_1937 level, class_1309 livingEntity, @Nullable class_1297 entity, class_2350.class_2351 axis) {
        this((class_1299<? extends EnderBullet>)((class_1299)ModEntityTypes.ENDER_BULLET.get()), level);
        this.method_7432((class_1297)livingEntity);
        class_2338 blockPos = livingEntity.method_24515();
        double d = (double)blockPos.method_10263() + 0.5;
        double e = (double)blockPos.method_10264() + 0.5;
        double f = (double)blockPos.method_10260() + 0.5;
        this.method_5808(d, e, f, this.method_36454(), this.method_36455());
        this.finalTarget = entity;
        this.currentMoveDirection = class_2350.field_11036;
        this.selectNextMoveDirection(axis);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, state -> {
            state.getController().setAnimation(ConstantAnimations.SPIN);
            return PlayState.CONTINUE;
        }));
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.finalTarget != null) {
            compound.method_25927("Target", this.finalTarget.method_5667());
        }
        if (this.currentMoveDirection != null) {
            compound.method_10569("Dir", this.currentMoveDirection.method_10146());
        }
        compound.method_10569("Steps", this.flightSteps);
        compound.method_10549("TXD", this.targetDeltaX);
        compound.method_10549("TYD", this.targetDeltaY);
        compound.method_10549("TZD", this.targetDeltaZ);
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.flightSteps = compound.method_10550("Steps");
        this.targetDeltaX = compound.method_10574("TXD");
        this.targetDeltaY = compound.method_10574("TYD");
        this.targetDeltaZ = compound.method_10574("TZD");
        if (compound.method_10573("Dir", 99)) {
            this.currentMoveDirection = class_2350.method_10143((int)compound.method_10550("Dir"));
        }
        if (compound.method_25928("Target")) {
            this.targetId = compound.method_25926("Target");
        }
    }

    protected void method_5693() {
    }

    private void setMoveDirection(@Nullable class_2350 direction) {
        this.currentMoveDirection = direction;
    }

    private void selectNextMoveDirection(@Nullable class_2350.class_2351 axis) {
        class_2338 blockPos;
        double d = 0.5;
        if (this.finalTarget == null) {
            blockPos = this.method_24515().method_10074();
        } else {
            d = (double)this.finalTarget.method_17682() * 0.5;
            blockPos = new class_2338(this.finalTarget.method_23317(), this.finalTarget.method_23318() + d, this.finalTarget.method_23321());
        }
        double e = (double)blockPos.method_10263() + 0.5;
        double f = (double)blockPos.method_10264() + d;
        double g = (double)blockPos.method_10260() + 0.5;
        class_2350 direction = null;
        if (!blockPos.method_19769((class_2374)this.method_19538(), 2.0)) {
            class_2338 blockPos2 = this.method_24515();
            ArrayList list = Lists.newArrayList();
            if (axis != class_2350.class_2351.field_11048) {
                if (blockPos2.method_10263() < blockPos.method_10263() && this.field_6002.method_22347(blockPos2.method_10078())) {
                    list.add(class_2350.field_11034);
                } else if (blockPos2.method_10263() > blockPos.method_10263() && this.field_6002.method_22347(blockPos2.method_10067())) {
                    list.add(class_2350.field_11039);
                }
            }
            if (axis != class_2350.class_2351.field_11052) {
                if (blockPos2.method_10264() < blockPos.method_10264() && this.field_6002.method_22347(blockPos2.method_10084())) {
                    list.add(class_2350.field_11036);
                } else if (blockPos2.method_10264() > blockPos.method_10264() && this.field_6002.method_22347(blockPos2.method_10074())) {
                    list.add(class_2350.field_11033);
                }
            }
            if (axis != class_2350.class_2351.field_11051) {
                if (blockPos2.method_10260() < blockPos.method_10260() && this.field_6002.method_22347(blockPos2.method_10072())) {
                    list.add(class_2350.field_11035);
                } else if (blockPos2.method_10260() > blockPos.method_10260() && this.field_6002.method_22347(blockPos2.method_10095())) {
                    list.add(class_2350.field_11043);
                }
            }
            direction = class_2350.method_10162((class_5819)this.field_5974);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_6002.method_22347(blockPos2.method_10093(direction)) && i > 0; --i) {
                    direction = class_2350.method_10162((class_5819)this.field_5974);
                }
            } else {
                direction = (class_2350)list.get(this.field_5974.method_43048(list.size()));
            }
            e = this.method_23317() + (double)direction.method_10148();
            f = this.method_23318() + (double)direction.method_10164();
            g = this.method_23321() + (double)direction.method_10165();
        }
        this.setMoveDirection(direction);
        double h = e - this.method_23317();
        double j = f - this.method_23318();
        double k = g - this.method_23321();
        double l = Math.sqrt(h * h + j * j + k * k);
        if (l == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = h / l * 0.25;
            this.targetDeltaY = j / l * 0.25;
            this.targetDeltaZ = k / l * 0.25;
        }
        this.field_6007 = true;
        this.flightSteps = 10 + this.field_5974.method_43048(5) * 10;
    }

    public void method_5982() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
    }

    public void method_5773() {
        class_243 vec3;
        super.method_5773();
        if (!this.field_6002.field_9236) {
            class_239 hitResult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((class_3218)this.field_6002).method_14190(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.method_5805() || this.finalTarget instanceof class_1657 && this.finalTarget.method_7325()) {
                if (!this.method_5740()) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = class_3532.method_15350((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = class_3532.method_15350((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = class_3532.method_15350((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                vec3 = this.method_18798();
                this.method_18799(vec3.method_1031((this.targetDeltaX - vec3.field_1352) * 0.2, (this.targetDeltaY - vec3.field_1351) * 0.2, (this.targetDeltaZ - vec3.field_1350) * 0.2));
            }
            if ((hitResult = class_1675.method_18074((class_1297)this, this::method_26958)).method_17783() != class_239.class_240.field_1333) {
                this.method_7488(hitResult);
            }
        }
        this.method_5852();
        vec3 = this.method_18798();
        this.method_5814(this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        class_1675.method_7484((class_1297)this, (float)0.5f);
        if (this.field_6002.field_9236) {
            for (int i = 0; i < 5; ++i) {
                this.field_6002.method_8406((class_2394)class_2398.field_11214, this.method_23322(0.5), this.method_23319() - 0.25, this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * 2.0, -this.field_5974.method_43058(), (this.field_5974.method_43058() - 0.5) * 2.0);
            }
        } else if (this.finalTarget != null && !this.finalTarget.method_31481()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.method_10166());
                }
            }
            if (this.currentMoveDirection != null) {
                class_2338 blockPos = this.method_24515();
                class_2350.class_2351 axis = this.currentMoveDirection.method_10166();
                if (this.field_6002.method_8515(blockPos.method_10093(this.currentMoveDirection), (class_1297)this)) {
                    this.selectNextMoveDirection(axis);
                } else {
                    class_2338 blockPos2 = this.finalTarget.method_24515();
                    if (axis == class_2350.class_2351.field_11048 && blockPos.method_10263() == blockPos2.method_10263() || axis == class_2350.class_2351.field_11051 && blockPos.method_10260() == blockPos2.method_10260() || axis == class_2350.class_2351.field_11052 && blockPos.method_10264() == blockPos2.method_10264()) {
                        this.selectNextMoveDirection(axis);
                    }
                }
            }
        }
    }

    protected boolean method_26958(@NotNull class_1297 target) {
        return super.method_26958(target) && !target.field_5960;
    }

    public boolean method_5809() {
        return false;
    }

    public boolean method_5640(double distance) {
        return distance < 16384.0;
    }

    public float method_5718() {
        return 1.0f;
    }

    protected void method_7454(@NotNull class_3966 result) {
        class_1309 e;
        class_1309 livingEntity;
        if (result.method_17782() instanceof EndIslandsEnderman) {
            return;
        }
        super.method_7454(result);
        class_1297 class_12972 = result.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 target = (class_1309)class_12972;
        class_1297 class_12973 = this.method_24921();
        class_1309 class_13092 = livingEntity = class_12973 instanceof class_1309 ? (e = (class_1309)class_12973) : null;
        if (target.method_5643(class_1282.method_5519((class_1297)this, (class_1309)livingEntity).method_5517(), 15.0f)) {
            if (livingEntity != null) {
                this.method_5723(livingEntity, (class_1297)target);
            }
            ModUtils.teleportTarget(this.field_6002, target, 32);
        }
    }

    protected void method_24920(@NotNull class_3965 result) {
        super.method_24920(result);
        ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 2, 0.2, 0.2, 0.2, 0.0);
        this.method_5783(class_3417.field_14895, 1.0f, 1.0f);
    }

    protected void method_7488(@NotNull class_239 result) {
        super.method_7488(result);
        this.method_31472();
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (!this.field_6002.field_9236) {
            this.method_5783(class_3417.field_14977, 1.0f, 1.0f);
            ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(), 15, 0.2, 0.2, 0.2, 0.0);
            this.method_31472();
        }
        return true;
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        double d = packet.method_11170();
        double e = packet.method_11172();
        double f = packet.method_11173();
        this.method_18800(d, e, f);
    }
}

