/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.common.util;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.entity.ChairEntity;
import de.cristelknight.doapi.common.registry.DoApiEntityTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3965;

public class ChairUtil {
    private static final Map<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>> CHAIRS = new HashMap<class_2960, Map<class_2338, Pair<ChairEntity, class_2338>>>();

    public static class_1269 onUse(class_1937 world, class_1657 player, class_1268 hand, class_3965 hit, double extraHeight) {
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (ChairUtil.isPlayerSitting(player)) {
            return class_1269.field_5811;
        }
        if (hit.method_17780() == class_2350.field_11033) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hit.method_17777();
        if (!ChairUtil.isOccupied(world, hitPos) && player.method_5998(hand).method_7960()) {
            ChairEntity chair = (ChairEntity)((class_1299)DoApiEntityTypes.CHAIR.get()).method_5883(world);
            chair.method_5808((double)hitPos.method_10263() + 0.5, (double)hitPos.method_10264() + 0.25 + extraHeight, (double)hitPos.method_10260() + 0.5, 0.0f, 0.0f);
            if (ChairUtil.addChairEntity(world, hitPos, chair, player.method_24515())) {
                world.method_8649((class_1297)chair);
                player.method_5804((class_1297)chair);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static void onStateReplaced(class_1937 world, class_2338 pos) {
        ChairEntity entity;
        if (!world.field_9236 && (entity = ChairUtil.getChairEntity(world, pos)) != null) {
            ChairUtil.removeChairEntity(world, pos);
            entity.method_5772();
        }
    }

    public static boolean addChairEntity(class_1937 world, class_2338 blockPos, ChairEntity entity, class_2338 playerPos) {
        if (!world.field_9236) {
            class_2960 id = ChairUtil.getDimensionTypeId(world);
            if (!CHAIRS.containsKey(id)) {
                CHAIRS.put(id, new HashMap());
            }
            CHAIRS.get(id).put(blockPos, (Pair<ChairEntity, class_2338>)Pair.of((Object)((Object)entity), (Object)playerPos));
            return true;
        }
        return false;
    }

    public static boolean removeChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world))) {
            CHAIRS.get(id).remove(pos);
            return true;
        }
        return false;
    }

    public static ChairEntity getChairEntity(class_1937 world, class_2338 pos) {
        class_2960 id;
        if (!world.field_9236 && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(world)) && CHAIRS.get(id).containsKey(pos)) {
            return (ChairEntity)((Object)CHAIRS.get(id).get(pos).getFirst());
        }
        return null;
    }

    public static class_2338 getPreviousPlayerPosition(class_1657 player, ChairEntity chairEntity) {
        class_2960 id;
        if (!player.field_6002.field_9236 && CHAIRS.containsKey(id = ChairUtil.getDimensionTypeId(player.field_6002))) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(id).values()) {
                if (pair.getFirst() != chairEntity) continue;
                return (class_2338)pair.getSecond();
            }
        }
        return null;
    }

    public static boolean isOccupied(class_1937 world, class_2338 pos) {
        class_2960 id = ChairUtil.getDimensionTypeId(world);
        return CHAIRS.containsKey(id) && CHAIRS.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(class_1657 player) {
        for (class_2960 i : CHAIRS.keySet()) {
            for (Pair<ChairEntity, class_2338> pair : CHAIRS.get(i).values()) {
                if (!((ChairEntity)((Object)pair.getFirst())).method_5626((class_1297)player)) continue;
                return true;
            }
        }
        return false;
    }

    private static class_2960 getDimensionTypeId(class_1937 world) {
        return world.method_44013().method_29177();
    }
}

