/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.config.builtin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.doapi.config.jankson.config.CommentedConfig;
import java.util.HashMap;
import net.minecraft.class_156;

public record RBConfig(boolean recipeBookOpen, boolean craftableToggle) implements CommentedConfig<RBConfig>
{
    private static RBConfig INSTANCE = null;
    public static final RBConfig DEFAULT = new RBConfig(false, true);
    public static final Codec<RBConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("recipe_book_open").orElse((Object)RBConfig.DEFAULT.recipeBookOpen).forGetter(c -> c.recipeBookOpen), (App)Codec.BOOL.fieldOf("craftable_toggle").orElse((Object)RBConfig.DEFAULT.craftableToggle).forGetter(c -> c.craftableToggle)).apply((Applicative)builder, RBConfig::new));

    @Override
    public HashMap<String, String> getComments() {
        return (HashMap)class_156.method_654(new HashMap(), map -> {
            map.put("recipe_book_open", "Is the recipe book open");
            map.put("craftable_toggle", "Only show craftable items");
        });
    }

    @Override
    public String getHeader() {
        return "Do Api Config\n\n=======\nLinks:\nCurseForge: https://www.curseforge.com/minecraft/mc-mods/do-api\nModrinth: https://modrinth.com/mod/do-api\nGitHub: https://github.com/Cristelknight999/DoAPI";
    }

    @Override
    public String getSubPath() {
        return "doapi/recipebook";
    }

    @Override
    public RBConfig getInstance() {
        return INSTANCE;
    }

    @Override
    public RBConfig getDefault() {
        return DEFAULT;
    }

    @Override
    public Codec<RBConfig> getCodec() {
        return CODEC;
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public void setInstance(RBConfig instance) {
        INSTANCE = instance;
    }

    public static void setCraftableToggle(boolean bl) {
        RBConfig c = (RBConfig)DEFAULT.getConfig();
        c.setInstance(new RBConfig(c.recipeBookOpen(), bl));
        c.getConfig(true, true);
    }

    public static void setRecipeBookOpenToggle(boolean bl) {
        RBConfig c = (RBConfig)DEFAULT.getConfig();
        c.setInstance(new RBConfig(bl, c.craftableToggle()));
        c.getConfig(true, true);
    }
}

