/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.config.jankson;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.cristelknight.doapi.DoApi;
import de.cristelknight.doapi.config.jankson.Array2;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;

public class ConfigUtil {
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Supplier<JsonGrammar.Builder> JSON_GRAMMAR_BUILDER = () -> new JsonGrammar.Builder().withComments(true).bareSpecialNumerics(true).printCommas(true);
    public static final JsonGrammar JSON_GRAMMAR = JSON_GRAMMAR_BUILDER.get().build();
    public static final String MODID = "Do Api";

    public static <T> T readConfig(Path path, Codec<T> codec, DynamicOps<JsonElement> ops) {
        try {
            JsonObject load = JANKSON.load(path.toFile());
            DataResult decode = codec.decode(ops, (Object)load);
            Optional error = decode.error();
            if (error.isPresent()) {
                throw new IllegalArgumentException("[Do Api] Couldn't read " + String.valueOf(path) + ", crashing instead. Maybe try to delete the config files!");
            }
            return (T)((Pair)decode.result().orElseThrow()).getFirst();
        }
        catch (Exception errorMsg) {
            throw new IllegalArgumentException("[Do Api] Couldn't read " + String.valueOf(path) + ", crashing instead. Maybe try to delete the config files!");
        }
    }

    public static <T> void createConfig(Path path, Codec<T> codec, Map<String, String> comments, DynamicOps<JsonElement> ops, T from, boolean sorted, String header) {
        DataResult dataResult = codec.encodeStart(ops, from);
        Optional error = dataResult.error();
        if (error.isPresent()) {
            throw new IllegalArgumentException(String.format("Jankson file creation for \"%s\" failed due to the following error(s):\n%s", path.toString(), ((DataResult.PartialResult)error.get()).message()));
        }
        JsonElement jsonElement = (JsonElement)dataResult.result().orElseThrow();
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonElement = ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, jsonObject, "", sorted);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            header = header != null ? (String)header + "\n" : "";
            String output = (String)header + jsonElement.toJson(JSON_GRAMMAR);
            Files.write(path, output.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            DoApi.LOGGER.error(e.toString());
        }
    }

    public static JsonObject addCommentsAndAlphabeticallySortRecursively(Map<String, String> comments, JsonObject object, String parentKey, boolean alphabeticallySorted) {
        for (Map.Entry entry2 : object.entrySet()) {
            JsonElement value;
            String objectKey = (String)entry2.getKey();
            String commentsKey = parentKey + objectKey;
            String comment = object.getComment((String)entry2.getKey());
            if (comments.containsKey(commentsKey) && comment == null) {
                String commentToAdd = comments.get(commentsKey);
                object.setComment(objectKey, commentToAdd);
                comment = commentToAdd;
            }
            if ((value = (JsonElement)entry2.getValue()) instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                JsonArray sortedJsonElements = new JsonArray();
                for (JsonElement element : array) {
                    if (element instanceof JsonObject) {
                        JsonObject nestedObject = (JsonObject)element;
                        sortedJsonElements.add((JsonElement)ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, (String)entry2.getKey() + ".", alphabeticallySorted));
                        continue;
                    }
                    if (!(element instanceof JsonArray)) continue;
                    JsonArray array1 = (JsonArray)element;
                    Array2 arrayOfArrays = new Array2();
                    arrayOfArrays.addAll((Collection)array1);
                    sortedJsonElements.add((JsonElement)arrayOfArrays);
                }
                if (!sortedJsonElements.isEmpty()) {
                    object.put(objectKey, (JsonElement)sortedJsonElements, comment);
                }
            }
            if (!(value instanceof JsonObject)) continue;
            JsonObject nestedObject = (JsonObject)value;
            object.put(objectKey, (JsonElement)ConfigUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, (String)entry2.getKey() + ".", alphabeticallySorted), comment);
        }
        if (alphabeticallySorted) {
            JsonObject alphabeticallySortedJsonObject = new JsonObject();
            TreeMap map = new TreeMap(String::compareTo);
            map.putAll(object);
            alphabeticallySortedJsonObject.putAll(map);
            alphabeticallySortedJsonObject.forEach((key, entry) -> alphabeticallySortedJsonObject.setComment(key, object.getComment(key)));
            return alphabeticallySortedJsonObject;
        }
        return object;
    }
}

