/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.fabric;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.impl.entity.TerraformBoatEntity;
import com.terraformersmc.terraform.boat.impl.entity.TerraformChestBoatEntity;
import com.terraformersmc.terraform.sign.SpriteIdentifierRegistry;
import com.terraformersmc.terraform.sign.block.TerraformSignBlock;
import com.terraformersmc.terraform.sign.block.TerraformWallSignBlock;
import de.cristelknight.doapi.fabric.terraform.DoApiBoatTypeHolder;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1690;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4970;
import net.minecraft.class_5321;

public class DoApiExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static void registerBoatType(class_2960 boatTypeName, TerraformBoatType type) {
        DoApiBoatTypeHolder holder = new DoApiBoatTypeHolder(type.getItem(), type.getChestItem(), type.getPlanks());
        class_2378.method_10230((class_2378)TerraformBoatTypeRegistry.INSTANCE, (class_2960)boatTypeName, (Object)((Object)holder));
    }

    public static class_1690 createBoat(class_2960 boatTypeName, class_1937 world, double x, double y, double z, boolean chest) {
        TerraformChestBoatEntity boatEntity;
        com.terraformersmc.terraform.boat.api.TerraformBoatType boatType = (com.terraformersmc.terraform.boat.api.TerraformBoatType)TerraformBoatTypeRegistry.INSTANCE.method_10223(boatTypeName);
        if (chest) {
            TerraformChestBoatEntity chestBoat = new TerraformChestBoatEntity(world, x, y, z);
            chestBoat.setTerraformBoat(boatType);
            boatEntity = chestBoat;
        } else {
            TerraformBoatEntity boat = new TerraformBoatEntity(world, x, y, z);
            boat.setTerraformBoat(boatType);
            boatEntity = boat;
        }
        return boatEntity;
    }

    public static Set<class_2960> getAllDoApiBoatTypeNames() {
        HashSet<class_2960> boats = new HashSet<class_2960>();
        for (Map.Entry entry : TerraformBoatTypeRegistry.INSTANCE.method_29722()) {
            if (!(entry.getValue() instanceof DoApiBoatTypeHolder)) continue;
            boats.add(((class_5321)entry.getKey()).method_29177());
        }
        return boats;
    }

    public static void addFlammable(int burnOdd, int igniteOdd, class_2248 ... blocks) {
        FlammableBlockRegistry registry = FlammableBlockRegistry.getDefaultInstance();
        for (class_2248 b : blocks) {
            registry.add(b, burnOdd, igniteOdd);
        }
    }

    public static class_2248 getSign(class_2960 signTextureId) {
        return new TerraformSignBlock(signTextureId, class_4970.class_2251.method_9630((class_4970)class_2246.field_10121));
    }

    public static class_2248 getWallSign(class_2960 signTextureId) {
        return new TerraformWallSignBlock(signTextureId, class_4970.class_2251.method_9630((class_4970)class_2246.field_10121));
    }

    public static void addSignSprite(class_2960 signTextureId) {
        SpriteIdentifierRegistry.INSTANCE.addIdentifier(new class_4730(class_4722.field_21708, signTextureId));
    }

    public static <T> List<Pair<List<String>, T>> findAPIs(Class<T> returnClazz, String name, Class<?> annotationClazz) {
        ArrayList instances = Lists.newArrayList();
        FabricLoader.getInstance().getEntrypointContainers(name, returnClazz).forEach(entrypoint -> {
            String modId = entrypoint.getProvider().getMetadata().getId();
            Object api = entrypoint.getEntrypoint();
            instances.add(new Pair(List.of(modId), api));
        });
        return instances;
    }
}

