/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1422;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_922;
import net.minecraft.class_927;

public abstract class ThievesFishRenderer<V extends FishData, T extends class_1422, M extends class_583<T>>
extends class_927<T, M> {
    protected ThievesFishRenderer(class_5617.class_5618 context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.method_4046(new GlowFishLayer(this));
        this.method_4046(new HeadphoneLayer((class_922<?, ?>)this, context.method_32170(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void render(T livingEntity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        this.field_4673 = ((ThievesFish)livingEntity).isTrophy() ? 0.25f : 0.15f;
        super.method_4072(livingEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.method_4058(entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        boolean inWater = entity.method_5799() || ((ThievesFish)entity).isNoFlip();
        RotationRenderData rotationRenderData = this.setupRotations(entity, inWater);
        float degree = rotationRenderData.baseDegree * class_3532.method_15374((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * ageInTicks));
        poseStack.method_22907(class_1160.field_20705.method_23214(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.method_22907(class_1160.field_20707.method_23214(90.0f));
        }
    }

    public class_2960 getTextureLocation(T livingEntity) {
        return ((ThievesFish)livingEntity).getVariant().getTexture();
    }

    protected void scale(T livingEntity, class_4587 poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.method_22905(scale, scale, scale);
    }

    public abstract RotationRenderData setupRotations(T var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

