/*
 * Decompiled with CFR 0.152.
 */
package net.larsmans.infinitybuttons;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.loader.api.FabricLoader;
import net.larsmans.infinitybuttons.InfinityButtonsInit;
import net.larsmans.infinitybuttons.block.InfinityButtonsBlocks;
import net.larsmans.infinitybuttons.block.custom.letterbutton.LetterButton;
import net.larsmans.infinitybuttons.block.custom.letterbutton.gui.LetterButtonGui;
import net.larsmans.infinitybuttons.compat.IBNethersDelightBlocks;
import net.larsmans.infinitybuttons.config.AlarmEnum;
import net.larsmans.infinitybuttons.particle.DiamondSparkleParticle;
import net.larsmans.infinitybuttons.particle.InfinityButtonsParticleTypes;
import net.larsmans.infinitybuttons.sounds.InfinityButtonsSounds;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_638;

public class InfinityButtonsClientInit
implements ClientModInitializer {
    private static boolean forceHidden = true;

    public void onInitializeClient() {
        InfinityButtonsClientInit.registerPackets();
        InfinityButtonsClientInit.registerClientEvents();
        ClientSpriteRegistryCallback.event((class_2960)class_1723.field_21668).register((atlasTexture, registry) -> registry.register(new class_2960("infinitybuttons", "particle/diamond_sparkle")));
        ParticleFactoryRegistry.getInstance().register((class_2396)InfinityButtonsParticleTypes.DIAMOND_SPARKLE, DiamondSparkleParticle.Factory::new);
        this.transparent(InfinityButtonsBlocks.TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.WALL_TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.WALL_TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.SOUL_TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.SOUL_WALL_TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.SOUL_TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.SOUL_WALL_TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.REDSTONE_TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.REDSTONE_WALL_TORCH_BUTTON);
        this.transparent(InfinityButtonsBlocks.REDSTONE_TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.REDSTONE_WALL_TORCH_LEVER);
        this.transparent(InfinityButtonsBlocks.RED_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.ORANGE_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.YELLOW_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.LIME_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.GREEN_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.CYAN_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.LIGHT_BLUE_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.BLUE_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.PURPLE_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.MAGENTA_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.PINK_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.BROWN_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.WHITE_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.LIGHT_GRAY_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.GRAY_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.BLACK_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.FANCY_SAFE_EMERGENCY_BUTTON);
        this.transparent(InfinityButtonsBlocks.LETTER_BUTTON);
        this.transparent(InfinityButtonsBlocks.LETTER_LEVER);
        this.transparent(InfinityButtonsBlocks.LANTERN_BUTTON);
        this.transparent(InfinityButtonsBlocks.LANTERN_LEVER);
        this.transparent(InfinityButtonsBlocks.SOUL_LANTERN_BUTTON);
        this.transparent(InfinityButtonsBlocks.SOUL_LANTERN_LEVER);
        this.transparent(InfinityButtonsBlocks.SMALL_CONSOLE_BUTTON);
        this.transparent(InfinityButtonsBlocks.SMALL_CONSOLE_LEVER);
        this.transparent(InfinityButtonsBlocks.CONSOLE_BUTTON);
        this.transparent(InfinityButtonsBlocks.CONSOLE_LEVER);
        this.transparent(InfinityButtonsBlocks.LARGE_CONSOLE_BUTTON);
        this.transparent(InfinityButtonsBlocks.LARGE_CONSOLE_LEVER);
        this.transparent(InfinityButtonsBlocks.BIG_CONSOLE_BUTTON);
        this.transparent(InfinityButtonsBlocks.BIG_CONSOLE_LEVER);
        if (FabricLoader.getInstance().isModLoaded("nethersdelight")) {
            this.transparent(IBNethersDelightBlocks.PROPELPLANT_TORCH_BUTTON);
            this.transparent(IBNethersDelightBlocks.PROPELPLANT_WALL_TORCH_BUTTON);
            this.transparent(IBNethersDelightBlocks.PROPELPLANT_TORCH_LEVER);
            this.transparent(IBNethersDelightBlocks.PROPELPLANT_WALL_TORCH_LEVER);
        }
    }

    private void transparent(class_2248 block) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
    }

    public static void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)InfinityButtonsInit.LETTER_BUTTON_SCREEN_PACKET, (client, handler, buf, responseSender) -> {
            class_638 world = client.field_1687;
            class_2338 pos = buf.method_10811();
            class_2680 state = world.method_8320(pos);
            class_2248 patt6046$temp = state.method_26204();
            if (patt6046$temp instanceof LetterButton) {
                LetterButton letterButton = (LetterButton)patt6046$temp;
                client.execute(() -> InfinityButtonsClientInit.lambda$registerPackets$1(letterButton, state, (class_1937)world, pos));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)InfinityButtonsInit.ALARM_PACKET, (client, handler, buf, responseSender) -> {
            if (InfinityButtonsInit.CONFIG.muteAlarmSound()) {
                return;
            }
            class_2338 pos = buf.method_10811();
            AlarmEnum alarmEnum = (AlarmEnum)buf.method_10818(AlarmEnum.class);
            if (alarmEnum == AlarmEnum.GLOBAL) {
                InfinityButtonsClientInit.playGlobalSound((class_1937)client.field_1687, pos, InfinityButtonsSounds.ALARM, class_3419.field_15245);
            } else {
                assert (client.field_1687 != null);
                client.field_1687.method_8396((class_1657)client.field_1724, pos, InfinityButtonsSounds.ALARM, class_3419.field_15245, (float)InfinityButtonsInit.CONFIG.alarmSoundRange(), 1.0f);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)InfinityButtonsInit.JADE_PACKET, (client, handler, buf, responseSender) -> {
            forceHidden = buf.readBoolean();
        });
    }

    public static void playGlobalSound(class_1937 world, class_2338 pos, class_3414 soundEvent, class_3419 soundCategory) {
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        class_243 centerPos = class_243.method_24953((class_2382)pos);
        if (cam.method_19332()) {
            float chunkDistance = (float)cam.method_19326().method_1022(centerPos) / 16.0f;
            world.method_8486(centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), soundEvent, soundCategory, chunkDistance * 1.3f + 20.0f, 1.0f, false);
        }
    }

    public static boolean getForceHidden() {
        return forceHidden;
    }

    public static void registerClientEvents() {
        ClientPlayConnectionEvents.JOIN.register((clientPlayNetworkHandler, packetSender, minecraftClient) -> ClientPlayNetworking.send((class_2960)InfinityButtonsInit.REQUEST_JADE_PACKET, (class_2540)PacketByteBufs.create().method_10814("Safety Buttons are Stylish!")));
    }

    private static /* synthetic */ void lambda$registerPackets$1(LetterButton letterButton, class_2680 state, class_1937 world, class_2338 pos) {
        class_310.method_1551().method_1507((class_437)new LetterButtonGui(letterButton, state, world, pos));
    }
}

