/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5225;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import satisfyu.candlelight.client.gui.NotePaperGui;
import satisfyu.candlelight.util.CandlelightIdentifier;

public abstract class NoteGui
extends class_437 {
    public static final class_2960 NOTE_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private static final class_2561 EDIT_TITLE_TEXT = class_2561.method_43470((String)"Enter Note Title");
    private static final class_2561 FINALIZE_WARNING_TEXT = class_2561.method_43471((String)"book.finalizeWarning");
    private static final class_5481 BLACK_CURSOR_TEXT = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360.method_10977(class_124.field_1074));
    private static final class_5481 GRAY_CURSOR_TEXT = class_5481.method_30747((String)"_", (class_2583)class_2583.field_24360.method_10977(class_124.field_1080));
    protected final class_1657 player;
    protected final class_1799 itemStack;
    protected boolean dirty;
    private boolean signing;
    private int tickCounter;
    private final List<String> text = Lists.newArrayList();
    private String title = "";
    private final class_3728 currentPageSelectionManager = new class_3728(this::getCurrentPageContent, this::setPageContent, this::getClipboard, this::setClipboard, string -> string.length() < 1024 && this.field_22793.method_1713(string, 114) <= 128);
    private final class_3728 noteTitleSelectionManager = new class_3728(() -> this.title, title -> {
        this.title = title;
    }, this::getClipboard, this::setClipboard, string -> string.length() < 16);
    private long lastClickTime;
    private int lastClickIndex = -1;
    private class_4185 doneButton;
    private class_4185 signButton;
    private class_4185 finalizeButton;
    private class_4185 cancelButton;
    @Nullable
    private PageContent pageContent = PageContent.EMPTY;
    private final class_2561 signedByText;

    public NoteGui(class_1657 player, class_1799 itemStack) {
        super(class_333.field_18967);
        this.player = player;
        this.itemStack = itemStack;
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null) {
            List<String> string2 = this.text;
            Objects.requireNonNull(string2);
            this.loadPages(nbtCompound, string2::add);
        }
        if (this.text.isEmpty()) {
            this.text.add("");
        }
        this.signedByText = class_2561.method_43469((String)"book.byAuthor", (Object[])new Object[]{player.method_5477()}).method_27692(class_124.field_1063);
    }

    protected void method_25426() {
        this.invalidatePageContent();
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(true);
        }
        this.signButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 100, 196, 98, 20, (class_2561)class_2561.method_43471((String)"book.signButton"), button -> {
            this.signing = true;
            this.updateButtons();
        }));
        this.doneButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, 196, 98, 20, class_5244.field_24334, button -> {
            this.field_22787.method_1507(null);
            this.finalizeNote(false);
        }));
        this.finalizeButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 100, 196, 98, 20, (class_2561)class_2561.method_43471((String)"book.finalizeButton"), button -> {
            if (this.signing) {
                this.finalizeNote(true);
                this.field_22787.method_1507(null);
            }
        }));
        this.cancelButton = (class_4185)this.method_37063((class_364)new class_4185(this.field_22789 / 2 + 2, 196, 98, 20, class_5244.field_24335, button -> {
            if (this.signing) {
                this.signing = false;
            }
            this.updateButtons();
        }));
        this.updateButtons();
    }

    public void loadPages(class_2487 compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        class_2499 listTag = compoundTag.method_10554("text", 8).method_10612();
        if (class_310.method_1551().method_33883() && compoundTag.method_10573("filtered_pages", 10)) {
            class_2487 compoundTag2 = compoundTag.method_10562("filtered_pages");
            intFunction = i -> {
                String string = String.valueOf(i);
                return compoundTag2.method_10545(string) ? compoundTag2.method_10558(string) : listTag.method_10608(i);
            };
        } else {
            intFunction = arg_0 -> ((class_2499)listTag).method_10608(arg_0);
        }
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            consumer.accept(intFunction.apply(i2));
        }
    }

    protected void removeEmptyPages() {
        ListIterator<String> listIterator = this.text.listIterator(this.text.size());
        while (listIterator.hasPrevious() && listIterator.previous().isEmpty()) {
            listIterator.remove();
        }
    }

    protected abstract void finalizeNote(boolean var1);

    protected void writeNbtData(boolean signNote) {
        class_2499 nbtList = new class_2499();
        Stream<class_2519> nbts = this.text.stream().map(class_2519::method_23256);
        Objects.requireNonNull(nbtList);
        nbts.forEach(arg_0 -> nbtList.add(arg_0));
        if (!this.text.isEmpty()) {
            this.itemStack.method_7959("text", (class_2520)nbtList);
        }
        if (signNote) {
            this.itemStack.method_7959("author", (class_2520)class_2519.method_23256((String)this.player.method_7334().getName()));
            this.itemStack.method_7959("title", (class_2520)class_2519.method_23256((String)this.title.trim()));
        }
    }

    private void setClipboard(String clipboard) {
        if (this.field_22787 != null) {
            class_3728.method_27551((class_310)this.field_22787, (String)clipboard);
        }
    }

    private String getClipboard() {
        return this.field_22787 != null ? class_3728.method_27556((class_310)this.field_22787) : "";
    }

    public void method_25393() {
        super.method_25393();
        ++this.tickCounter;
    }

    public void method_25432() {
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1462(false);
        }
    }

    private void updateButtons() {
        this.doneButton.field_22764 = !this.signing;
        this.signButton.field_22764 = !this.signing;
        this.cancelButton.field_22764 = this.signing;
        this.finalizeButton.field_22764 = this.signing;
        this.finalizeButton.field_22763 = !this.title.trim().isEmpty();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.signing) {
            return this.keyPressedSignMode(keyCode);
        }
        boolean bl = this.keyPressedEditMode(keyCode);
        if (bl) {
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers)) {
            return true;
        }
        if (this.signing) {
            boolean bl = this.noteTitleSelectionManager.method_16199(chr);
            if (bl) {
                this.updateButtons();
                this.dirty = true;
                return true;
            }
            return false;
        }
        if (class_155.method_643((char)chr)) {
            this.currentPageSelectionManager.method_16197(Character.toString(chr));
            this.invalidatePageContent();
            return true;
        }
        return false;
    }

    private boolean keyPressedEditMode(int keyCode) {
        if (class_437.method_25439((int)keyCode)) {
            this.currentPageSelectionManager.method_27563();
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            this.currentPageSelectionManager.method_27559();
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.currentPageSelectionManager.method_27554();
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            this.currentPageSelectionManager.method_27547();
            return true;
        }
        class_3728.class_7279 selectionType = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.currentPageSelectionManager.method_16197("\n");
                return true;
            }
            case 259: {
                this.currentPageSelectionManager.method_42574(-1, selectionType);
                return true;
            }
            case 261: {
                this.currentPageSelectionManager.method_42574(1, selectionType);
                return true;
            }
            case 262: {
                this.currentPageSelectionManager.method_42575(1, class_437.method_25442(), selectionType);
                return true;
            }
            case 263: {
                this.currentPageSelectionManager.method_42575(-1, class_437.method_25442(), selectionType);
                return true;
            }
            case 264: {
                this.moveDownLine();
                return true;
            }
            case 265: {
                this.moveUpLine();
                return true;
            }
            case 268: {
                this.moveToLineStart();
                return true;
            }
            case 269: {
                this.moveToLineEnd();
                return true;
            }
        }
        return false;
    }

    private void moveUpLine() {
        this.moveVertically(-1);
    }

    private void moveDownLine() {
        this.moveVertically(1);
    }

    private void moveVertically(int lines) {
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.getPageContent().getVerticalOffset(i, lines);
        this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
    }

    private void moveToLineStart() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27553(class_437.method_25442());
        } else {
            int i = this.currentPageSelectionManager.method_16201();
            int j = this.getPageContent().getLineStart(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    private void moveToLineEnd() {
        if (class_437.method_25441()) {
            this.currentPageSelectionManager.method_27558(class_437.method_25442());
        } else {
            PageContent pageContent = this.getPageContent();
            int i = this.currentPageSelectionManager.method_16201();
            int j = pageContent.getLineEnd(i);
            this.currentPageSelectionManager.method_27560(j, class_437.method_25442());
        }
    }

    private boolean keyPressedSignMode(int keyCode) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.finalizeNote(true);
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507(null);
                    }
                }
                return true;
            }
            case 259: {
                this.noteTitleSelectionManager.method_27564(-1);
                this.updateButtons();
                this.dirty = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentPageContent() {
        return 0 < this.text.size() ? this.text.get(0) : "";
    }

    private void setPageContent(String newContent) {
        if (0 < this.text.size()) {
            this.text.set(0, newContent);
            this.dirty = true;
            this.invalidatePageContent();
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.method_25395(null);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)NOTE_TEXTURE);
        int x = (this.field_22789 - 192) / 2;
        this.method_25302(matrices, x, 2, 0, 0, 192, 192);
        if (this.signing) {
            boolean bl = this.tickCounter / 6 % 2 == 0;
            class_5481 orderedText = class_5481.method_30742((class_5481)class_5481.method_30747((String)this.title, (class_2583)class_2583.field_24360), (class_5481)(bl ? BLACK_CURSOR_TEXT : GRAY_CURSOR_TEXT));
            int k = this.field_22793.method_27525((class_5348)EDIT_TITLE_TEXT);
            this.field_22793.method_30883(matrices, EDIT_TITLE_TEXT, (float)(x + 36 + (114 - k) / 2), 34.0f, 0);
            int l = this.field_22793.method_30880(orderedText);
            this.field_22793.method_27528(matrices, orderedText, (float)(x + 36 + (114 - l) / 2), 50.0f, 0);
            int m = this.field_22793.method_27525((class_5348)this.signedByText);
            this.field_22793.method_30883(matrices, this.signedByText, (float)(x + 36 + (114 - m) / 2), 60.0f, 0);
            this.field_22793.method_1712((class_5348)FINALIZE_WARNING_TEXT, x + 36, 82, 114, 0);
        } else {
            PageContent pageContent = this.getPageContent();
            for (Line line : pageContent.lines) {
                this.field_22793.method_30883(matrices, line.text, (float)line.x, (float)line.y, -16777216);
            }
            this.drawSelection(pageContent.selectionRectangles);
            this.drawCursor(matrices, pageContent.position, pageContent.atEnd);
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void drawCursor(class_4587 matrices, Position position, boolean atEnd) {
        if (this.tickCounter / 6 % 2 == 0) {
            position = this.absolutePositionToScreenPosition(position);
            if (!atEnd) {
                int var10001 = position.x;
                int var10002 = position.y - 1;
                int var10003 = position.x + 1;
                int var10004 = position.y;
                Objects.requireNonNull(this.field_22793);
                class_332.method_25294((class_4587)matrices, (int)var10001, (int)var10002, (int)var10003, (int)(var10004 + 9), (int)-16777216);
            } else {
                this.field_22793.method_1729(matrices, "_", (float)position.x, (float)position.y, 0);
            }
        }
    }

    private void drawSelection(class_768[] selectionRectangles) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        for (class_768 rect2i : selectionRectangles) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            bufferBuilder.method_22912((double)i, (double)l, 0.0).method_1344();
            bufferBuilder.method_22912((double)k, (double)l, 0.0).method_1344();
            bufferBuilder.method_22912((double)k, (double)j, 0.0).method_1344();
            bufferBuilder.method_22912((double)i, (double)j, 0.0).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    private Position screenPositionToAbsolutePosition(Position position) {
        return new Position(position.x - (this.field_22789 - 192) / 2 - 36, position.y - 32);
    }

    private Position absolutePositionToScreenPosition(Position position) {
        return new Position(position.x + (this.field_22789 - 192) / 2 + 36, position.y + 32);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!super.method_25402(mouseX, mouseY, button) && button == 0) {
            long l = class_156.method_658();
            PageContent pageContent = this.getPageContent();
            int i = pageContent.getCursorPosition(this.field_22793, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
            if (i >= 0) {
                if (i == this.lastClickIndex && l - this.lastClickTime < 250L) {
                    if (!this.currentPageSelectionManager.method_27568()) {
                        this.selectCurrentWord(i);
                    } else {
                        this.currentPageSelectionManager.method_27563();
                    }
                } else {
                    this.currentPageSelectionManager.method_27560(i, class_437.method_25442());
                }
                this.invalidatePageContent();
            }
            this.lastClickIndex = i;
            this.lastClickTime = l;
        }
        return true;
    }

    private void selectCurrentWord(int cursor) {
        String string = this.getCurrentPageContent();
        this.currentPageSelectionManager.method_27548(class_5225.method_27483((String)string, (int)-1, (int)cursor, (boolean)false), class_5225.method_27483((String)string, (int)1, (int)cursor, (boolean)false));
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.method_25403(mouseX, mouseY, button, deltaX, deltaY) && button == 0) {
            PageContent pageContent = this.getPageContent();
            int i = pageContent.getCursorPosition(this.field_22793, this.screenPositionToAbsolutePosition(new Position((int)mouseX, (int)mouseY)));
            this.currentPageSelectionManager.method_27560(i, true);
            this.invalidatePageContent();
        }
        return true;
    }

    private PageContent getPageContent() {
        if (this.pageContent == null) {
            this.pageContent = this.createPageContent();
        }
        return this.pageContent;
    }

    private void invalidatePageContent() {
        this.pageContent = null;
    }

    private PageContent createPageContent() {
        int l;
        Position position;
        boolean bl;
        String string = this.getCurrentPageContent();
        if (string.isEmpty()) {
            return PageContent.EMPTY;
        }
        int i = this.currentPageSelectionManager.method_16201();
        int j = this.currentPageSelectionManager.method_16203();
        ArrayList intList = new ArrayList();
        ArrayList list = new ArrayList();
        MutableInt mutableInt = new MutableInt();
        MutableBoolean mutableBoolean = new MutableBoolean();
        class_5225 textHandler = this.field_22793.method_27527();
        textHandler.method_27485(string, 114, class_2583.field_24360, true, (style, start, end) -> {
            int h = mutableInt.getAndIncrement();
            String substring = string.substring(start, end);
            mutableBoolean.setValue(substring.endsWith("\n"));
            String string2 = StringUtils.stripEnd((String)substring, (String)" \n");
            Objects.requireNonNull(this.field_22793);
            int b = h * 9;
            Position position = this.absolutePositionToScreenPosition(new Position(0, b));
            intList.add(start);
            list.add(new Line(style, string2, position.x, position.y));
        });
        int[] is = intList.stream().mapToInt(Integer::intValue).toArray();
        boolean bl2 = bl = i == string.length();
        if (bl && mutableBoolean.isTrue()) {
            int var10003 = list.size();
            Objects.requireNonNull(this.field_22793);
            position = new Position(0, var10003 * 9);
        } else {
            int k = NoteGui.getLineFromOffset(is, i);
            l = this.field_22793.method_1727(string.substring(is[k], i));
            Objects.requireNonNull(this.field_22793);
            position = new Position(l, k * 9);
        }
        ArrayList<class_768> list2 = new ArrayList<class_768>();
        if (i != j) {
            int o;
            l = Math.min(i, j);
            int m = Math.max(i, j);
            int n = NoteGui.getLineFromOffset(is, l);
            if (n == (o = NoteGui.getLineFromOffset(is, m))) {
                Objects.requireNonNull(this.field_22793);
                int p = n * 9;
                int q = is[n];
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, m, p, q));
            } else {
                int p = n + 1 > is.length ? string.length() : is[n + 1];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, p, n * 9, is[n]));
                for (int q = n + 1; q < o; ++q) {
                    Objects.requireNonNull(this.field_22793);
                    int r = q * 9;
                    String string2 = string.substring(is[q], is[q + 1]);
                    int s = (int)textHandler.method_27482(string2);
                    Position var10002 = new Position(0, r);
                    Objects.requireNonNull(this.field_22793);
                    list2.add(this.getRectFromCorners(var10002, new Position(s, r + 9)));
                }
                int var10004 = is[o];
                Objects.requireNonNull(this.field_22793);
                list2.add(this.getLineSelectionRectangle(string, textHandler, var10004, m, o * 9, is[o]));
            }
        }
        return new PageContent(string, position, bl, is, list.toArray(new Line[0]), list2.toArray(new class_768[0]));
    }

    static int getLineFromOffset(int[] lineStarts, int position) {
        int i = Arrays.binarySearch(lineStarts, position);
        return i < 0 ? -(i + 2) : i;
    }

    private class_768 getLineSelectionRectangle(String string, class_5225 handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        String string2 = string.substring(lineStart, selectionStart);
        String string3 = string.substring(lineStart, selectionEnd);
        Position position = new Position((int)handler.method_27482(string2), lineY);
        int var10002 = (int)handler.method_27482(string3);
        Objects.requireNonNull(this.field_22793);
        Position position2 = new Position(var10002, lineY + 9);
        return this.getRectFromCorners(position, position2);
    }

    private class_768 getRectFromCorners(Position start, Position end) {
        Position position = this.absolutePositionToScreenPosition(start);
        Position position2 = this.absolutePositionToScreenPosition(end);
        int i = Math.min(position.x, position2.x);
        int j = Math.max(position.x, position2.x);
        int k = Math.min(position.y, position2.y);
        int l = Math.max(position.y, position2.y);
        return new class_768(i, k, j - i, l - k);
    }

    @Environment(value=EnvType.CLIENT)
    static class PageContent {
        static final PageContent EMPTY = new PageContent("", new Position(0, 0), true, new int[]{0}, new Line[]{new Line(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        private final String pageContent;
        final Position position;
        final boolean atEnd;
        private final int[] lineStarts;
        final Line[] lines;
        final class_768[] selectionRectangles;

        public PageContent(String pageContent, Position position, boolean atEnd, int[] lineStarts, Line[] lines, class_768[] selectionRectangles) {
            this.pageContent = pageContent;
            this.position = position;
            this.atEnd = atEnd;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selectionRectangles = selectionRectangles;
        }

        public int getCursorPosition(class_327 renderer, Position position) {
            int var10000 = position.y;
            Objects.requireNonNull(renderer);
            int i = var10000 / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.pageContent.length();
            }
            Line line = this.lines[i];
            return this.lineStarts[i] + renderer.method_27527().method_27484(line.content, position.x, line.style);
        }

        public int getVerticalOffset(int position, int lines) {
            int m;
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            int j = i + lines;
            if (0 <= j && j < this.lineStarts.length) {
                int k = position - this.lineStarts[i];
                int l = this.lines[j].content.length();
                m = this.lineStarts[j] + Math.min(k, l);
            } else {
                m = position;
            }
            return m;
        }

        public int getLineStart(int position) {
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i];
        }

        public int getLineEnd(int position) {
            int i = NotePaperGui.getLineFromOffset(this.lineStarts, position);
            return this.lineStarts[i] + this.lines[i].content.length();
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Line {
        final class_2583 style;
        final String content;
        final class_2561 text;
        final int x;
        final int y;

        public Line(class_2583 style, String content, int x, int y) {
            this.style = style;
            this.content = content;
            this.x = x;
            this.y = y;
            this.text = class_2561.method_43470((String)content).method_10862(style);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Position(int x, int y) {
    }
}

