/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.nethervinery.block.entity;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import satisfyu.nethervinery.client.gui.handler.AgingBarrelGuiHandler;
import satisfyu.nethervinery.registry.NetherBlockEntityTypes;
import satisfyu.vinery.registry.ObjectRegistry;
import satisfyu.vinery.registry.VineryRecipeTypes;
import satisfyu.vinery.util.WineYears;

public class AgingBarrelBlockEntity
extends class_2586
implements class_1263,
class_5558<AgingBarrelBlockEntity>,
class_3908 {
    private class_2371<class_1799> inventory;
    public static final int CAPACITY = 6;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int BOTTLE_INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 5;
    private int fermentationTime = 0;
    private int totalFermentationTime;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> AgingBarrelBlockEntity.this.fermentationTime;
                case 1 -> AgingBarrelBlockEntity.this.totalFermentationTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AgingBarrelBlockEntity.this.fermentationTime = value;
                    break;
                }
                case 1: {
                    AgingBarrelBlockEntity.this.totalFermentationTime = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public AgingBarrelBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)NetherBlockEntityTypes.AGING_BARREL_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.fermentationTime = nbt.method_10568("FermentationTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10575("FermentationTime", (short)this.fermentationTime);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, AgingBarrelBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        boolean dirty = false;
        class_1860 recipe = world.method_8433().method_8132((class_3956)VineryRecipeTypes.FERMENTATION_BARREL_RECIPE_TYPE.get(), (class_1263)this, world).orElse(null);
        if (this.canCraft(recipe)) {
            ++this.fermentationTime;
            if (this.fermentationTime >= this.totalFermentationTime) {
                this.fermentationTime = 0;
                this.craft(recipe);
                dirty = true;
            }
        } else {
            this.fermentationTime = 0;
        }
        if (dirty) {
            this.method_5431();
        }
    }

    private boolean canCraft(class_1860<?> recipe) {
        if (recipe == null || recipe.method_8110().method_7960()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        if (this.method_5438(0).method_7960()) {
            return false;
        }
        class_1792 item = this.method_5438(0).method_7909();
        if (item != ((class_1792)ObjectRegistry.WINE_BOTTLE.get()).method_8389()) {
            return false;
        }
        return this.method_5438(5).method_7960();
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i < 5; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 4;
    }

    private void craft(class_1860<?> recipe) {
        class_1799 bottle;
        if (!this.canCraft(recipe)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110();
        class_1799 outputSlotStack = this.method_5438(5);
        if (outputSlotStack.method_7960()) {
            class_1799 output = recipeOutput.method_7972();
            WineYears.setWineYear((class_1799)output, (class_1937)this.field_11863);
            this.method_5447(5, output);
        }
        if ((bottle = this.method_5438(0)).method_7947() > 1) {
            this.method_5434(0, 1);
        } else if (bottle.method_7947() == 1) {
            this.method_5447(0, class_1799.field_8037);
        }
        for (class_1856 entry : recipe.method_8117()) {
            if (entry.method_8093(this.method_5438(1))) {
                this.method_5434(1, 1);
            }
            if (entry.method_8093(this.method_5438(2))) {
                this.method_5434(2, 1);
            }
            if (entry.method_8093(this.method_5438(3))) {
                this.method_5434(3, 1);
            }
            if (!entry.method_8093(this.method_5438(4))) continue;
            this.method_5434(4, 1);
        }
    }

    public int method_5439() {
        return 6;
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.inventory, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.inventory, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && stack.method_7962(stackInSlot) && class_1799.method_7975((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!(slot != 0 && slot != 2 && slot != 3 && slot != 4 && slot != 5 || dirty)) {
            this.totalFermentationTime = 50;
            this.fermentationTime = 0;
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AgingBarrelGuiHandler(syncId, inv, this, this.propertyDelegate);
    }
}

