/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight.doapi.config.jankson.config.CommentedConfig;
import java.util.HashMap;
import net.minecraft.class_156;

public record VineryConfig(int wineTraderChance, int yearLengthInDays, int yearsPerEffectLevel, boolean enableWineMakerSetBonus, int damagePerUse, int probabilityForDamage, int probabilityToKeepBoneMeal) implements CommentedConfig<VineryConfig>
{
    private static VineryConfig INSTANCE = null;
    public static final VineryConfig DEFAULT = new VineryConfig(50, 16, 4, true, 1, 30, 100);
    public static final Codec<VineryConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.intRange((int)0, (int)100).fieldOf("wine_trader_chance").orElse((Object)VineryConfig.DEFAULT.wineTraderChance).forGetter(c -> c.wineTraderChance), (App)Codec.intRange((int)1, (int)100).fieldOf("year_length_in_days").orElse((Object)VineryConfig.DEFAULT.yearLengthInDays).forGetter(c -> c.yearLengthInDays), (App)Codec.intRange((int)1, (int)100).fieldOf("years_per_effect_level").orElse((Object)VineryConfig.DEFAULT.yearsPerEffectLevel).forGetter(c -> c.yearsPerEffectLevel), (App)Codec.BOOL.fieldOf("enable_wine_maker_set_bonus").orElse((Object)VineryConfig.DEFAULT.enableWineMakerSetBonus).forGetter(c -> c.enableWineMakerSetBonus), (App)Codec.intRange((int)1, (int)100).fieldOf("damage_per_use").orElse((Object)VineryConfig.DEFAULT.damagePerUse).forGetter(c -> c.damagePerUse), (App)Codec.intRange((int)0, (int)100).fieldOf("probability_for_damage").orElse((Object)VineryConfig.DEFAULT.probabilityForDamage).forGetter(c -> c.probabilityForDamage), (App)Codec.intRange((int)1, (int)100).fieldOf("probability_to_keep_bone_meal").orElse((Object)VineryConfig.DEFAULT.probabilityToKeepBoneMeal).forGetter(c -> c.probabilityToKeepBoneMeal)).apply((Applicative)builder, VineryConfig::new));

    public HashMap<String, String> getComments() {
        return (HashMap)class_156.method_654(new HashMap(), map -> {
            map.put("enable_wine_maker_set_bonus", "Whether the winemaker armor should give a set bonus, which can prevent your bone meal of being used");
            map.put("probability_to_keep_bone_meal", "Probability for the set bonus to work (in %)");
            map.put("probability_for_damage", "Probability for damaging armor on using the set bonus (in %)");
            map.put("damage_per_use", "Amount of damage when the armor gets damaged because of the set bonus");
            map.put("wine_trader_chance", "How many % of the normal wandering traders should be a wandering wine trader?");
            map.put("year_length_in_days", "Length of a year (in days).");
            map.put("years_per_effect_level", "Years per effect level");
        });
    }

    public String getHeader() {
        return "Vinery Config\n\n===========\nDiscord: https://discord.gg/Vqu6wYZwdZ\nModrinth: https://modrinth.com/mod/vinery\nCurseForge: https://www.curseforge.com/minecraft/mc-mods/lets-do-wine";
    }

    public String getSubPath() {
        return "vinery/config";
    }

    public VineryConfig getInstance() {
        return INSTANCE;
    }

    public VineryConfig getDefault() {
        return DEFAULT;
    }

    public Codec<VineryConfig> getCodec() {
        return CODEC;
    }

    public boolean isSorted() {
        return false;
    }

    public void setInstance(VineryConfig instance) {
        INSTANCE = instance;
    }
}

