/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.mixin;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import satisfyu.vinery.registry.VineryEffects;
import satisfyu.vinery.util.VineryFoodComponent;
import satisfyu.vinery.util.WineYears;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Final
    @Shadow
    private final Map<class_1291, class_1293> field_6280 = Maps.newHashMap();

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public boolean hasStatusEffect(class_1291 effect) {
        return this.field_6280.containsKey(effect);
    }

    @Inject(method={"addEatEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyFoodEffects(class_1799 stack, class_1937 world, class_1309 targetEntity, CallbackInfo ci) {
        if (stack.method_19267() && stack.method_7909().method_19264() instanceof VineryFoodComponent) {
            ci.cancel();
            class_1792 item = stack.method_7909();
            if (item.method_19263()) {
                List list = item.method_19264().method_19235();
                for (Pair pair : list) {
                    if (world.field_9236 || pair.getFirst() == null || !(world.field_9229.method_43057() < ((Float)pair.getSecond()).floatValue())) continue;
                    class_1293 statusEffectInstance = new class_1293((class_1293)pair.getFirst());
                    statusEffectInstance.field_5893 = WineYears.getEffectLevel(stack, world);
                    if (statusEffectInstance.method_5579().equals(class_1294.field_5915) || statusEffectInstance.method_5579().equals(class_1294.field_5921)) {
                        statusEffectInstance.field_5895 = 1;
                    }
                    targetEntity.method_6092(statusEffectInstance);
                }
            }
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="TAIL")}, cancellable=true)
    private void canWalkOnWater(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        if (!(state.method_15772() != class_3612.field_15910 || this.method_5869() || this.method_5681() || this.method_20232())) {
            cir.setReturnValue((Object)this.hasStatusEffect((class_1291)VineryEffects.IMPROVED_SPEED.get()));
        }
    }

    @Inject(method={"setLastHurtMob"}, at={@At(value="HEAD")})
    private void setTargetOnFire(class_1297 target, CallbackInfo ci) {
        if (target instanceof class_1309) {
            class_1309 targetEntity = (class_1309)target;
            if (this.hasStatusEffect((class_1291)VineryEffects.IMPROVED_FIRE_RESISTANCE.get())) {
                targetEntity.method_5639(5);
            }
        }
    }

    @Redirect(method={"calculateFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getEffect(Lnet/minecraft/world/effect/MobEffect;)Lnet/minecraft/world/effect/MobEffectInstance;"))
    public class_1293 improvedJumpBoostFall(class_1309 livingEntity, class_1291 effect) {
        return livingEntity.method_6059((class_1291)VineryEffects.IMPROVED_JUMP_BOOST.get()) ? livingEntity.method_6112((class_1291)VineryEffects.IMPROVED_JUMP_BOOST.get()) : livingEntity.method_6112(class_1294.field_5913);
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="HEAD")}, cancellable=true)
    private void improvedJumpBoost(CallbackInfoReturnable<Double> cir) {
        if (this.hasStatusEffect((class_1291)VineryEffects.IMPROVED_JUMP_BOOST.get())) {
            cir.setReturnValue((Object)(0.1f * (float)(this.field_6280.get(VineryEffects.IMPROVED_JUMP_BOOST.get()).method_5578() + 1)));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasImprovedFireResistance(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_5534() && this.hasStatusEffect((class_1291)VineryEffects.IMPROVED_FIRE_RESISTANCE.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal=1), ordinal=0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        class_1309 entity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1309 && (entity = (class_1309)livingEntityMixin).method_6059((class_1291)VineryEffects.IMPROVED_WATER_BREATHING.get())) {
            return 0.96f;
        }
        return j;
    }

    @Redirect(method={"updateInvisibilityStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z"))
    public boolean improvedNightVision(class_1309 livingEntity, class_1291 effect) {
        return livingEntity.method_6059(class_1294.field_5905) || livingEntity.method_6059((class_1291)VineryEffects.IMPROVED_NIGHT_VISION.get());
    }
}

