/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.numismaticoverhaul;

import com.glisco.numismaticoverhaul.ModComponents;
import com.glisco.numismaticoverhaul.currency.Currency;
import com.glisco.numismaticoverhaul.currency.CurrencyComponent;
import com.glisco.numismaticoverhaul.currency.CurrencyConverter;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.owo.offline.OfflineDataLookup;
import io.wispforest.owo.ops.TextOps;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7157;

public class NumismaticCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"numismatic").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"get").executes(NumismaticCommand::get))).then(NumismaticCommand.longSubcommand("set", "value", (Command<class_2168>)((Command)NumismaticCommand::set)))).then(NumismaticCommand.longSubcommand("add", "amount", NumismaticCommand.modify(1L)))).then(NumismaticCommand.longSubcommand("subtract", "amount", NumismaticCommand.modify(-1L)))))).then(class_2170.method_9247((String)"serverworth").executes(NumismaticCommand::serverWorth)));
    }

    private static LiteralArgumentBuilder<class_2168> longSubcommand(String name, String argName, Command<class_2168> command) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(class_2170.method_9244((String)argName, (ArgumentType)LongArgumentType.longArg((long)0L)).executes(command));
    }

    private static int serverWorth(CommandContext<class_2168> context) {
        class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
        List<UUID> onlineUUIDs = playerManager.method_14571().stream().map(class_1297::method_5667).toList();
        List<UUID> offlineUUIDs = OfflineDataLookup.savedPlayers().stream().filter(uuid -> !onlineUUIDs.contains(uuid)).toList();
        long serverWorth = 0L;
        for (UUID onlineId : onlineUUIDs) {
            serverWorth += ((CurrencyComponent)ModComponents.CURRENCY.get((Object)playerManager.method_14602(onlineId))).getValue();
        }
        for (UUID offlineId : offlineUUIDs) {
            serverWorth += OfflineDataLookup.get((UUID)offlineId).method_10562("cardinal_components").method_10562("numismatic-overhaul:currency").method_10537("Value");
        }
        ((class_2168)context.getSource()).method_9226((class_2561)TextOps.withColor((String)("numismatic \u00a7> server net worth: " + serverWorth), (int[])new int[]{Currency.GOLD.getNameColor(), TextOps.color((class_124)class_124.field_1080)}), false);
        return (int)serverWorth;
    }

    private static int set(CommandContext<class_2168> context) throws CommandSyntaxException {
        long value = LongArgumentType.getLong(context, (String)"value");
        Collection players = class_2186.method_9312(context, (String)"player");
        for (class_3222 player : players) {
            ((CurrencyComponent)ModComponents.CURRENCY.get((Object)player)).setValue(value);
            ((class_2168)context.getSource()).method_9226((class_2561)TextOps.withColor((String)("numismatic \u00a7> balance of " + player.method_5820() + " set to: " + value), (int[])new int[]{Currency.GOLD.getNameColor(), TextOps.color((class_124)class_124.field_1080)}), false);
        }
        return CurrencyConverter.asInt(value);
    }

    private static int get(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"player");
        long totalBalance = 0L;
        for (class_3222 player : players) {
            long balance = ((CurrencyComponent)ModComponents.CURRENCY.get((Object)player)).getValue();
            totalBalance += balance;
            ((class_2168)context.getSource()).method_9226((class_2561)TextOps.withColor((String)("numismatic \u00a7> balance of " + player.method_5820() + ":"), (int[])new int[]{Currency.GOLD.getNameColor(), TextOps.color((class_124)class_124.field_1080)}), false);
        }
        return CurrencyConverter.asInt(totalBalance);
    }

    private static Command<class_2168> modify(long multiplier) {
        return context -> {
            long amount = LongArgumentType.getLong((CommandContext)context, (String)"amount");
            Collection players = class_2186.method_9312((CommandContext)context, (String)"player");
            long lastValue = 0L;
            for (class_3222 player : players) {
                CurrencyComponent currencyComponent = (CurrencyComponent)ModComponents.CURRENCY.get((Object)player);
                currencyComponent.silentModify(amount * multiplier);
                lastValue = currencyComponent.getValue();
                ((class_2168)context.getSource()).method_9226((class_2561)TextOps.withColor((String)("numismatic \u00a7> balance of " + player.method_5820() + " set to: " + currencyComponent.getValue()), (int[])new int[]{Currency.GOLD.getNameColor(), TextOps.color((class_124)class_124.field_1080)}), false);
            }
            return CurrencyConverter.asInt(lastValue);
        };
    }
}

