/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.part;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.PartLootParams;
import alexiil.mc.lib.multipart.api.event.NeighbourUpdateEvent;
import alexiil.mc.lib.multipart.api.event.PartAddedEvent;
import alexiil.mc.lib.multipart.api.event.PartContainerState;
import alexiil.mc.lib.multipart.api.event.PartRemovedEvent;
import alexiil.mc.lib.multipart.api.event.PartTickEvent;
import alexiil.mc.lib.net.NetIdTyped;
import com.kneelawk.graphlib.GraphLib;
import com.kneelawk.wiredredstone.part.BlockNodeContainer;
import com.kneelawk.wiredredstone.part.WRPart;
import com.kneelawk.wiredredstone.part.event.WRPartPreMoveEvent;
import com.kneelawk.wiredredstone.util.PartExtensionsKt;
import com.kneelawk.wiredredstone.util.SimpleItemDropTarget;
import com.kneelawk.wiredredstone.util.connectable.ConnectableUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B!\b\u0016\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010(\u001a\u00020'\u0012\u0006\u0010)\u001a\u00020\u0013\u00a2\u0006\u0004\b*\u0010+B\u0017\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b*\u0010,J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\r\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\rJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0016H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u00020\u00108\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001bR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/kneelawk/wiredredstone/part/AbstractWRPart;", "Lalexiil/mc/lib/multipart/api/AbstractPart;", "Lcom/kneelawk/wiredredstone/part/BlockNodeContainer;", "Lcom/kneelawk/wiredredstone/part/WRPart;", "Lnet/minecraft/class_2338;", "getPos", "()Lnet/minecraft/class_2338;", "Lalexiil/mc/lib/multipart/api/MultipartEventBus;", "bus", "", "onAdded", "(Lalexiil/mc/lib/multipart/api/MultipartEventBus;)V", "onFirstTick", "()V", "onRemoved", "removeAndDrop", "", "shouldBreak", "()Z", "Lnet/minecraft/class_2487;", "toTag", "()Lnet/minecraft/class_2487;", "Lnet/minecraft/class_3218;", "world", "updateConnections", "(Lnet/minecraft/class_3218;)V", "initialized", "Z", "getInitialized", "setInitialized", "(Z)V", "noBreak", "", "Lnet/minecraft/class_265;", "shapeCache", "Ljava/util/Map;", "unloading", "Lalexiil/mc/lib/multipart/api/PartDefinition;", "definition", "Lalexiil/mc/lib/multipart/api/MultipartHolder;", "holder", "tag", "<init>", "(Lalexiil/mc/lib/multipart/api/PartDefinition;Lalexiil/mc/lib/multipart/api/MultipartHolder;Lnet/minecraft/class_2487;)V", "(Lalexiil/mc/lib/multipart/api/PartDefinition;Lalexiil/mc/lib/multipart/api/MultipartHolder;)V", "wired-redstone"})
@SourceDebugExtension(value={"SMAP\nAbstractWRPart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractWRPart.kt\ncom/kneelawk/wiredredstone/part/AbstractWRPart\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,168:1\n26#2:169\n*S KotlinDebug\n*F\n+ 1 AbstractWRPart.kt\ncom/kneelawk/wiredredstone/part/AbstractWRPart\n*L\n141#1:169\n*E\n"})
public abstract class AbstractWRPart
extends AbstractPart
implements BlockNodeContainer,
WRPart {
    @NotNull
    private final Map<class_2338, class_265> shapeCache;
    private boolean initialized;
    private boolean noBreak;
    private boolean unloading;

    public AbstractWRPart(@NotNull PartDefinition definition, @NotNull MultipartHolder holder) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(definition, holder);
        this.shapeCache = new LinkedHashMap();
    }

    protected final boolean getInitialized() {
        return this.initialized;
    }

    protected final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public AbstractWRPart(@NotNull PartDefinition definition, @NotNull MultipartHolder holder, @NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this(definition, holder);
        this.noBreak = tag.method_10577("noBreak");
    }

    @NotNull
    public class_2487 toTag() {
        class_2487 tag = super.toTag();
        if (this.noBreak) {
            tag.method_10556("noBreak", true);
        }
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        return tag;
    }

    public void onAdded(@NotNull MultipartEventBus bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        super.onAdded(bus);
        if (PartExtensionsKt.getWorld((AbstractPart)((AbstractPart)this)).field_9236) {
            return;
        }
        bus.addRunOnceListener((Object)this, PartTickEvent.class, () -> AbstractWRPart.onAdded$lambda$0(this));
        bus.addListener((Object)this, WRPartPreMoveEvent.class, arg_0 -> AbstractWRPart.onAdded$lambda$1(this, arg_0));
        bus.addListener((Object)this, NeighbourUpdateEvent.class, arg_0 -> AbstractWRPart.onAdded$lambda$2(this, arg_0));
        bus.addListener((Object)this, PartAddedEvent.class, arg_0 -> AbstractWRPart.onAdded$lambda$3(this, arg_0));
        bus.addListener((Object)this, PartRemovedEvent.class, arg_0 -> AbstractWRPart.onAdded$lambda$4(this, arg_0));
        bus.addContextlessListener((Object)this, PartContainerState.ChunkUnload.class, () -> AbstractWRPart.onAdded$lambda$5(this));
        bus.addContextlessListener((Object)this, PartContainerState.Invalidate.class, () -> AbstractWRPart.onAdded$lambda$6(this));
    }

    protected void onFirstTick() {
        class_1937 world = PartExtensionsKt.getWorld(this);
        if (world instanceof class_3218) {
            this.noBreak = false;
            this.initialized = true;
            if (this.shouldBreak()) {
                this.removeAndDrop();
            } else {
                GraphLib.getController((class_3218)((class_3218)world)).updateNodes(this.getPos());
            }
        }
    }

    protected boolean shouldBreak() {
        return false;
    }

    public final void removeAndDrop() {
        class_1937 class_19372 = PartExtensionsKt.getWorld(this);
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return;
        }
        class_3218 world = class_32182;
        class_2338 pos = this.getPos();
        class_2680 state = world.method_8320(pos);
        class_243 origin = class_243.method_24954((class_2382)((class_2382)pos)).method_1019(this.getShape().method_1107().method_1005());
        this.playBreakSound();
        this.sendNetworkUpdate(this, (NetIdTyped)AbstractPart.NET_SPAWN_BREAK_PARTICLES);
        boolean $i$f$emptyArray = false;
        class_47 context = new class_47.class_48(world).method_311(world.field_9229).method_312(class_181.field_1224, (Object)state).method_312(class_181.field_24424, (Object)origin).method_312(class_181.field_1229, (Object)class_1799.field_8037).method_312(PartLootParams.BROKEN_PART, (Object)new PartLootParams.BrokenSinglePart((AbstractPart)this)).method_312(PartLootParams.ADDITIONAL_PARTS, (Object)new PartLootParams.BrokenPart[0]).method_306(class_181.field_1228, (Object)this.holder.getContainer().getMultipartBlockEntity()).method_309(PartLootParams.PART_TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)origin, (String)"origin");
        this.addDrops(new SimpleItemDropTarget(world, origin), context);
        this.holder.remove();
    }

    protected void updateConnections(@NotNull class_3218 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        GraphLib.getController((class_3218)world).updateConnections(this.getPos());
    }

    public void onRemoved() {
        if (PartExtensionsKt.getWorld((AbstractPart)((AbstractPart)this)).field_9236) {
            return;
        }
        class_1937 world = PartExtensionsKt.getWorld(this);
        if (!world.field_9236 && world instanceof class_3218) {
            GraphLib.getController((class_3218)((class_3218)world)).updateNodes(this.getPos());
        }
    }

    @Override
    @NotNull
    public class_2338 getPos() {
        class_2338 class_23382 = this.holder.getContainer().getMultipartPos();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"holder.container.multipartPos");
        return class_23382;
    }

    private static final void onAdded$lambda$0(AbstractWRPart this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onFirstTick();
    }

    private static final void onAdded$lambda$1(AbstractWRPart this$0, WRPartPreMoveEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setMovementNecessary();
        this$0.noBreak = true;
    }

    private static final void onAdded$lambda$2(AbstractWRPart this$0, NeighbourUpdateEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1937 world = PartExtensionsKt.getWorld(this$0);
        if (world instanceof class_3218) {
            if (!this$0.noBreak && this$0.shouldBreak()) {
                this$0.removeAndDrop();
            } else {
                Map<class_2338, class_265> map = this$0.shapeCache;
                class_3218 class_32182 = (class_3218)world;
                class_2338 class_23382 = this$0.getPos();
                class_2338 class_23383 = it.pos;
                Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"it.pos");
                if (ConnectableUtils.INSTANCE.shouldUpdateConnectionsForNeighborUpdate(map, class_32182, class_23382, class_23383) && this$0.initialized) {
                    this$0.updateConnections((class_3218)world);
                }
            }
        }
    }

    private static final void onAdded$lambda$3(AbstractWRPart this$0, PartAddedEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1937 world = PartExtensionsKt.getWorld(this$0);
        if (it.part != this$0 && world instanceof class_3218) {
            this$0.updateConnections((class_3218)world);
        }
    }

    private static final void onAdded$lambda$4(AbstractWRPart this$0, PartRemovedEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_1937 world = PartExtensionsKt.getWorld(this$0);
        if (it.removed != this$0 && world instanceof class_3218) {
            this$0.updateConnections((class_3218)world);
        }
    }

    private static final void onAdded$lambda$5(AbstractWRPart this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.unloading = true;
    }

    private static final void onAdded$lambda$6(AbstractWRPart this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.unloading) {
            this$0.onRemoved();
        }
    }
}

