/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.builders;

import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.Config;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.ConfigEnvironment;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.Serializer;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.exceptions.ConfigParseException;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.metadata.MetadataType;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.api.values.TrackedValue;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.ConfigImpl;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.builders.SectionBuilderImpl;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.tree.TrackedValueImpl;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.tree.Trie;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.util.ConfigsImpl;
import com.kneelawk.wiredredstone.shadowlibs.org.quiltmc.config.impl.values.ValueKeyImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class ConfigBuilderImpl
implements Config.Builder {
    private final ConfigEnvironment environment;
    private final String familyId;
    private final String id;
    private final Path path;
    private final Map<MetadataType<?, ?>, MetadataType.Builder<?>> metadata = new LinkedHashMap();
    private final List<Config.UpdateCallback> callbacks = new ArrayList<Config.UpdateCallback>();
    final Trie values = new Trie();
    private String format;

    public ConfigBuilderImpl(ConfigEnvironment environment, String familyId, String id2, Path path) {
        this.environment = environment;
        this.familyId = familyId;
        this.id = id2;
        this.path = path;
        this.format = environment.getDefaultFormat();
    }

    @Override
    public Config.Builder field(TrackedValue<?> value) {
        this.values.put((Iterable<String>)value.key(), value);
        return this;
    }

    @Override
    public Config.Builder section(String key, Consumer<Config.SectionBuilder> creator2) {
        ValueKeyImpl valueKey = new ValueKeyImpl(key, new String[0]);
        SectionBuilderImpl sectionBuilder = new SectionBuilderImpl(valueKey, this);
        creator2.accept(sectionBuilder);
        this.values.put((Iterable<String>)valueKey, sectionBuilder);
        return this;
    }

    @Override
    public <M, B extends MetadataType.Builder<M>> Config.Builder metadata(MetadataType<M, B> type, Consumer<B> builderConsumer) {
        builderConsumer.accept(this.metadata.computeIfAbsent(type, t -> type.newBuilder()));
        return this;
    }

    @Override
    public Config.Builder callback(Config.UpdateCallback callback) {
        this.callbacks.add(callback);
        return this;
    }

    @Override
    public Config.Builder format(String format) {
        this.format = format;
        return this;
    }

    public ConfigImpl build() {
        LinkedHashMap metadata = new LinkedHashMap();
        for (Map.Entry<MetadataType<?, ?>, MetadataType.Builder<?>> entry : this.metadata.entrySet()) {
            metadata.put(entry.getKey(), entry.getValue().build());
        }
        ConfigImpl config = new ConfigImpl(this.environment, this.id, this.path, metadata, this.familyId, this.callbacks, this.values, this.format);
        ConfigsImpl.put(this.familyId, config);
        for (TrackedValue<?> value : config.values()) {
            ((TrackedValueImpl)value).setConfig(config);
        }
        ConfigBuilderImpl.doInitialSerialization(config);
        return config;
    }

    public static void doInitialSerialization(ConfigImpl config) {
        ConfigEnvironment environment = config.getEnvironment();
        Serializer defaultSerializer = environment.getActualSerializer(config.getDefaultFileType());
        Serializer serializer = environment.getSerializer(config.getDefaultFileType());
        Path directory = environment.getSaveDir().resolve(config.family()).resolve(config.savePath());
        Path defaultPath = directory.resolve(config.id() + "." + defaultSerializer.getFileExtension());
        Path path = directory.resolve(config.id() + "." + serializer.getFileExtension());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if ((defaultSerializer == serializer || !Files.exists(defaultPath, new LinkOption[0])) && Files.exists(path, new LinkOption[0])) {
                serializer.deserialize(config, Files.newInputStream(path, new OpenOption[0]));
            } else if (Files.exists(defaultPath, new LinkOption[0])) {
                defaultSerializer.deserialize(config, Files.newInputStream(defaultPath, new OpenOption[0]));
                try {
                    Files.delete(defaultPath);
                }
                catch (IOException e) {
                    throw new ConfigParseException(e);
                }
            }
            serializer.serialize(config, Files.newOutputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new ConfigParseException(e);
        }
    }
}

