/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.entity;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.world.NbtValued;
import com.sk89q.worldedit.world.entity.EntityType;
import javax.annotation.Nullable;

public class BaseEntity
implements NbtValued {
    private final EntityType type;
    private CompoundTag nbtData;

    public BaseEntity(EntityType type, CompoundTag nbtData) {
        this(type);
        this.setNbtData(nbtData);
    }

    public BaseEntity(EntityType type) {
        this.type = type;
    }

    public BaseEntity(BaseEntity other) {
        Preconditions.checkNotNull((Object)other);
        this.type = other.getType();
        this.setNbtData(other.getNbtData());
    }

    @Override
    public boolean hasNbtData() {
        return this.nbtData != null;
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        this.nbtData = nbtData;
    }

    public EntityType getType() {
        return this.type;
    }
}

