/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.Futures;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.forge.WorldEditGenListener;
import com.sk89q.worldedit.forge.internal.ForgeWorldNativeAccess;
import com.sk89q.worldedit.forge.internal.NBTConverter;
import com.sk89q.worldedit.forge.internal.TileEntityUtils;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class ForgeWorld
extends AbstractWorld {
    private static final RandomSource random = RandomSource.m_216327_();
    private final WeakReference<ServerLevel> worldRef;
    private final ForgeWorldNativeAccess nativeAccess;
    private static final LoadingCache<ServerLevel, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    private static ResourceLocation getDimensionRegistryKey(ServerLevel world) {
        return Objects.requireNonNull(world.m_7654_(), "server cannot be null").m_206579_().m_175515_(Registry.f_122818_).m_7981_((Object)world.m_6042_());
    }

    ForgeWorld(ServerLevel world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<ServerLevel>(world);
        this.nativeAccess = new ForgeWorldNativeAccess(this.worldRef);
    }

    public ServerLevel getWorld() {
        ServerLevel world = (ServerLevel)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return ((ServerLevelData)this.getWorld().m_6106_()).m_5462_();
    }

    @Override
    public String getId() {
        return this.getName() + "_" + ForgeWorld.getDimensionRegistryKey(this.getWorld());
    }

    @Override
    public Path getStoragePath() {
        ServerLevel world = this.getWorld();
        return world.m_7654_().f_129744_.m_197394_(world.m_46472_());
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) throws WorldEditException {
        this.clearContainerBlockContents(position);
        return this.nativeAccess.setBlock(position, block, sideEffects);
    }

    @Override
    public Set<SideEffect> applySideEffects(BlockVector3 position, BlockState previousType, SideEffectSet sideEffectSet) {
        this.nativeAccess.applySideEffects(position, previousType, sideEffectSet);
        return Sets.intersection(ForgeWorldEdit.inst.getPlatform().getSupportedSideEffects(), sideEffectSet.getSideEffectsToApply());
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().m_7146_(ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        BlockEntity tile = this.getWorld().m_7702_(ForgeAdapter.toBlockPos(position));
        if (tile instanceof Clearable) {
            ((Clearable)tile).m_6211_();
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        LevelChunk chunk = this.getWorld().m_6325_(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        return this.getBiomeInChunk(position, (ChunkAccess)chunk);
    }

    private BiomeType getBiomeInChunk(BlockVector3 position, ChunkAccess chunk) {
        return ForgeAdapter.adapt((Biome)chunk.m_203495_(position.getX() >> 2, position.getY() >> 2, position.getZ() >> 2).m_203334_());
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        LevelChunk chunk = this.getWorld().m_6325_(position.getBlockX() >> 4, position.getBlockZ() >> 4);
        PalettedContainer biomes = (PalettedContainer)chunk.m_183278_(chunk.m_151564_(position.getY())).m_187996_();
        biomes.m_63127_(position.getX() & 3, position.getY() & 3, position.getZ() & 3, (Object)((Registry)this.getWorld().m_5962_().m_6632_(Registry.f_122885_).orElseThrow()).m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(biome.getId()))));
        chunk.m_8092_(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        ItemStack stack = ForgeAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        ServerLevel world = this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, stack);
        fakePlayer.m_19890_(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPos blockPos = ForgeAdapter.toBlockPos(position);
        BlockHitResult rayTraceResult = new BlockHitResult(ForgeAdapter.toVec3(position), ForgeAdapter.adapt(face), blockPos, false);
        UseOnContext itemUseContext = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, rayTraceResult);
        InteractionResult used = stack.onItemUseFirst(itemUseContext);
        if (used != InteractionResult.SUCCESS) {
            InteractionResult resultType = this.getWorld().m_8055_(blockPos).m_60664_((Level)world, (Player)fakePlayer, InteractionHand.MAIN_HAND, rayTraceResult);
            used = resultType.m_19077_() ? resultType : stack.m_41720_().m_7203_((Level)world, (Player)fakePlayer, InteractionHand.MAIN_HAND).m_19089_();
        }
        return used == InteractionResult.SUCCESS;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        ItemEntity entity = new ItemEntity((Level)this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeAdapter.adapt(item));
        entity.m_32010_(10);
        this.getWorld().m_7967_((net.minecraft.world.entity.Entity)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        BlockPos pos = ForgeAdapter.toBlockPos(position);
        this.getWorld().m_46961_(pos, true);
    }

    @Override
    public boolean canPlaceAt(BlockVector3 position, BlockState blockState) {
        return ForgeAdapter.adapt(blockState).m_60710_((LevelReader)this.getWorld(), ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean regenerate(Region region, Extent extent, RegenOptions options) {
        try {
            this.doRegen(region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(Region region, Extent extent, RegenOptions options) throws Exception {
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        LevelStorageSource levelStorage = LevelStorageSource.m_78242_((Path)tempDir);
        try (LevelStorageSource.LevelStorageAccess session = levelStorage.m_78260_("WorldEditTempGen");){
            WorldGenSettings newOpts;
            ServerLevel originalWorld = this.getWorld();
            PrimaryLevelData levelProperties = (PrimaryLevelData)originalWorld.m_7654_().m_129910_().m_5996_();
            WorldGenSettings originalOpts = levelProperties.m_5961_();
            long seed = options.getSeed().orElse(originalWorld.m_7328_());
            levelProperties.f_78444_ = newOpts = options.getSeed().isPresent() ? originalOpts.m_64654_(levelProperties.m_5466_(), OptionalLong.of(seed)) : originalOpts;
            ResourceKey worldRegKey = originalWorld.m_46472_();
            LevelStem dimGenOpts = (LevelStem)newOpts.m_204655_().m_7745_(worldRegKey.m_135782_());
            Preconditions.checkNotNull((Object)dimGenOpts, (String)"No DimensionOptions for %s", (Object)worldRegKey);
            try (ServerLevel serverWorld = new ServerLevel(originalWorld.m_7654_(), (Executor)Util.m_183991_(), session, (ServerLevelData)originalWorld.m_6106_(), worldRegKey, new LevelStem(originalWorld.m_204156_(), dimGenOpts.m_63990_()), (ChunkProgressListener)new WorldEditGenListener(), originalWorld.m_46659_(), seed, (List)ImmutableList.of(), false);){
                this.regenForWorld(region, extent, serverWorld, options);
                while (originalWorld.m_7654_().m_7245_()) {
                    Thread.yield();
                }
            }
            finally {
                levelProperties.f_78444_ = originalOpts;
            }
        }
        finally {
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private void regenForWorld(Region region, Extent extent, ServerLevel serverWorld, RegenOptions options) throws WorldEditException {
        List<CompletableFuture<ChunkAccess>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        ServerChunkCache.MainThreadExecutor executor = serverWorld.m_7726_().f_8332_;
        executor.m_18701_(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<ChunkPos, ChunkAccess> chunks = new HashMap<ChunkPos, ChunkAccess>();
        for (CompletableFuture<ChunkAccess> future : chunkLoadings) {
            ChunkAccess chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.m_7697_(), chunk);
        }
        for (BlockVector3 vec : region) {
            BlockPos pos = ForgeAdapter.toBlockPos(vec);
            ChunkAccess chunk = (ChunkAccess)chunks.get(new ChunkPos(pos));
            BlockStateHolder<BlockState> state = ForgeAdapter.adapt(chunk.m_8055_(pos));
            BlockEntity blockEntity = chunk.m_7702_(pos);
            if (blockEntity != null) {
                state = state.toBaseBlock(NBTConverter.fromNative(blockEntity.m_187480_()));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes()) continue;
            BiomeType biome = this.getBiomeInChunk(vec, chunk);
            extent.setBiome(vec, biome);
        }
    }

    private List<CompletableFuture<ChunkAccess>> submitChunkLoadTasks(Region region, ServerLevel world) {
        ArrayList<CompletableFuture<ChunkAccess>> chunkLoadings = new ArrayList<CompletableFuture<ChunkAccess>>();
        for (BlockVector2 chunk : region.getChunks()) {
            chunkLoadings.add((CompletableFuture<ChunkAccess>)world.m_7726_().m_8456_(chunk.getX(), chunk.getZ(), ChunkStatus.f_62322_, true).thenApply(either -> either.left().orElse(null)));
        }
        return chunkLoadings;
    }

    @Nullable
    private static Holder<? extends ConfiguredFeature<?, ?>> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        return switch (type) {
            case TreeGenerator.TreeType.TREE -> TreeFeatures.f_195123_;
            case TreeGenerator.TreeType.BIG_TREE -> TreeFeatures.f_195130_;
            case TreeGenerator.TreeType.REDWOOD -> TreeFeatures.f_195127_;
            case TreeGenerator.TreeType.TALL_REDWOOD -> TreeFeatures.f_195133_;
            case TreeGenerator.TreeType.MEGA_REDWOOD -> TreeFeatures.f_195134_;
            case TreeGenerator.TreeType.BIRCH -> TreeFeatures.f_195125_;
            case TreeGenerator.TreeType.JUNGLE -> TreeFeatures.f_195132_;
            case TreeGenerator.TreeType.SMALL_JUNGLE -> TreeFeatures.f_195129_;
            case TreeGenerator.TreeType.SHORT_JUNGLE -> TreeFeatures.f_195131_;
            case TreeGenerator.TreeType.JUNGLE_BUSH -> TreeFeatures.f_195138_;
            case TreeGenerator.TreeType.SWAMP -> TreeFeatures.f_195137_;
            case TreeGenerator.TreeType.ACACIA -> TreeFeatures.f_195126_;
            case TreeGenerator.TreeType.DARK_OAK -> TreeFeatures.f_195124_;
            case TreeGenerator.TreeType.TALL_BIRCH -> TreeFeatures.f_195135_;
            case TreeGenerator.TreeType.RED_MUSHROOM -> TreeFeatures.f_195122_;
            case TreeGenerator.TreeType.BROWN_MUSHROOM -> TreeFeatures.f_195121_;
            case TreeGenerator.TreeType.WARPED_FUNGUS -> TreeFeatures.f_195119_;
            case TreeGenerator.TreeType.CRIMSON_FUNGUS -> TreeFeatures.f_195117_;
            case TreeGenerator.TreeType.CHORUS_PLANT -> EndFeatures.f_194985_;
            case TreeGenerator.TreeType.RANDOM -> ForgeWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            default -> null;
        };
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) {
        ConfiguredFeature generator = Optional.ofNullable(ForgeWorld.createTreeFeatureGenerator(type)).map(Holder::m_203334_).orElse(null);
        ServerLevel world = this.getWorld();
        ServerChunkCache chunkManager = world.m_7726_();
        if (type == TreeGenerator.TreeType.CHORUS_PLANT) {
            position = position.add(0, 1, 0);
        }
        return generator != null && generator.m_224953_((WorldGenLevel)world, chunkManager.m_8481_(), random, ForgeAdapter.toBlockPos(position));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().m_46865_(ForgeAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        ServerLevel world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.m_7726_().m_7827_().m_6462_(new ChunkPos(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        return true;
    }

    @Override
    public WeatherType getWeather() {
        LevelData info = this.getWorld().m_6106_();
        if (info.m_6534_()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.m_6533_()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        ServerLevelData info = (ServerLevelData)this.getWorld().m_6106_();
        if (info.m_6534_()) {
            return info.m_6558_();
        }
        if (info.m_6533_()) {
            return info.m_6531_();
        }
        return info.m_6537_();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        ServerLevelData info = (ServerLevelData)this.getWorld().m_6106_();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.m_6393_(0);
            info.m_5557_(true);
            info.m_6398_((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.m_6393_(0);
            info.m_5565_(true);
            info.m_6399_((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.m_5565_(false);
            info.m_5557_(false);
            info.m_6393_((int)duration);
        }
    }

    @Override
    public int getMinY() {
        return this.getWorld().m_141937_();
    }

    @Override
    public int getMaxY() {
        return this.getWorld().m_151558_() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        LevelData worldInfo = this.getWorld().m_6106_();
        return BlockVector3.at(worldInfo.m_6789_(), worldInfo.m_6527_(), worldInfo.m_6526_());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        net.minecraft.world.level.block.state.BlockState mcState = this.getWorld().m_6325_(position.getBlockX() >> 4, position.getBlockZ() >> 4).m_8055_(ForgeAdapter.toBlockPos(position));
        return ForgeAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        BlockEntity tile = this.getWorld().m_46865_(pos).m_7702_(pos);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(TileEntityUtils.copyNbtData(tile)));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)o;
            Level otherWorld = (Level)other.worldRef.get();
            Level thisWorld = (Level)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof World) {
            return ((World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        ServerLevel world = this.getWorld();
        AABB box = new AABB(ForgeAdapter.toBlockPos(region.getMinimumPoint()), ForgeAdapter.toBlockPos(region.getMaximumPoint().add(BlockVector3.ONE)));
        List nmsEntities = world.m_6249_((net.minecraft.world.entity.Entity)null, box, e -> region.contains(ForgeAdapter.adapt(e.m_20183_())));
        return (List)nmsEntities.stream().map(ForgeEntity::new).collect(ImmutableList.toImmutableList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        ServerLevel world = this.getWorld();
        return (List)Streams.stream((Iterable)world.m_8583_()).map(ForgeEntity::new).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        net.minecraft.nbt.CompoundTag tag;
        ServerLevel world = this.getWorld();
        String entityId = entity.getType().getId();
        Optional entityType = EntityType.m_20632_((String)entityId);
        if (entityType.isEmpty()) {
            return null;
        }
        CompoundTag nativeTag = entity.getNbtData();
        if (nativeTag != null) {
            tag = NBTConverter.toNative(entity.getNbtData());
            this.removeUnwantedEntityTagsRecursively(tag);
        } else {
            tag = new net.minecraft.nbt.CompoundTag();
        }
        tag.m_128359_("id", entityId);
        net.minecraft.world.entity.Entity createdEntity = EntityType.m_20645_((net.minecraft.nbt.CompoundTag)tag, (Level)world, loadedEntity -> {
            loadedEntity.m_19890_(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            return loadedEntity;
        });
        if (createdEntity != null) {
            world.m_47205_(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }

    private void removeUnwantedEntityTagsRecursively(net.minecraft.nbt.CompoundTag tag) {
        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
            tag.m_128473_(name);
        }
        if (tag.m_128425_("Passengers", 9)) {
            ListTag nbttaglist = tag.m_128437_("Passengers", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                this.removeUnwantedEntityTagsRecursively(nbttaglist.m_128728_(i));
            }
        }
    }

    @Override
    public Mask createLiquidMask() {
        return new AbstractExtentMask(this){

            @Override
            public boolean test(BlockVector3 vector) {
                return ForgeAdapter.adapt(this.getExtent().getBlock(vector)).m_60734_() instanceof LiquidBlock;
            }

            @Override
            @Nullable
            public Mask2D toMask2D() {
                return null;
            }
        };
    }
}

