/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.features.Locatables;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.menu.ISubMenu;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class WTMenuHost
extends WirelessTerminalMenuHost
implements InternalInventoryHost,
ISegmentedInventory {
    private final AppEngInternalInventory singularityInventory = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final AppEngInternalInventory viewCellInventory = new AppEngInternalInventory((InternalInventoryHost)this, 5);
    private final class_1657 myPlayer;
    private boolean rangeCheck;
    private IActionHost securityTerminal;
    private IGridNode securityTerminalNode;
    private IActionHost quantumBridge;
    private IUpgradeInventory upgradeInventory;
    public static final class_2960 INV_SINGULARITY = new class_2960("ae2wtlib", "singularity");

    public WTMenuHost(class_1657 player, @Nullable Integer inventorySlot, class_1799 is, BiConsumer<class_1657, ISubMenu> returnToMainMenu) {
        super(player, inventorySlot, is, returnToMainMenu);
        this.myPlayer = player;
        this.upgradeInventory = UpgradeInventories.forItem((class_1799)is, (int)WUTHandler.getUpgradeCardCount(), this::updateUpgrades);
        if (((WirelessTerminalItem)is.method_7909()).getGridKey(is).isEmpty()) {
            return;
        }
        this.securityTerminal = (IActionHost)Locatables.securityStations().get(player.field_6002, ((WirelessTerminalItem)is.method_7909()).getGridKey(is).getAsLong());
        if (this.securityTerminal != null) {
            this.securityTerminalNode = this.securityTerminal.getActionableNode();
        }
    }

    public void updateUpgrades(class_1799 stack, IUpgradeInventory upgrades) {
        this.upgradeInventory = upgrades;
    }

    protected void readFromNbt() {
        class_2487 tag = this.getItemStack().method_7948();
        this.viewCellInventory.readFromNBT(tag, "viewcells");
        this.singularityInventory.readFromNBT(tag, "singularity");
    }

    public void saveChanges() {
        class_2487 tag = this.getItemStack().method_7948();
        this.viewCellInventory.writeToNBT(tag, "viewcells");
        this.singularityInventory.writeToNBT(tag, "singularity");
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
    }

    public IGridNode getActionableNode() {
        IGridNode node = super.getActionableNode();
        if (node != null) {
            return node;
        }
        return this.securityTerminalNode;
    }

    public boolean rangeCheck() {
        this.rangeCheck = super.rangeCheck();
        return this.isQuantumLinked() || this.rangeCheck;
    }

    public boolean hasQuantumUpgrade() {
        return this.upgradeInventory.isInstalled((class_1935)AE2wtlib.QUANTUM_BRIDGE_CARD);
    }

    public boolean isQuantumLinked() {
        if (this.getPlayer().method_37908().method_8608()) {
            return true;
        }
        if (!this.hasQuantumUpgrade()) {
            return false;
        }
        long frequency = this.getQEFrequency();
        if (frequency == 0L) {
            return false;
        }
        if (this.quantumBridge == null) {
            if (!this.findQuantumBridge(frequency)) {
                return false;
            }
        } else {
            IActionHost iActionHost = this.quantumBridge;
            if (iActionHost instanceof QuantumCluster) {
                QuantumCluster quantumCluster = (QuantumCluster)iActionHost;
                if (quantumCluster.getCenter() == null) {
                    return false;
                }
                long frequencyOther = quantumCluster.getCenter().getQEFrequency();
                if (frequencyOther != frequency && frequencyOther != -frequency && !this.findQuantumBridge(frequency)) {
                    return false;
                }
            } else if (!this.findQuantumBridge(frequency)) {
                return false;
            }
        }
        if (this.quantumBridge.getActionableNode() == null || this.securityTerminalNode == null) {
            return false;
        }
        return this.quantumBridge.getActionableNode().getGrid() == this.securityTerminalNode.getGrid();
    }

    private long getQEFrequency() {
        class_2487 c;
        class_1799 is = this.singularityInventory.getStackInSlot(0);
        if (!is.method_7960() && (c = is.method_7969()) != null) {
            return c.method_10537("freq");
        }
        return 0L;
    }

    private boolean findQuantumBridge(long frequency) {
        this.quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(this.getPlayer().method_37908(), frequency);
        if (this.quantumBridge == null) {
            this.quantumBridge = (IActionHost)Locatables.quantumNetworkBridges().get(this.getPlayer().method_37908(), -frequency);
        }
        return this.quantumBridge != null;
    }

    public class_1657 getPlayer() {
        return this.myPlayer;
    }

    public AppEngInternalInventory getViewCellStorage() {
        return this.viewCellInventory;
    }

    protected void setPowerDrainPerTick(double powerDrainPerTick) {
        if (this.rangeCheck) {
            super.setPowerDrainPerTick(powerDrainPerTick);
        } else {
            super.setPowerDrainPerTick(AE2wtlibConfig.INSTANCE.getOutOfRangePower());
        }
    }

    public boolean drainPower() {
        if (!super.drainPower()) {
            return false;
        }
        this.recharge();
        return true;
    }

    private void recharge() {
        if (this.quantumBridge == null) {
            return;
        }
        class_1792 class_17922 = this.getItemStack().method_7909();
        if (class_17922 instanceof AEBasePoweredItem) {
            AEBasePoweredItem item = (AEBasePoweredItem)class_17922;
            double currentPower = item.getAECurrentPower(this.getItemStack());
            double maxPower = item.getAEMaxPower(this.getItemStack());
            double missing = maxPower - currentPower;
            if (this.getActionableNode() == null) {
                return;
            }
            double extracted = this.getActionableNode().getGrid().getEnergyService().extractAEPower(missing, Actionable.MODULATE, PowerMultiplier.ONE);
            item.injectAEPower(this.getItemStack(), extracted, Actionable.MODULATE);
        }
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)INV_SINGULARITY)) {
            return this.singularityInventory;
        }
        return null;
    }

    public boolean stillValid() {
        return this.ensureItemStillInSlot();
    }

    public IActionHost getActionHost() {
        return this.securityTerminal;
    }

    protected boolean ensureItemStillInSlot() {
        if (this.getSlot() != null) {
            return super.ensureItemStillInSlot();
        }
        return Platform.isStillPresentTrinkets(this.getPlayer(), this.getItemStack());
    }
}

