/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeableItem;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.networking.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.RestockAmountPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetSettings;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.class_1301;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class MagnetHandler {
    private static final WeakHashMap<class_3222, Integer> players = new WeakHashMap();

    public static void handle(class_3222 player, class_1799 terminal) {
        if (players.containsKey(player) && players.get(player) == MagnetHandler.getTick(player)) {
            return;
        }
        MagnetHandler.sendRestockAble(player, terminal);
        MagnetHandler.handleMagnet((class_1657)player, terminal);
        players.put(player, MagnetHandler.getTick(player));
    }

    private static int getTick(class_3222 player) {
        if (player.method_5682() == null) {
            return -1;
        }
        return player.method_5682().method_3780();
    }

    private static void sendRestockAble(class_3222 player, class_1799 terminal) {
        if (player.method_7337()) {
            return;
        }
        if (!ItemWT.getBoolean(terminal, "restock")) {
            return;
        }
        MagnetHandler.sendRestockAble(player);
    }

    private static void sendRestockAble(class_3222 player) {
        CraftingTerminalHandler handler = CraftingTerminalHandler.getCraftingTerminalHandler((class_1657)player);
        if (!ItemWT.getBoolean(handler.getCraftingTerminal(), "restock") || !handler.inRange()) {
            return;
        }
        HashMap<class_1792, Long> items = new HashMap<class_1792, Long>();
        if (handler.getTargetGrid() == null || handler.getTargetGrid().getStorageService().getInventory() == null) {
            return;
        }
        KeyCounter storageList = handler.getTargetGrid().getStorageService().getInventory().getAvailableStacks();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || items.containsKey(stack.method_7909())) continue;
            AEItemKey key = AEItemKey.of((class_1799)stack);
            if (key == null) {
                items.put(stack.method_7909(), 0L);
                continue;
            }
            items.put(stack.method_7909(), storageList.get((AEKey)key));
        }
        ServerNetworkManager.sendToClient(player, new RestockAmountPacket(items));
    }

    private static void handleMagnet(class_1657 player, class_1799 terminal) {
        if (player.method_5715()) {
            return;
        }
        if (!MagnetHandler.getMagnetSettings(terminal).isActive()) {
            return;
        }
        MagnetHandler.handleMagnet(player);
    }

    private static void handleMagnet(class_1657 player) {
        CraftingTerminalHandler ctHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        if (!MagnetHandler.getMagnetSettings(ctHandler.getCraftingTerminal()).isActive()) {
            return;
        }
        MagnetHost magnetHost = ctHandler.getMagnetHost();
        if (magnetHost == null) {
            return;
        }
        List entityItems = player.method_37908().method_8390(class_1542.class, player.method_5829().method_1014(AE2wtlibConfig.INSTANCE.magnetCardRange()), class_1301.field_6154);
        for (class_1542 entityItemNearby : entityItems) {
            AEItemKey item = AEItemKey.of((class_1799)entityItemNearby.method_6983());
            if (item == null || !magnetHost.getPickupFilter().matchesFilter((AEKey)item, magnetHost.getPickupMode()) || Platform.preventRemoteMovement(entityItemNearby)) continue;
            entityItemNearby.method_5694(player);
        }
    }

    public static void saveMagnetSettings(class_1799 terminal, MagnetSettings magnetSettings) {
        IUpgradeableItem upgradeableItem;
        class_1792 class_17922 = terminal.method_7909();
        if (class_17922 instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)class_17922).getUpgrades(terminal).isInstalled((class_1935)AE2wtlib.MAGNET_CARD)) {
            terminal.method_7948().method_10566("magnet_settings", (class_2520)magnetSettings.toTag());
        }
    }

    public static MagnetSettings getMagnetSettings(class_1799 terminal) {
        IUpgradeableItem upgradeableItem;
        class_1792 class_17922 = terminal.method_7909();
        if (class_17922 instanceof IUpgradeableItem && (upgradeableItem = (IUpgradeableItem)class_17922).getUpgrades(terminal).isInstalled((class_1935)AE2wtlib.MAGNET_CARD)) {
            return new MagnetSettings((class_2487)terminal.method_7948().method_10580("magnet_settings"));
        }
        return new MagnetSettings();
    }
}

