/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.menu.AutomationNasaWorkbenchMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import ad_astra_giselle_addon.common.world.ContainerUtils;
import earth.terrarium.ad_astra.common.recipe.IngredientHolder;
import earth.terrarium.ad_astra.common.recipe.NasaWorkbenchRecipe;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.SimpleUpdatingEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomationNasaWorkbenchBlockEntity
extends AddonMachineBlockEntity
implements EnergyBlock {
    public static final int RESULT_SLOT = 14;
    public static final String DATA_COOK_TIME_KEY = "cookTime";
    public static final String DATA_COOK_TIME_TOTAL_KEY = "cookTimeTotal";
    private SimpleUpdatingEnergyContainer energyStorage;
    private boolean firstTick = true;
    private List<RecipeCache> recipaCaches = new ArrayList<RecipeCache>();
    private NasaWorkbenchRecipe selectedRecipe = null;
    private int cookTime;
    private int cookTimeTotal;

    public AutomationNasaWorkbenchBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AddonBlockEntityTypes.AUTOMATION_NASA_WORKBENCH.get(), pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cookTime = nbt.method_10550(DATA_COOK_TIME_KEY);
        this.cookTimeTotal = nbt.method_10550(DATA_COOK_TIME_TOTAL_KEY);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569(DATA_COOK_TIME_KEY, this.cookTime);
        nbt.method_10569(DATA_COOK_TIME_TOTAL_KEY, this.cookTimeTotal);
    }

    public class_1703 createMenu(int syncId, @NotNull class_1661 inv, @NotNull class_1657 player) {
        return new AutomationNasaWorkbenchMenu(syncId, inv, this);
    }

    public void update() {
    }

    public int getInventorySize() {
        return 15;
    }

    @Override
    public int getSideSlotLimit(int slot, @Nullable class_2350 directon) {
        return 1;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        if (slot == 14) {
            return false;
        }
        return this.recipaCaches.stream().filter(cache -> cache.testRemain(slot, stack)).findAny().isPresent();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 14;
    }

    public SimpleUpdatingEnergyContainer getEnergyStorage() {
        if (this.energyStorage == null) {
            this.energyStorage = new SimpleUpdatingEnergyContainer((Updatable)this, MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY);
        }
        return this.energyStorage;
    }

    public void tick() {
        if (!this.method_10997().method_8608()) {
            if (this.firstTick) {
                this.firstTick = false;
                this.cacheRecipes();
            }
            if (this.recipaCaches.stream().anyMatch(RecipeCache::anyAdded)) {
                this.spawnWorkingParticles();
            }
            this.cook();
        }
    }

    public void spawnWorkingParticles() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2338 pos = this.method_11016();
            ModUtils.spawnForcedParticles((class_3218)level, (class_2394)class_2398.field_11205, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 1.5), (double)((double)pos.method_10260() + 0.5), (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.1);
        }
    }

    public void spawnResultParticles() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_2338 pos = this.method_11016();
            ModUtils.spawnForcedParticles((class_3218)level, (class_2394)class_2398.field_11220, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 1.5), (double)((double)pos.method_10260() + 0.5), (int)100, (double)0.1, (double)0.1, (double)0.1, (double)0.7);
            level.method_8396(null, pos, class_3417.field_14931, class_3419.field_15254, 1.0f, 1.0f);
        }
    }

    private void cook() {
        NasaWorkbenchRecipe recipe = this.selectedRecipe;
        if (recipe == null) {
            return;
        }
        class_2371 items = this.getItems();
        List ingredients = recipe.getHolders();
        class_1799 resultItem = recipe.method_8110();
        if (this.testIngredientCounts(recipe.getHolders(), (List<class_1799>)items) && ContainerUtils.insert((class_1263)this, 14, resultItem, true).method_7960() && this.extractEnergy(true)) {
            this.setCookTime(this.getCookTime() + 1);
            this.extractEnergy(false);
            if (this.getCookTime() >= this.getCookTimeTotal()) {
                for (int i = 0; i < 14; ++i) {
                    ((class_1799)items.get(i)).method_7934(((IngredientHolder)ingredients.get(i)).count());
                }
                this.setCookTime(0);
                ContainerUtils.insert((class_1263)this, 14, resultItem, false);
                this.spawnResultParticles();
            }
        } else {
            this.setCookTime(0);
        }
    }

    public boolean extractEnergy(boolean simulate) {
        long extracting = MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_USAGE;
        PlatformEnergyManager energyManager = EnergyHooks.getBlockEnergyManager((class_2586)this, null);
        return energyManager.extract(extracting, simulate) == extracting;
    }

    private void cacheRecipes() {
        class_2371 items = this.getItems();
        List recipes = NasaWorkbenchRecipe.getRecipes((class_1937)this.method_10997());
        this.recipaCaches.clear();
        this.recipaCaches.addAll(recipes.stream().map(arg_0 -> this.lambda$cacheRecipes$1((List)items, arg_0)).filter(cache -> cache != null).toList());
        this.selectedRecipe = this.recipaCaches.stream().filter(arg_0 -> this.lambda$cacheRecipes$3((List)items, arg_0)).map(RecipeCache::recipe).findFirst().orElse(null);
        if (this.selectedRecipe == null) {
            this.setCookTimeTotal(0);
        } else {
            this.setCookTimeTotal(MachinesConfig.AUTOMATION_NASA_WORKBENCH_COOK_TIME);
        }
    }

    private boolean test(RecipeCache cache, List<class_1799> items) {
        return cache.isComplete() && this.testIngredientCounts(cache.recipe().getHolders(), items);
    }

    private boolean testIngredientCounts(List<IngredientHolder> ingredients, List<class_1799> items) {
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799 item = items.get(i);
            IngredientHolder ingredient = ingredients.get(i);
            if (item.method_7947() >= ingredient.count()) continue;
            return false;
        }
        return true;
    }

    private RecipeCache cache(NasaWorkbenchRecipe recipe, List<class_1799> items) {
        List ingredients = recipe.getHolders();
        ArrayList<SlotWithIngredient> remainIngredients = new ArrayList<SlotWithIngredient>();
        boolean mismatched = false;
        boolean anyAdded = false;
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799 item = items.get(i);
            class_1856 ingredient = ((IngredientHolder)ingredients.get(i)).ingredient();
            boolean needAdd = false;
            if (item.method_7960()) {
                needAdd = true;
            } else if (!ingredient.method_8093(item)) {
                needAdd = true;
                mismatched = true;
            } else {
                anyAdded = true;
            }
            if (!needAdd) continue;
            remainIngredients.add(new SlotWithIngredient(i, ingredient));
        }
        if (!mismatched) {
            return new RecipeCache(recipe, remainIngredients, anyAdded);
        }
        return null;
    }

    public void method_5431() {
        super.method_5431();
        if (this.method_10997() instanceof class_3218) {
            this.cacheRecipes();
        }
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        cookTime = class_3532.method_15340((int)cookTime, (int)0, (int)this.getCookTimeTotal());
        if (this.getCookTime() != cookTime) {
            this.cookTime = cookTime;
        }
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    protected void setCookTimeTotal(int cookTimeTotal) {
        cookTimeTotal = Math.max(cookTimeTotal, 0);
        if (this.getCookTimeTotal() != cookTimeTotal) {
            this.cookTimeTotal = cookTimeTotal;
            this.setCookTime(this.getCookTime());
        }
    }

    private /* synthetic */ boolean lambda$cacheRecipes$3(List items, RecipeCache cache) {
        return this.test(cache, items);
    }

    private /* synthetic */ RecipeCache lambda$cacheRecipes$1(List items, NasaWorkbenchRecipe recipe) {
        return this.cache(recipe, items);
    }

    private record RecipeCache(NasaWorkbenchRecipe recipe, List<SlotWithIngredient> remainIngredients, boolean anyAdded) {
        public boolean testRemain(int putSlot, class_1799 item) {
            List<SlotWithIngredient> remainIngredients = this.remainIngredients();
            return remainIngredients.stream().filter(i -> i.test(putSlot, item)).findAny().isPresent();
        }

        public boolean isComplete() {
            return this.remainIngredients().size() == 0;
        }
    }

    private record SlotWithIngredient(int slot, class_1856 ingredient) {
        public boolean test(int putSlot, class_1799 item) {
            return putSlot == this.slot() && this.ingredient().method_8093(item);
        }
    }
}

