/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemStackUtils;
import ad_astra_giselle_addon.common.menu.FuelLoaderMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.SimpleUpdatingFluidContainer;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class FuelLoaderBlockEntity
extends AddonMachineBlockEntity
implements FluidHoldingBlock,
IRangedWorkingAreaBlockEntity {
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int SLOTS_FLUID = 2;
    public static final int SLOT_FLUID_SOURCE = 0;
    public static final int SLOT_FLUID_SINK = 1;
    private boolean workingAreaVisible;
    private SimpleUpdatingFluidContainer fluidTank;

    public FuelLoaderBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AddonBlockEntityTypes.FUEL_LOADER.get(), pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.workingAreaVisible = nbt.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    public int method_5444() {
        return 1;
    }

    public SimpleUpdatingFluidContainer getFluidContainer() {
        if (this.fluidTank == null) {
            this.fluidTank = new SimpleUpdatingFluidContainer((Updatable)this, tank -> MachinesConfig.FUEL_LOADER_FLUID_CAPACITY, 1, FluidPredicates::isFuel);
            return this.fluidTank;
        }
        return this.fluidTank;
    }

    public void update() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public int getInventorySize() {
        return super.getInventorySize() + this.getSlotsFluid();
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        stack = ItemStackUtils.deriveCount(stack, 1);
        if (slot == this.getSlotFluidSource()) {
            if (FluidHooks.isFluidContainingItem((class_1799)stack)) {
                UniveralFluidHandler itemFluidHandler = UniveralFluidHandler.from(new ItemStackHolder(stack));
                return itemFluidHandler.getFluidTanks().stream().anyMatch(FluidPredicates::isFuel);
            }
            return false;
        }
        if (slot == this.getSlotFluidSink()) {
            return dir == null;
        }
        return super.method_5492(slot, stack, dir);
    }

    public boolean method_5493(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == this.getSlotFluidSource()) {
            if (FluidHooks.isFluidContainingItem((class_1799)stack)) {
                UniveralFluidHandler itemFluidHandler = UniveralFluidHandler.from(new ItemStackHolder(stack));
                return !itemFluidHandler.getFluidTanks().stream().anyMatch(FluidPredicates::isFuel);
            }
        } else if (slot == this.getSlotFluidSink()) {
            return dir == null;
        }
        return super.method_5493(slot, stack, dir);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new FuelLoaderMenu(windowId, inv, this);
    }

    public void tick() {
        class_1937 level = this.method_10997();
        if (!level.method_8608()) {
            this.processTank();
            this.exchangeFuelItemAround();
        }
    }

    public void processTank() {
        UniveralFluidHandler tank = UniveralFluidHandler.from((FluidContainer)this.getFluidContainer());
        UniveralFluidHandler.fromSafe(this.getItemRef(this.getSlotFluidSource())).ifPresent(source -> FluidHooks2.moveFluidAny(source, tank, FluidPredicates::isFuel, false));
        UniveralFluidHandler.fromSafe(this.getItemRef(this.getSlotFluidSink())).ifPresent(sink -> FluidHooks2.moveFluidAny(tank, sink, null, false));
    }

    public ItemStackReference getItemRef(int slot) {
        return new ItemStackReference(this.method_5438(slot), ItemStackConsumers.index(slot, this::method_5447));
    }

    public void exchangeFuelItemAround() {
        class_1937 level = this.method_10997();
        class_238 workingArea = this.getWorkingArea();
        List vehicles = level.method_18467(Vehicle.class, workingArea);
        for (Vehicle vehicle : vehicles) {
            this.giveFuel(vehicle);
        }
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.method_5431();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.FUEL_LOADER_WORKING_RANGE;
    }

    @Override
    public class_238 getWorkingArea(double range) {
        return this.getWorkingArea(this.method_11016(), range);
    }

    public FluidHolder giveFuel(Vehicle vehicle) {
        return this.giveFuel(vehicle, MachinesConfig.FUEL_LOADER_FLUID_TRANSFER);
    }

    private FluidHolder giveFuel(Vehicle vehicle, long transfer) {
        UniveralFluidHandler from = UniveralFluidHandler.from((FluidContainer)this.getFluidContainer());
        UniveralFluidHandler to = UniveralFluidHandler.from((FluidContainer)vehicle.getTank());
        return FluidHooks2.moveFluidAny(from, to, FluidPredicates::isFuel, transfer, false);
    }

    public int getSlotFluidStart() {
        return 0;
    }

    public int getSlotFluidEnd() {
        return this.getSlotFluidStart() + this.getSlotsFluid();
    }

    public int getSlotsFluid() {
        return 2;
    }

    public int getSlotFluidSource() {
        return this.getSlotFluidStart() + 0;
    }

    public int getSlotFluidSink() {
        return this.getSlotFluidStart() + 1;
    }
}

