/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.content.proof.GravityNormalizingUtils;
import ad_astra_giselle_addon.common.menu.GravityNormalizerMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import ad_astra_giselle_addon.common.util.Vec3iUtils;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.SimpleUpdatingEnergyContainer;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class GravityNormalizerBlockEntity
extends AddonMachineBlockEntity
implements EnergyBlock,
IWorkingAreaBlockEntity {
    public static final String DATA_LENGTH_KEY = "length";
    public static final String DATA_OFFSET_KEY = "offset";
    public static final String DATA_TIMER_KEY = "timer";
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    private SimpleUpdatingEnergyContainer energyStorage;
    private class_2382 length = new class_2382(3, 3, 3);
    private class_2382 offset = GravityNormalizerBlockEntity.offsetFromLength(this.length);
    private int timer = 0;
    private boolean workingAreaVisible = false;

    public GravityNormalizerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AddonBlockEntityTypes.GRAVITY_NORMALIZER.get(), pos, state);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new GravityNormalizerMenu(windowId, inv, this);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.length = (class_2382)class_2382.field_25123.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(DATA_LENGTH_KEY)).result().get();
        this.offset = (class_2382)class_2382.field_25123.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10580(DATA_OFFSET_KEY)).result().get();
        this.timer = nbt.method_10550(DATA_TIMER_KEY);
        this.workingAreaVisible = nbt.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566(DATA_LENGTH_KEY, (class_2520)class_2382.field_25123.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.length).result().get());
        nbt.method_10566(DATA_OFFSET_KEY, (class_2520)class_2382.field_25123.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.offset).result().get());
        nbt.method_10569(DATA_TIMER_KEY, this.timer);
        nbt.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    public SimpleUpdatingEnergyContainer getEnergyStorage() {
        if (this.energyStorage == null) {
            this.energyStorage = new SimpleUpdatingEnergyContainer((Updatable)this, MachinesConfig.GRAVITY_NORMALIZER_ENERGY_CAPACITY){

                public long maxExtract() {
                    return this.getMaxCapacity();
                }

                public long maxInsert() {
                    return this.getMaxCapacity();
                }
            };
        }
        return this.energyStorage;
    }

    public void update() {
    }

    public void tick() {
        int timer = this.getTimer();
        if (--timer <= 0) {
            timer = this.getMaxTimer();
            class_238 workingArea = this.getWorkingArea();
            this.doNormalize(workingArea);
            this.method_5431();
        }
        this.setTimer(timer);
    }

    protected void doNormalize(class_238 workingArea) {
        class_1937 level = this.method_10997();
        GravityNormalizingUtils proof = GravityNormalizingUtils.INSTANCE;
        long energyUsing = this.getEnergyUsing(workingArea);
        PlatformEnergyManager energyManager = EnergyHooks.getBlockEnergyManager((class_2586)this, null);
        if (energyManager.extract(energyUsing, true) < energyUsing) {
            return;
        }
        List livings = level.method_18467(class_1309.class, workingArea);
        if (livings.size() <= 0) {
            return;
        }
        energyManager.extract(energyUsing, false);
        int proofDuration = this.getMaxTimer() + 1;
        for (class_1309 entity : livings) {
            if (proof.getProofDuration(entity) > proofDuration) continue;
            proof.setProofDuration(entity, proofDuration);
        }
    }

    public long getEnergyUsing() {
        return this.getEnergyUsing(this.getWorkingArea());
    }

    public long getEnergyUsing(class_238 workingArea) {
        double blocks = workingArea.method_17939() * workingArea.method_17940() * workingArea.method_17941();
        return (long)(MachinesConfig.GRAVITY_NORMALIZER_ENERGY_PER_BLOCKS * blocks);
    }

    public static int getMinLength() {
        return 1;
    }

    public static int getMaxLength() {
        return MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH;
    }

    public class_2382 getLength() {
        return this.length;
    }

    public void setLength(class_2382 length) {
        length = Vec3iUtils.clamp(length, GravityNormalizerBlockEntity.getMinLength(), GravityNormalizerBlockEntity.getMaxLength());
        if (!this.getLength().equals((Object)length)) {
            this.length = length;
            this.method_5431();
        }
    }

    public static int half(int length) {
        return (length - 1) / 2;
    }

    public static int offsetFromLength(int length) {
        return -GravityNormalizerBlockEntity.half(length);
    }

    public static class_2382 offsetFromLength(class_2382 length) {
        int x = GravityNormalizerBlockEntity.offsetFromLength(length.method_10263());
        int y = 0;
        int z = GravityNormalizerBlockEntity.offsetFromLength(length.method_10260());
        return new class_2382(x, y, z);
    }

    public static int getMinOffset() {
        return -GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public static int getMaxOffset() {
        return GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public class_2382 getOffset() {
        return this.offset;
    }

    public void setOffset(class_2382 offset) {
        offset = Vec3iUtils.clamp(offset, GravityNormalizerBlockEntity.getMinOffset(), GravityNormalizerBlockEntity.getMaxOffset());
        if (!this.getOffset().equals((Object)offset)) {
            this.offset = offset;
            this.method_5431();
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        timer = Math.max(timer, 0);
        if (this.getTimer() != timer) {
            this.timer = timer;
        }
    }

    public int getMaxTimer() {
        return MachinesConfig.GRAVITY_NORMALIZER_PROOF_DURATION;
    }

    @Override
    public class_238 getWorkingArea() {
        return this.getWorkingArea(this.method_11016());
    }

    @Override
    public class_238 getWorkingArea(class_2338 pos) {
        class_2382 length = this.getLength();
        class_2382 offset = this.getOffset();
        double x = ((double)length.method_10263() - 1.0) / 2.0;
        double y = ((double)length.method_10264() - 1.0) / 2.0;
        double z = ((double)length.method_10260() - 1.0) / 2.0;
        return new class_238(pos).method_1009(x, y, z).method_989(x + (double)offset.method_10263(), y + (double)offset.method_10264(), z + (double)offset.method_10260());
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.method_5431();
        }
    }
}

