/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.ad_astra.common.item.OxygenTankItem;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static void distributeToItems(class_1309 living) {
        OxygenChargerUtils.streamExtractable(living, FluidHooks2.MILLI_BUCKET).forEach(c -> OxygenChargerUtils.distributeToItems(living, c));
    }

    public static void distributeToItems(class_1309 living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        UniveralFluidHandler itemFluidHandler;
        ItemStackReference itemRef;
        class_1792 item;
        UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().method_7909()) instanceof SpaceSuit) && !(item instanceof OxygenTankItem) || (itemFluidHandler = (UniveralFluidHandler)UniveralFluidHandler.fromSafe(itemRef).orElse(null)) == null || (moved = FluidHooks2.moveFluidAny(fluidHandler, itemFluidHandler, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    public static OptionalDouble getExtractableStoredRatio(class_1309 living) {
        List<ItemStackReference> items = LivingHelper.getInventoryStacks(living);
        long stored = 0L;
        long capacity = 0L;
        int temperature = (int)ModUtils.getWorldTemperature((class_1937)living.method_37908());
        for (ItemStackReference item : items) {
            IOxygenCharger oxygenCharger = OxygenChargerUtils.get(item);
            if (oxygenCharger == null || !oxygenCharger.getTemperatureThreshold().contains((Object)temperature)) continue;
            stored += oxygenCharger.getTotalAmount();
            capacity += oxygenCharger.getTotalCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenCharger firstExtractable(class_1309 living, long extracting) {
        return OxygenChargerUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenCharger> streamExtractable(class_1309 living, long extracting) {
        int temperature = (int)ModUtils.getWorldTemperature((class_1937)living.method_37908());
        return LivingHelper.getInventoryStacks(living).stream().map(OxygenChargerUtils::get).filter(oxygenCharger -> {
            FluidHolder extract;
            return oxygenCharger != null && oxygenCharger.getTemperatureThreshold().contains((Object)temperature) && !(extract = FluidHooks2.extractFluid(oxygenCharger.getFluidHandler(), FluidPredicates::isOxygen, extracting, true)).isEmpty() && extract.getFluidAmount() >= extracting;
        });
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        class_1792 class_17922 = item.getStack().method_7909();
        if (class_17922 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)class_17922;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

